/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.ParameterList;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class OAuthRequest {
    private static final String OAUTH_PREFIX = "oauth_";
    private final String url;
    private final Verb verb;
    private final ParameterList querystringParams = new ParameterList();
    private final ParameterList bodyParams = new ParameterList();
    private final Map<String, String> headers = new HashMap<String, String>();
    private String charset;
    private String stringPayload;
    private byte[] byteArrayPayload;
    private File filePayload;
    private final Map<String, String> oauthParameters = new HashMap<String, String>();
    private String realm;

    public OAuthRequest(Verb verb, String string) {
        this.verb = verb;
        this.url = string;
    }

    public void addOAuthParameter(String string, String string2) {
        this.oauthParameters.put(this.checkKey(string), string2);
    }

    private String checkKey(String string) {
        if (string.startsWith(OAUTH_PREFIX) || string.equals("scope") || string.equals("realm")) {
            return string;
        }
        throw new IllegalArgumentException(String.format("OAuth parameters must either be '%s', '%s' or start with '%s'", "scope", "realm", OAUTH_PREFIX));
    }

    public Map<String, String> getOauthParameters() {
        return this.oauthParameters;
    }

    public void setRealm(String string) {
        this.realm = string;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getCompleteUrl() {
        return this.querystringParams.appendTo(this.url);
    }

    public void addHeader(String string, String string2) {
        this.headers.put(string, string2);
    }

    public void addBodyParameter(String string, String string2) {
        this.bodyParams.add(string, string2);
    }

    public void addQuerystringParameter(String string, String string2) {
        this.querystringParams.add(string, string2);
    }

    public void addParameter(String string, String string2) {
        if (this.verb.isPermitBody()) {
            this.bodyParams.add(string, string2);
        } else {
            this.querystringParams.add(string, string2);
        }
    }

    public void setPayload(String string) {
        this.resetPayload();
        this.stringPayload = string;
    }

    public void setPayload(byte[] byArray) {
        this.resetPayload();
        this.byteArrayPayload = (byte[])byArray.clone();
    }

    public void setPayload(File file) {
        this.resetPayload();
        this.filePayload = file;
    }

    private void resetPayload() {
        this.stringPayload = null;
        this.byteArrayPayload = null;
        this.filePayload = null;
    }

    public ParameterList getQueryStringParams() {
        try {
            ParameterList parameterList = new ParameterList();
            String string = new URL(this.url).getQuery();
            parameterList.addQuerystring(string);
            parameterList.addAll(this.querystringParams);
            return parameterList;
        }
        catch (MalformedURLException malformedURLException) {
            throw new OAuthException("Malformed URL", malformedURLException);
        }
    }

    public ParameterList getBodyParams() {
        return this.bodyParams;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSanitizedUrl() {
        if (this.url.startsWith("http://") && (this.url.endsWith(":80") || this.url.contains(":80/"))) {
            return this.url.replaceAll("\\?.*", "").replaceAll(":80", "");
        }
        if (this.url.startsWith("https://") && (this.url.endsWith(":443") || this.url.contains(":443/"))) {
            return this.url.replaceAll("\\?.*", "").replaceAll(":443", "");
        }
        return this.url.replaceAll("\\?.*", "");
    }

    public String getStringPayload() {
        return this.stringPayload;
    }

    public byte[] getByteArrayPayload() {
        if (this.byteArrayPayload != null) {
            return this.byteArrayPayload;
        }
        String string = this.bodyParams.asFormUrlEncodedString();
        try {
            return string.getBytes(this.getCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OAuthException("Unsupported Charset: " + this.getCharset(), unsupportedEncodingException);
        }
    }

    public File getFilePayload() {
        return this.filePayload;
    }

    public String toString() {
        return String.format("@Request(%s %s)", new Object[]{this.getVerb(), this.getUrl()});
    }

    public Verb getVerb() {
        return this.verb;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getCharset() {
        return this.charset == null ? Charset.defaultCharset().name() : this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public static interface ResponseConverter<T> {
        public T convert(Response var1) throws IOException;
    }
}

