/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.yaml;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;

public final class UTF8Reader
extends Reader {
    private static final int DEFAULT_BUFFER_SIZE = 8000;
    protected static final ThreadLocal<SoftReference<byte[][]>> _bufferRecycler = new ThreadLocal();
    protected final byte[][] _bufferHolder;
    private InputStream _inputSource;
    private final boolean _autoClose;
    protected byte[] _inputBuffer;
    protected int _inputPtr;
    protected int _inputEnd;
    protected int _surrogate = -1;
    int _charCount = 0;
    int _byteCount = 0;
    private char[] _tmpBuffer = null;

    public UTF8Reader(InputStream inputStream, boolean bl2) {
        super(inputStream == null ? new Object() : inputStream);
        this._inputSource = inputStream;
        this._bufferHolder = UTF8Reader._findBufferHolder();
        byte[] byArray = this._bufferHolder[0];
        if (byArray == null) {
            byArray = new byte[8000];
        } else {
            this._bufferHolder[0] = null;
        }
        this._inputBuffer = byArray;
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._autoClose = bl2;
    }

    public UTF8Reader(byte[] byArray, int n2, int n3, boolean bl2) {
        super(new Object());
        this._inputSource = null;
        this._inputBuffer = byArray;
        this._inputPtr = n2;
        this._inputEnd = n2 + n3;
        this._autoClose = bl2;
        this._bufferHolder = null;
    }

    private static byte[][] _findBufferHolder() {
        Object object = null;
        SoftReference<byte[][]> softReference = _bufferRecycler.get();
        if (softReference != null) {
            object = softReference.get();
        }
        if (object == null) {
            object = new byte[1][];
            _bufferRecycler.set(new SoftReference<byte[][]>((byte[][])object));
        }
        return object;
    }

    protected final boolean canModifyBuffer() {
        return this._bufferHolder != null;
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream = this._inputSource;
        if (inputStream != null) {
            this._inputSource = null;
            if (this._autoClose) {
                inputStream.close();
            }
        }
        this.freeBuffers();
    }

    @Override
    public int read() throws IOException {
        if (this._tmpBuffer == null) {
            this._tmpBuffer = new char[1];
        }
        if (this.read(this._tmpBuffer, 0, 1) < 1) {
            return -1;
        }
        return this._tmpBuffer[0];
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(char[] var1_1, int var2_2, int var3_3) throws IOException {
        if (this._inputBuffer == null) {
            return -1;
        }
        var3_3 += var2_2;
        var4_4 = var2_2;
        if (this._surrogate >= 0) {
            var1_1[var4_4++] = (char)this._surrogate;
            this._surrogate = -1;
            if (this._inputPtr >= this._inputEnd) {
                ++this._charCount;
                return 1;
            }
        } else {
            var5_5 = this._inputEnd - this._inputPtr;
            if (!(var5_5 >= 4 || var5_5 >= 1 && this._inputBuffer[this._inputPtr] >= 0 || this.loadMore(var5_5))) {
                return -1;
            }
        }
        var5_6 = this._inputBuffer;
        var6_7 = this._inputPtr;
        var7_8 = this._inputEnd;
        block0: while (var4_4 < var3_3) {
            if ((var8_9 = var5_6[var6_7++]) < 0) ** GOTO lbl28
            var1_1[var4_4++] = (char)var8_9;
            var10_11 = var7_8 - var6_7;
            var9_10 = var3_3 - var4_4;
            var11_12 = var6_7 + (var10_11 < var9_10 ? var10_11 : var9_10);
            while (var6_7 < var11_12) {
                if ((var8_9 = var5_6[var6_7++]) >= 0) {
                    var1_1[var4_4++] = (char)var8_9;
                    continue;
                }
lbl28:
                // 3 sources

                if ((var8_9 & 224) == 192) {
                    var8_9 &= 31;
                    var9_10 = 1;
                } else if ((var8_9 & 240) == 224) {
                    var8_9 &= 15;
                    var9_10 = 2;
                } else if ((var8_9 & 248) == 240) {
                    var8_9 &= 15;
                    var9_10 = 3;
                } else {
                    this.reportInvalidInitial(var8_9 & 255, var4_4 - var2_2);
                    var9_10 = 1;
                }
                if (var7_8 - var6_7 < var9_10) {
                    --var6_7;
                    break block0;
                }
                if (((var10_11 = var5_6[var6_7++]) & 192) != 128) {
                    this.reportInvalidOther(var10_11 & 255, var4_4 - var2_2);
                }
                var8_9 = var8_9 << 6 | var10_11 & 63;
                if (var9_10 > 1) {
                    if (((var10_11 = var5_6[var6_7++]) & 192) != 128) {
                        this.reportInvalidOther(var10_11 & 255, var4_4 - var2_2);
                    }
                    var8_9 = var8_9 << 6 | var10_11 & 63;
                    if (var9_10 > 2) {
                        if (((var10_11 = var5_6[var6_7++]) & 192) != 128) {
                            this.reportInvalidOther(var10_11 & 255, var4_4 - var2_2);
                        }
                        var8_9 = var8_9 << 6 | var10_11 & 63;
                        var1_1[var4_4++] = (char)(55296 + ((var8_9 -= 65536) >> 10));
                        var8_9 = 56320 | var8_9 & 1023;
                        if (var4_4 >= var3_3) {
                            this._surrogate = var8_9;
                            break block0;
                        }
                    }
                }
                var1_1[var4_4++] = (char)var8_9;
                if (var6_7 < var7_8) continue block0;
                break block0;
            }
            break block0;
        }
        this._inputPtr = var6_7;
        var8_9 = var4_4 - var2_2;
        this._charCount += var8_9;
        return var8_9;
    }

    protected final InputStream getStream() {
        return this._inputSource;
    }

    protected final int readBytes() throws IOException {
        this._inputPtr = 0;
        this._inputEnd = 0;
        if (this._inputSource != null) {
            int n2 = this._inputSource.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n2 > 0) {
                this._inputEnd = n2;
            }
            return n2;
        }
        return -1;
    }

    protected final int readBytesAt(int n2) throws IOException {
        if (this._inputSource != null) {
            int n3 = this._inputSource.read(this._inputBuffer, n2, this._inputBuffer.length - n2);
            if (n3 > 0) {
                this._inputEnd += n3;
            }
            return n3;
        }
        return -1;
    }

    public final void freeBuffers() {
        byte[] byArray;
        if (this._bufferHolder != null && (byArray = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._bufferHolder[0] = byArray;
        }
    }

    private void reportInvalidInitial(int n2, int n3) throws IOException {
        int n4 = this._byteCount + this._inputPtr - 1;
        int n5 = this._charCount + n3 + 1;
        throw new CharConversionException("Invalid UTF-8 start byte 0x" + Integer.toHexString(n2) + " (at char #" + n5 + ", byte #" + n4 + ")");
    }

    private void reportInvalidOther(int n2, int n3) throws IOException {
        int n4 = this._byteCount + this._inputPtr - 1;
        int n5 = this._charCount + n3;
        throw new CharConversionException("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n2) + " (at char #" + n5 + ", byte #" + n4 + ")");
    }

    private void reportUnexpectedEOF(int n2, int n3) throws IOException {
        int n4 = this._byteCount + n2;
        int n5 = this._charCount;
        throw new CharConversionException("Unexpected EOF in the middle of a multi-byte char: got " + n2 + ", needed " + n3 + ", at char #" + n5 + ", byte #" + n4 + ")");
    }

    private boolean loadMore(int n2) throws IOException {
        int n3;
        int n4;
        this._byteCount += this._inputEnd - n2;
        if (n2 > 0) {
            if (this._inputPtr > 0) {
                if (!this.canModifyBuffer() && this._inputSource == null) {
                    throw new IOException(String.format("End-of-input after first %d byte(s) of a UTF-8 character: needed at least one more", n2));
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    this._inputBuffer[n4] = this._inputBuffer[this._inputPtr + n4];
                }
                this._inputPtr = 0;
                this._inputEnd = n2;
            }
        } else {
            n4 = this.readBytes();
            if (n4 < 1) {
                this.freeBuffers();
                if (n4 < 0) {
                    return false;
                }
                this.reportStrangeStream();
            }
        }
        if ((n4 = this._inputBuffer[this._inputPtr]) >= 0) {
            return true;
        }
        if ((n4 & 0xE0) == 192) {
            n3 = 2;
        } else if ((n4 & 0xF0) == 224) {
            n3 = 3;
        } else if ((n4 & 0xF8) == 240) {
            n3 = 4;
        } else {
            return true;
        }
        while (this._inputPtr + n3 > this._inputEnd) {
            int n5 = this.readBytesAt(this._inputEnd);
            if (n5 >= 1) continue;
            if (n5 < 0) {
                this.freeBuffers();
                this.reportUnexpectedEOF(this._inputEnd, n3);
            }
            this.reportStrangeStream();
        }
        return true;
    }

    protected void reportBounds(char[] cArray, int n2, int n3) throws IOException {
        throw new ArrayIndexOutOfBoundsException("read(buf," + n2 + "," + n3 + "), cbuf[" + cArray.length + "]");
    }

    protected void reportStrangeStream() throws IOException {
        throw new IOException("Strange I/O stream, returned 0 bytes on read");
    }
}

