/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.CollectorBase;
import com.fasterxml.jackson.databind.introspect.MemberKey;
import com.fasterxml.jackson.databind.introspect.MethodGenericTypeResolver;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class AnnotatedCreatorCollector
extends CollectorBase {
    private final TypeResolutionContext _typeContext;
    private final boolean _collectAnnotations;
    private AnnotatedConstructor _defaultConstructor;

    AnnotatedCreatorCollector(AnnotationIntrospector annotationIntrospector, TypeResolutionContext typeResolutionContext, boolean bl2) {
        super(annotationIntrospector);
        this._typeContext = typeResolutionContext;
        this._collectAnnotations = bl2;
    }

    public static AnnotatedClass.Creators collectCreators(AnnotationIntrospector annotationIntrospector, TypeFactory typeFactory, TypeResolutionContext typeResolutionContext, JavaType javaType, Class<?> clazz, boolean bl2) {
        return new AnnotatedCreatorCollector(annotationIntrospector, typeResolutionContext, bl2 |= clazz != null).collect(typeFactory, javaType, clazz);
    }

    AnnotatedClass.Creators collect(TypeFactory typeFactory, JavaType javaType, Class<?> clazz) {
        List<AnnotatedConstructor> list = this._findPotentialConstructors(javaType, clazz);
        List<AnnotatedMethod> list2 = this._findPotentialFactories(typeFactory, javaType, clazz);
        if (this._collectAnnotations) {
            if (this._defaultConstructor != null && this._intr.hasIgnoreMarker(this._defaultConstructor)) {
                this._defaultConstructor = null;
            }
            int n2 = list.size();
            while (--n2 >= 0) {
                if (!this._intr.hasIgnoreMarker(list.get(n2))) continue;
                list.remove(n2);
            }
            n2 = list2.size();
            while (--n2 >= 0) {
                if (!this._intr.hasIgnoreMarker(list2.get(n2))) continue;
                list2.remove(n2);
            }
        }
        return new AnnotatedClass.Creators(this._defaultConstructor, list, list2);
    }

    private List<AnnotatedConstructor> _findPotentialConstructors(JavaType javaType, Class<?> clazz) {
        int n2;
        int n3;
        Object object;
        ClassUtil.Ctor ctor = null;
        ArrayList<ClassUtil.Ctor> arrayList = null;
        if (!javaType.isEnumType()) {
            object = ClassUtil.getConstructors(javaType.getRawClass());
            Object object2 = object;
            n3 = ((ClassUtil.Ctor[])object2).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                ClassUtil.Ctor ctor2 = object2[i2];
                if (!AnnotatedCreatorCollector.isIncludableConstructor(ctor2.getConstructor())) continue;
                if (ctor2.getParamCount() == 0) {
                    ctor = ctor2;
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<ClassUtil.Ctor>();
                }
                arrayList.add(ctor2);
            }
        }
        if (arrayList == null) {
            object = Collections.emptyList();
            if (ctor == null) {
                return object;
            }
            n2 = 0;
        } else {
            n2 = arrayList.size();
            object = new ArrayList(n2);
            for (n3 = 0; n3 < n2; ++n3) {
                object.add(null);
            }
        }
        if (clazz != null) {
            MemberKey[] memberKeyArray = null;
            block2: for (ClassUtil.Ctor ctor3 : ClassUtil.getConstructors(clazz)) {
                if (ctor3.getParamCount() == 0) {
                    if (ctor == null) continue;
                    this._defaultConstructor = this.constructDefaultConstructor(ctor, ctor3);
                    ctor = null;
                    continue;
                }
                if (arrayList == null) continue;
                if (memberKeyArray == null) {
                    memberKeyArray = new MemberKey[n2];
                    for (int i3 = 0; i3 < n2; ++i3) {
                        memberKeyArray[i3] = new MemberKey(((ClassUtil.Ctor)arrayList.get(i3)).getConstructor());
                    }
                }
                MemberKey memberKey = new MemberKey(ctor3.getConstructor());
                for (int i4 = 0; i4 < n2; ++i4) {
                    if (!memberKey.equals(memberKeyArray[i4])) continue;
                    object.set(i4, this.constructNonDefaultConstructor((ClassUtil.Ctor)arrayList.get(i4), ctor3));
                    continue block2;
                }
            }
        }
        if (ctor != null) {
            this._defaultConstructor = this.constructDefaultConstructor(ctor, null);
        }
        for (int i5 = 0; i5 < n2; ++i5) {
            AnnotatedConstructor annotatedConstructor = (AnnotatedConstructor)object.get(i5);
            if (annotatedConstructor != null) continue;
            object.set(i5, this.constructNonDefaultConstructor((ClassUtil.Ctor)arrayList.get(i5), null));
        }
        return object;
    }

    private List<AnnotatedMethod> _findPotentialFactories(TypeFactory typeFactory, JavaType javaType, Class<?> clazz) {
        ArrayList<Method> arrayList = null;
        for (Method i2 : ClassUtil.getClassMethods(javaType.getRawClass())) {
            if (!AnnotatedCreatorCollector._isIncludableFactoryMethod(i2)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Method>();
            }
            arrayList.add(i2);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        TypeResolutionContext typeResolutionContext = this._typeContext;
        int n2 = arrayList.size();
        ArrayList<AnnotatedMethod> arrayList2 = new ArrayList<AnnotatedMethod>(n2);
        for (int memberKeyArray = 0; memberKeyArray < n2; ++memberKeyArray) {
            arrayList2.add(null);
        }
        if (clazz != null) {
            MemberKey[] i5 = null;
            block2: for (Method method : clazz.getDeclaredMethods()) {
                if (!AnnotatedCreatorCollector._isIncludableFactoryMethod(method)) continue;
                if (i5 == null) {
                    i5 = new MemberKey[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        i5[i2] = new MemberKey((Method)arrayList.get(i2));
                    }
                }
                MemberKey memberKey = new MemberKey(method);
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (!memberKey.equals(i5[i3])) continue;
                    arrayList2.set(i3, this.constructFactoryCreator((Method)arrayList.get(i3), typeResolutionContext, method));
                    continue block2;
                }
            }
        }
        for (int i4 = 0; i4 < n2; ++i4) {
            AnnotatedMethod annotatedMethod = (AnnotatedMethod)arrayList2.get(i4);
            if (annotatedMethod != null) continue;
            Method method = (Method)arrayList.get(i4);
            TypeResolutionContext typeResolutionContext2 = MethodGenericTypeResolver.narrowMethodTypeParameters(method, javaType, typeFactory, typeResolutionContext);
            arrayList2.set(i4, this.constructFactoryCreator(method, typeResolutionContext2, null));
        }
        return arrayList2;
    }

    private static boolean _isIncludableFactoryMethod(Method method) {
        if (!Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        return !method.isSynthetic();
    }

    protected AnnotatedConstructor constructDefaultConstructor(ClassUtil.Ctor ctor, ClassUtil.Ctor ctor2) {
        return new AnnotatedConstructor(this._typeContext, ctor.getConstructor(), this.collectAnnotations(ctor, ctor2), NO_ANNOTATION_MAPS);
    }

    protected AnnotatedConstructor constructNonDefaultConstructor(ClassUtil.Ctor ctor, ClassUtil.Ctor ctor2) {
        AnnotationMap[] annotationMapArray;
        int n2 = ctor.getParamCount();
        if (this._intr == null) {
            return new AnnotatedConstructor(this._typeContext, ctor.getConstructor(), AnnotatedCreatorCollector._emptyAnnotationMap(), AnnotatedCreatorCollector._emptyAnnotationMaps(n2));
        }
        if (n2 == 0) {
            return new AnnotatedConstructor(this._typeContext, ctor.getConstructor(), this.collectAnnotations(ctor, ctor2), NO_ANNOTATION_MAPS);
        }
        Annotation[][] annotationArray = ctor.getParameterAnnotations();
        if (n2 != annotationArray.length) {
            annotationMapArray = null;
            Class<?> clazz = ctor.getDeclaringClass();
            if (ClassUtil.isEnumType(clazz) && n2 == annotationArray.length + 2) {
                Annotation[][] annotationArray2 = annotationArray;
                annotationArray = new Annotation[annotationArray2.length + 2][];
                System.arraycopy(annotationArray2, 0, annotationArray, 2, annotationArray2.length);
                annotationMapArray = this.collectAnnotations(annotationArray, (Annotation[][])null);
            } else if (clazz.isMemberClass() && n2 == annotationArray.length + 1) {
                Annotation[][] annotationArray3 = annotationArray;
                annotationArray = new Annotation[annotationArray3.length + 1][];
                System.arraycopy(annotationArray3, 0, annotationArray, 1, annotationArray3.length);
                annotationArray[0] = NO_ANNOTATIONS;
                annotationMapArray = this.collectAnnotations(annotationArray, (Annotation[][])null);
            }
            if (annotationMapArray == null) {
                throw new IllegalStateException(String.format("Internal error: constructor for %s has mismatch: %d parameters; %d sets of annotations", ctor.getDeclaringClass().getName(), n2, annotationArray.length));
            }
        } else {
            annotationMapArray = this.collectAnnotations(annotationArray, ctor2 == null ? (Annotation[][])null : ctor2.getParameterAnnotations());
        }
        return new AnnotatedConstructor(this._typeContext, ctor.getConstructor(), this.collectAnnotations(ctor, ctor2), annotationMapArray);
    }

    protected AnnotatedMethod constructFactoryCreator(Method method, TypeResolutionContext typeResolutionContext, Method method2) {
        int n2 = method.getParameterCount();
        if (this._intr == null) {
            return new AnnotatedMethod(typeResolutionContext, method, AnnotatedCreatorCollector._emptyAnnotationMap(), AnnotatedCreatorCollector._emptyAnnotationMaps(n2));
        }
        if (n2 == 0) {
            return new AnnotatedMethod(typeResolutionContext, method, this.collectAnnotations(method, method2), NO_ANNOTATION_MAPS);
        }
        return new AnnotatedMethod(typeResolutionContext, method, this.collectAnnotations(method, method2), this.collectAnnotations(method.getParameterAnnotations(), method2 == null ? (Annotation[][])null : method2.getParameterAnnotations()));
    }

    private AnnotationMap[] collectAnnotations(Annotation[][] annotationArray, Annotation[][] annotationArray2) {
        if (this._collectAnnotations) {
            int n2 = annotationArray.length;
            AnnotationMap[] annotationMapArray = new AnnotationMap[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                AnnotationCollector annotationCollector = this.collectAnnotations(AnnotationCollector.emptyCollector(), annotationArray[i2]);
                if (annotationArray2 != null) {
                    annotationCollector = this.collectAnnotations(annotationCollector, annotationArray2[i2]);
                }
                annotationMapArray[i2] = annotationCollector.asAnnotationMap();
            }
            return annotationMapArray;
        }
        return NO_ANNOTATION_MAPS;
    }

    private AnnotationMap collectAnnotations(ClassUtil.Ctor ctor, ClassUtil.Ctor ctor2) {
        if (this._collectAnnotations) {
            AnnotationCollector annotationCollector = this.collectAnnotations(ctor.getDeclaredAnnotations());
            if (ctor2 != null) {
                annotationCollector = this.collectAnnotations(annotationCollector, ctor2.getDeclaredAnnotations());
            }
            return annotationCollector.asAnnotationMap();
        }
        return AnnotatedCreatorCollector._emptyAnnotationMap();
    }

    private final AnnotationMap collectAnnotations(AnnotatedElement annotatedElement, AnnotatedElement annotatedElement2) {
        AnnotationCollector annotationCollector = this.collectAnnotations(annotatedElement.getDeclaredAnnotations());
        if (annotatedElement2 != null) {
            annotationCollector = this.collectAnnotations(annotationCollector, annotatedElement2.getDeclaredAnnotations());
        }
        return annotationCollector.asAnnotationMap();
    }

    private static boolean isIncludableConstructor(Constructor<?> constructor) {
        return !constructor.isSynthetic();
    }
}

