/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Objects;

public final class AnnotatedConstructor
extends AnnotatedWithParams {
    private static final long serialVersionUID = 1L;
    protected final Constructor<?> _constructor;
    protected Serialization _serialization;

    public AnnotatedConstructor(TypeResolutionContext typeResolutionContext, Constructor<?> constructor, AnnotationMap annotationMap, AnnotationMap[] annotationMapArray) {
        super(typeResolutionContext, annotationMap, annotationMapArray);
        this._constructor = Objects.requireNonNull(constructor);
    }

    protected AnnotatedConstructor(Serialization serialization) {
        super(null, null, null);
        this._constructor = null;
        this._serialization = serialization;
    }

    @Override
    public AnnotatedConstructor withAnnotations(AnnotationMap annotationMap) {
        return new AnnotatedConstructor(this._typeContext, this._constructor, annotationMap, this._paramAnnotations);
    }

    @Override
    public Constructor<?> getAnnotated() {
        return this._constructor;
    }

    @Override
    public int getModifiers() {
        return this._constructor.getModifiers();
    }

    @Override
    public String getName() {
        return this._constructor.getName();
    }

    @Override
    public JavaType getType() {
        return this._typeContext.resolveType(this.getRawType());
    }

    @Override
    public Class<?> getRawType() {
        return this._constructor.getDeclaringClass();
    }

    @Override
    public int getParameterCount() {
        return this._constructor.getParameterCount();
    }

    @Override
    public Class<?> getRawParameterType(int n2) {
        Class<?>[] classArray = this._constructor.getParameterTypes();
        return n2 >= classArray.length ? null : classArray[n2];
    }

    @Override
    public JavaType getParameterType(int n2) {
        Type[] typeArray = this._constructor.getGenericParameterTypes();
        if (n2 >= typeArray.length) {
            return null;
        }
        return this._typeContext.resolveType(typeArray[n2]);
    }

    @Override
    @Deprecated
    public Type getGenericParameterType(int n2) {
        Type[] typeArray = this._constructor.getGenericParameterTypes();
        if (n2 >= typeArray.length) {
            return null;
        }
        return typeArray[n2];
    }

    @Override
    public final Object call() throws Exception {
        return this._constructor.newInstance(null);
    }

    @Override
    public final Object call(Object[] objectArray) throws Exception {
        return this._constructor.newInstance(objectArray);
    }

    @Override
    public final Object call1(Object object) throws Exception {
        return this._constructor.newInstance(object);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this._constructor.getDeclaringClass();
    }

    @Override
    public Member getMember() {
        return this._constructor;
    }

    @Override
    public void setValue(Object object, Object object2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot call setValue() on constructor of " + this.getDeclaringClass().getName());
    }

    @Override
    public Object getValue(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot call getValue() on constructor of " + this.getDeclaringClass().getName());
    }

    @Override
    public String toString() {
        int n2 = this._constructor.getParameterCount();
        return String.format("[constructor for %s (%d arg%s), annotations: %s", ClassUtil.nameOf(this._constructor.getDeclaringClass()), n2, n2 == 1 ? "" : "s", this._annotations);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this._constructor);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!ClassUtil.hasClass(object, this.getClass())) {
            return false;
        }
        AnnotatedConstructor annotatedConstructor = (AnnotatedConstructor)object;
        return Objects.equals(this._constructor, annotatedConstructor._constructor);
    }

    Object writeReplace() {
        return new AnnotatedConstructor(new Serialization(this._constructor));
    }

    Object readResolve() {
        Class<?> clazz = this._serialization.clazz;
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(this._serialization.args);
            if (!constructor.isAccessible()) {
                ClassUtil.checkAndFixAccess(constructor, false);
            }
            return new AnnotatedConstructor(null, constructor, null, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not find constructor with " + this._serialization.args.length + " args from Class '" + clazz.getName());
        }
    }

    private static final class Serialization
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Class<?> clazz;
        protected Class<?>[] args;

        public Serialization(Constructor<?> constructor) {
            this.clazz = constructor.getDeclaringClass();
            this.args = constructor.getParameterTypes();
        }
    }
}

