/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.SlotListener;
import atlantafx.base.controls.TileBase;
import atlantafx.base.util.BBCodeParser;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;

public abstract class TileSkinBase<T extends TileBase>
extends SkinBase<T> {
    protected static final PseudoClass HAS_GRAPHIC = PseudoClass.getPseudoClass((String)"has-graphic");
    protected static final PseudoClass HAS_TITLE = PseudoClass.getPseudoClass((String)"has-title");
    protected static final PseudoClass HAS_DESCRIPTION = PseudoClass.getPseudoClass((String)"has-description");
    protected static final PseudoClass HAS_ACTION = PseudoClass.getPseudoClass((String)"has-action");
    protected final HBox container = new HBox();
    protected final StackPane graphicSlot = new StackPane();
    protected final ChangeListener<Node> graphicSlotListener;
    protected final VBox headerBox;
    protected final Label titleLbl;
    protected final TextFlow descriptionText;
    protected final StackPane actionSlot;
    protected final ChangeListener<Node> actionSlotListener;

    public TileSkinBase(T t2) {
        super(t2);
        this.graphicSlot.getStyleClass().add((Object)"graphic");
        this.graphicSlotListener = new SlotListener((Node)this.graphicSlot, (node, bl2) -> ((TileBase)this.getSkinnable()).pseudoClassStateChanged(HAS_GRAPHIC, (boolean)bl2));
        ((TileBase)((Object)t2)).graphicProperty().addListener(this.graphicSlotListener);
        this.graphicSlotListener.changed(((TileBase)((Object)t2)).graphicProperty(), null, (Object)((TileBase)((Object)t2)).getGraphic());
        this.titleLbl = new Label(((TileBase)((Object)t2)).getTitle());
        this.titleLbl.getStyleClass().add((Object)"title");
        this.titleLbl.setVisible(((TileBase)((Object)t2)).getTitle() != null);
        this.titleLbl.setManaged(((TileBase)((Object)t2)).getTitle() != null);
        this.descriptionText = new TextFlow();
        this.descriptionText.getStyleClass().add((Object)"description");
        this.descriptionText.setVisible(((TileBase)((Object)t2)).getDescription() != null);
        this.descriptionText.setManaged(((TileBase)((Object)t2)).getDescription() != null);
        this.setDescriptionText();
        this.headerBox = new VBox(new Node[]{this.titleLbl, this.descriptionText});
        this.headerBox.setFillWidth(true);
        this.headerBox.getStyleClass().add((Object)"header");
        HBox.setHgrow((Node)this.headerBox, (Priority)Priority.ALWAYS);
        this.headerBox.setMinHeight(-1.0);
        this.headerBox.setPrefHeight(-1.0);
        this.headerBox.setMaxHeight(-1.0);
        t2.pseudoClassStateChanged(HAS_TITLE, ((TileBase)((Object)t2)).getTitle() != null);
        this.registerChangeListener((ObservableValue)((TileBase)((Object)t2)).titleProperty(), observableValue -> {
            String string = ((TileBase)this.getSkinnable()).getDescription();
            this.titleLbl.setText(string);
            this.titleLbl.setVisible(string != null);
            this.titleLbl.setManaged(string != null);
            ((TileBase)this.getSkinnable()).pseudoClassStateChanged(HAS_TITLE, string != null);
        });
        t2.pseudoClassStateChanged(HAS_DESCRIPTION, ((TileBase)((Object)t2)).getDescription() != null);
        this.registerChangeListener((ObservableValue)((TileBase)((Object)t2)).descriptionProperty(), observableValue -> {
            String string = ((TileBase)this.getSkinnable()).getDescription();
            this.setDescriptionText();
            this.descriptionText.setVisible(string != null);
            this.descriptionText.setManaged(string != null);
            ((TileBase)this.getSkinnable()).pseudoClassStateChanged(HAS_DESCRIPTION, string != null);
        });
        this.actionSlot = new StackPane();
        this.actionSlot.getStyleClass().add((Object)"action");
        this.actionSlotListener = new SlotListener((Node)this.actionSlot, (node, bl2) -> ((TileBase)this.getSkinnable()).pseudoClassStateChanged(HAS_ACTION, (boolean)bl2));
        this.graphicSlot.setMinWidth(Double.NEGATIVE_INFINITY);
        this.actionSlot.setMinWidth(Double.NEGATIVE_INFINITY);
        this.descriptionText.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.descriptionText.setMinHeight(Double.NEGATIVE_INFINITY);
        this.container.setFillHeight(false);
        this.container.getChildren().setAll((Object[])new Node[]{this.graphicSlot, this.headerBox, this.actionSlot});
        this.container.getStyleClass().add((Object)"container");
        this.getChildren().setAll((Object[])new Node[]{this.container});
    }

    protected void setDescriptionText() {
        if (!this.descriptionText.getChildren().isEmpty()) {
            this.descriptionText.getChildren().clear();
        }
        if (((TileBase)this.getSkinnable()).getDescription() != null && !((TileBase)this.getSkinnable()).getDescription().isBlank()) {
            BBCodeParser.createLayout(((TileBase)this.getSkinnable()).getDescription(), this.descriptionText);
        }
    }

    protected double calcHeight() {
        double d2 = this.headerBox.getSpacing() + this.headerBox.getInsets().getTop() + this.headerBox.getInsets().getBottom() + this.titleLbl.getBoundsInLocal().getHeight() + (this.descriptionText.isManaged() ? this.descriptionText.getBoundsInLocal().getHeight() : 0.0);
        return Math.max(Math.max(this.graphicSlot.getHeight(), this.actionSlot.getHeight()), d2) + this.container.getPadding().getTop() + this.container.getPadding().getBottom();
    }

    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return this.calcHeight();
    }

    public void dispose() {
        this.unregisterChangeListeners((ObservableValue)((TileBase)this.getSkinnable()).titleProperty());
        this.unregisterChangeListeners((ObservableValue)((TileBase)this.getSkinnable()).descriptionProperty());
        ((TileBase)this.getSkinnable()).graphicProperty().removeListener(this.graphicSlotListener);
        super.dispose();
    }
}

