/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.CalendarSkin;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.DateCell;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import org.jetbrains.annotations.Nullable;

public class Calendar
extends Control {
    protected LocalDate lastValidDate = null;
    protected Chronology lastValidChronology = IsoChronology.INSTANCE;
    private final ObjectProperty<LocalDate> value = new SimpleObjectProperty((Object)this, "value");
    private ObjectProperty<Callback<Calendar, DateCell>> dayCellFactory;
    private final ObjectProperty<Chronology> chronology = new SimpleObjectProperty((Object)this, "chronology", null);
    private BooleanProperty showWeekNumbers;
    private final ObjectProperty<Node> topNode = new SimpleObjectProperty((Object)this, "topNode", null);
    private final ObjectProperty<Node> bottomNode = new SimpleObjectProperty((Object)this, "bottomNode", null);
    private static final String DEFAULT_STYLE_CLASS = "calendar";

    public Calendar() {
        this(null);
        this.valueProperty().addListener(observable -> {
            LocalDate localDate = this.getValue();
            Chronology chronology = this.getChronology();
            if (Calendar.isValidDate(chronology, localDate)) {
                this.lastValidDate = localDate;
            } else {
                System.err.println("[ERROR] Restoring value to " + (Serializable)(this.lastValidDate == null ? "null" : this.lastValidDate));
                this.setValue(this.lastValidDate);
            }
        });
        this.chronologyProperty().addListener(observable -> {
            LocalDate localDate = this.getValue();
            Chronology chronology = this.getChronology();
            if (Calendar.isValidDate(chronology, localDate)) {
                this.lastValidChronology = chronology;
            } else {
                System.err.println("[ERROR] Restoring value to " + this.lastValidChronology);
                this.setChronology(this.lastValidChronology);
            }
        });
    }

    public Calendar(@Nullable LocalDate localDate) {
        this.setValue(localDate);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    protected Skin<?> createDefaultSkin() {
        return new CalendarSkin(this);
    }

    public ObjectProperty<LocalDate> valueProperty() {
        return this.value;
    }

    public final LocalDate getValue() {
        return (LocalDate)this.valueProperty().get();
    }

    public final void setValue(LocalDate localDate) {
        this.valueProperty().set((Object)localDate);
    }

    public final void setDayCellFactory(Callback<Calendar, DateCell> callback) {
        this.dayCellFactoryProperty().set(callback);
    }

    public final Callback<Calendar, DateCell> getDayCellFactory() {
        return this.dayCellFactory != null ? (Callback)this.dayCellFactory.get() : null;
    }

    public final ObjectProperty<Callback<Calendar, DateCell>> dayCellFactoryProperty() {
        if (this.dayCellFactory == null) {
            this.dayCellFactory = new SimpleObjectProperty((Object)this, "dayCellFactory");
        }
        return this.dayCellFactory;
    }

    public ObjectProperty<Chronology> chronologyProperty() {
        return this.chronology;
    }

    public final Chronology getChronology() {
        Chronology chronology = (Chronology)this.chronology.get();
        if (chronology == null) {
            try {
                chronology = Chronology.ofLocale(Locale.getDefault(Locale.Category.FORMAT));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (chronology == null) {
                chronology = IsoChronology.INSTANCE;
            }
        }
        return chronology;
    }

    public final void setChronology(Chronology chronology) {
        this.chronology.setValue((Object)chronology);
    }

    public final BooleanProperty showWeekNumbersProperty() {
        if (this.showWeekNumbers == null) {
            this.showWeekNumbers = new StyleableBooleanProperty(false){

                public CssMetaData<Calendar, Boolean> getCssMetaData() {
                    return StyleableProperties.SHOW_WEEK_NUMBERS;
                }

                public Object getBean() {
                    return Calendar.this;
                }

                public String getName() {
                    return "showWeekNumbers";
                }
            };
        }
        return this.showWeekNumbers;
    }

    public final void setShowWeekNumbers(boolean bl2) {
        this.showWeekNumbersProperty().setValue(Boolean.valueOf(bl2));
    }

    public final boolean isShowWeekNumbers() {
        return this.showWeekNumbersProperty().getValue();
    }

    public ObjectProperty<Node> topNodeProperty() {
        return this.topNode;
    }

    public final void setTopNode(Node node) {
        this.topNode.setValue((Object)node);
    }

    public final Node getTopNode() {
        return (Node)this.topNode.getValue();
    }

    public ObjectProperty<Node> bottomNodeProperty() {
        return this.bottomNode;
    }

    public final void setBottomNode(Node node) {
        this.bottomNode.setValue((Object)node);
    }

    public final Node getBottomNode() {
        return (Node)this.bottomNode.getValue();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Calendar.getClassCssMetaData();
    }

    static boolean isValidDate(Chronology chronology, LocalDate localDate, int n2, ChronoUnit chronoUnit) {
        if (localDate != null) {
            try {
                return Calendar.isValidDate(chronology, localDate.plus(n2, chronoUnit));
            }
            catch (DateTimeException dateTimeException) {
                dateTimeException.printStackTrace();
            }
        }
        return false;
    }

    static boolean isValidDate(Chronology chronology, LocalDate localDate) {
        try {
            if (localDate != null) {
                chronology.date(localDate);
            }
            return true;
        }
        catch (DateTimeException dateTimeException) {
            dateTimeException.printStackTrace();
            return false;
        }
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
        private static final CssMetaData<Calendar, Boolean> SHOW_WEEK_NUMBERS;

        private StyleableProperties() {
        }

        static {
            SHOW_WEEK_NUMBERS = new CssMetaData<Calendar, Boolean>("-fx-show-week-numbers", BooleanConverter.getInstance(), Boolean.valueOf(false)){

                public boolean isSettable(Calendar calendar) {
                    return calendar.showWeekNumbers == null || !calendar.showWeekNumbers.isBound();
                }

                public StyleableProperty<Boolean> getStyleableProperty(Calendar calendar) {
                    return (StyleableProperty)calendar.showWeekNumbersProperty();
                }
            };
            ArrayList arrayList = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(arrayList, SHOW_WEEK_NUMBERS);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

