/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;

public class PngChunkGAMA
extends PngChunkSingle {
    public static final String ID = "gAMA";
    private double gamma;

    public PngChunkGAMA(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_PLTE_AND_IDAT;
    }

    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(4, true);
        int n2 = (int)(this.gamma * 100000.0 + 0.5);
        PngHelperInternal.writeInt4tobytes(n2, chunkRaw.data, 0);
        return chunkRaw;
    }

    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 4) {
            throw new PngjException("bad chunk " + chunkRaw);
        }
        int n2 = PngHelperInternal.readInt4fromBytes(chunkRaw.data, 0);
        this.gamma = (double)n2 / 100000.0;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double d2) {
        this.gamma = d2;
    }
}

