/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.teachrepeat.state;

import us.hebi.gui.lib.bff;
import us.hebi.gui.lib.bfg;
import us.hebi.gui.lib.bib;
import us.hebi.gui.lib.bic;
import us.hebi.gui.lib.bie;
import us.hebi.gui.views.teachrepeat.state.TrajectorySampler$GroupSampleConsumer;
import us.hebi.gui.views.teachrepeat.state.TrajectorySampler$JointSampleConsumer;

public abstract class TrajectorySampler {
    public double[] time = new double[0];
    private double[][] position = new double[0][0];
    private double[][] velocity = new double[0][0];
    private double[][] acceleration = new double[0][0];
    private final bic state = new bic();
    private double[] p;
    private double[] v;
    private double[] a;
    public int numSamples = 0;

    public static TrajectorySampler createContinuous(int n2) {
        return new bff(n2);
    }

    public static TrajectorySampler createKeyFrame() {
        return new bfg();
    }

    public int getNumJoints() {
        return this.position.length;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public double[] getTime() {
        return this.time;
    }

    public double[] getJointPosition(int n2) {
        return this.position[n2];
    }

    public double[] getJointVelocity(int n2) {
        return this.position[n2];
    }

    public double[] getJointAcceleration(int n2) {
        return this.position[n2];
    }

    public void forEachJointSample(int n2, TrajectorySampler$JointSampleConsumer trajectorySampler$JointSampleConsumer) {
        for (int i2 = 0; i2 < this.numSamples; ++i2) {
            trajectorySampler$JointSampleConsumer.accept(i2, this.time[i2], this.position[n2][i2], this.velocity[n2][i2], this.acceleration[n2][i2]);
        }
    }

    public void forEachGroupSample(TrajectorySampler$GroupSampleConsumer trajectorySampler$GroupSampleConsumer) {
        for (int i2 = 0; i2 < this.numSamples; ++i2) {
            for (int i3 = 0; i3 < this.position.length; ++i3) {
                this.p[i3] = this.position[i3][i2];
                this.v[i3] = this.position[i3][i2];
                this.a[i3] = this.position[i3][i2];
                trajectorySampler$GroupSampleConsumer.accept(i2, this.time[i2], this.p, this.v, this.a);
            }
        }
    }

    protected abstract void extractSampleTimes(bie var1);

    public void clear() {
        this.numSamples = 0;
    }

    public void setTrajectory(bie bie2) {
        int n2 = bie2.getLength();
        this.extractSampleTimes(bie2);
        for (int i2 = 0; i2 < n2; ++i2) {
            bib bib2 = bie2.get(i2);
            for (int i3 = 0; i3 < this.numSamples; ++i3) {
                bib2.a(this.time[i3], this.state);
                this.position[i2][i3] = this.state.position;
                this.velocity[i2][i3] = this.state.velocity;
                this.acceleration[i2][i3] = this.state.et;
            }
        }
    }

    protected void ensureSpace(int n2, int n3) {
        if (this.position.length != n2 || this.time.length < n3) {
            this.time = new double[n3];
            this.position = new double[n2][n3];
            this.velocity = new double[n2][n3];
            this.acceleration = new double[n2][n3];
            this.p = new double[n2];
            this.v = new double[n2];
            this.a = new double[n2];
        }
    }
}

