/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import atlantafx.base.controls.CustomTextField;
import io.fair_acc.chartfx.utils.PropUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import javax.inject.Inject;
import javax.xml.transform.sax.SAXSource;
import lombok.Generated;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import us.hebi.gui.controls.HDoubleInputField;
import us.hebi.gui.controls.HEnumInputField;
import us.hebi.gui.controls.TextUtil;
import us.hebi.gui.lib.ade;
import us.hebi.gui.lib.adk;
import us.hebi.gui.lib.aee;
import us.hebi.gui.lib.aeg;
import us.hebi.gui.lib.aei;
import us.hebi.gui.lib.afd;
import us.hebi.gui.lib.ajo;
import us.hebi.gui.lib.ajp;
import us.hebi.gui.lib.ajq;
import us.hebi.gui.lib.ajr;
import us.hebi.gui.lib.ajs;
import us.hebi.gui.lib.ajt;
import us.hebi.gui.lib.aju;
import us.hebi.gui.lib.ajv;
import us.hebi.gui.lib.ajw;
import us.hebi.gui.lib.ajx;
import us.hebi.gui.lib.ajy;
import us.hebi.gui.lib.amw;
import us.hebi.gui.lib.apr;
import us.hebi.gui.lib.aqn;
import us.hebi.gui.lib.arz;
import us.hebi.gui.lib.atn;
import us.hebi.gui.lib.ato;
import us.hebi.gui.lib.atp;
import us.hebi.gui.lib.ats;
import us.hebi.gui.lib.atu;
import us.hebi.gui.lib.atw;
import us.hebi.gui.lib.aua;
import us.hebi.gui.lib.aug;
import us.hebi.gui.lib.auh;
import us.hebi.gui.lib.aul;
import us.hebi.gui.lib.aup;
import us.hebi.gui.lib.awb;
import us.hebi.gui.lib.awg;
import us.hebi.gui.lib.awh;
import us.hebi.gui.lib.axb;
import us.hebi.gui.lib.axk;
import us.hebi.gui.lib.axp;
import us.hebi.gui.lib.ayd;
import us.hebi.gui.lib.ayn;
import us.hebi.gui.lib.bcn;
import us.hebi.gui.lib.bcq;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.views.scope.components.EncoderConfigController;
import us.hebi.gui.views.scope.components.MotorDriverCommand;
import us.hebi.gui.views.scope.components.ParseUtils;
import us.hebi.gui.views.scope.dialogs.calibrate.AdcCalibrationDialog;
import us.hebi.gui.views.scope.dialogs.calibrate.MotorEncoderCalibrationDialog;
import us.hebi.gui.views.scope.dialogs.motordriver.SaveMotorDriverXmlDialog;

public class MotorDriverController
extends bcn {
    @FXML
    private Button calibrateAdcBtn;
    @FXML
    private Button clearBtn;
    @FXML
    private ToggleButton persistToggle;
    @FXML
    private ToggleButton showAdvancedToggle;
    @FXML
    private ToggleButton showEncoderToggle;
    @FXML
    private HEnumInputField<ajv> controlMode;
    @FXML
    private HEnumInputField<ajr> outputEncoder;
    @FXML
    private HEnumInputField<ajr> deflectionEncoder;
    @FXML
    private HEnumInputField<ajr> motorEncoder;
    @FXML
    private Pane encoderA1;
    @FXML
    private EncoderConfigController encoderA1Controller;
    @FXML
    private Pane encoderA2;
    @FXML
    private EncoderConfigController encoderA2Controller;
    @FXML
    private Pane encoderB1;
    @FXML
    private EncoderConfigController encoderB1Controller;
    @FXML
    private Pane encoderB2;
    @FXML
    private EncoderConfigController encoderB2Controller;
    @FXML
    private Pane encoderHalls;
    @FXML
    private EncoderConfigController encoderHallsController;
    @FXML
    private HEnumInputField<ajy> windingOrder;
    @FXML
    private HEnumInputField<aju> hallOrder;
    @FXML
    private HEnumInputField<ajt> hallOffset;
    @FXML
    private VBox focContainer;
    @FXML
    private HDoubleInputField focIdIClamp;
    @FXML
    private HDoubleInputField focIdKi;
    @FXML
    private HDoubleInputField focIdKp;
    @FXML
    private HDoubleInputField focIqIClamp;
    @FXML
    private HDoubleInputField focIqKi;
    @FXML
    private HDoubleInputField focIqKp;
    @FXML
    private HDoubleInputField gearEfficiency;
    @FXML
    private HDoubleInputField maxOutputTorque;
    @FXML
    private HDoubleInputField gearRatioNumerator;
    @FXML
    private HDoubleInputField gearRatioDenominator;
    @FXML
    private HDoubleInputField calibOffsetIa;
    @FXML
    private HDoubleInputField calibOffsetIb;
    @FXML
    private HDoubleInputField calibOffsetIc;
    @FXML
    private HDoubleInputField calibOffsetIBus;
    @FXML
    private HDoubleInputField calibOffsetVa;
    @FXML
    private HDoubleInputField calibOffsetVb;
    @FXML
    private HDoubleInputField calibOffsetVc;
    @FXML
    private HDoubleInputField housingThermalResistance;
    @FXML
    private HDoubleInputField housingThermalTimeConstant;
    @FXML
    private HDoubleInputField thermalModelStartPercentage;
    @FXML
    private HDoubleInputField slewRateVoltage;
    @FXML
    private HDoubleInputField slewRateCurrent;
    @FXML
    private HDoubleInputField motorElectricalPowerLimit;
    @FXML
    private HDoubleInputField motorMechanicalPowerLimit;
    @FXML
    private Button loadFileBtn;
    @FXML
    private HDoubleInputField maxBoardCurrent;
    @FXML
    private HDoubleInputField maxDutyCycle;
    @FXML
    private HDoubleInputField maxMotorSpeed;
    @FXML
    private HDoubleInputField minDutyCycle;
    @FXML
    private HDoubleInputField switchingFreq;
    @FXML
    private HDoubleInputField controlDivider;
    @FXML
    private HDoubleInputField currentSenseThresholdVds;
    @FXML
    private HDoubleInputField currentSenseThresholdWinding;
    @FXML
    private HDoubleInputField currentFilterSize;
    @FXML
    private HDoubleInputField currentSenseGain;
    @FXML
    private HEnumInputField<ajx> torqueSource;
    @FXML
    private HEnumInputField<ajw> temperatureSource;
    @FXML
    private HDoubleInputField temperatureSourceUserValue;
    @FXML
    private HDoubleInputField polePairs;
    @FXML
    private Button resetBtn;
    @FXML
    private Button saveFileBtn;
    @FXML
    private Button sendBtn;
    @FXML
    private HDoubleInputField speedConstant;
    @FXML
    private HDoubleInputField torqueConstant;
    @FXML
    private HDoubleInputField windingInductance;
    @FXML
    private HDoubleInputField windingMaxCurrent;
    @FXML
    private HDoubleInputField windingMaxTemp;
    @FXML
    private HDoubleInputField motorTorqueTempConstant;
    @FXML
    private HDoubleInputField motorVelocityTempConstant;
    @FXML
    private HDoubleInputField motorRotorInertia;
    @FXML
    private HDoubleInputField windingResistance;
    @FXML
    private HDoubleInputField windingThermalResistance;
    @FXML
    private HDoubleInputField windingThermalTimeConstant;
    @FXML
    private Button suggestFocGainsButton;
    @FXML
    private Button calibrateMotorEncoderBtn;
    List<Runnable> addInputList = new ArrayList<Runnable>();
    List<Runnable> onClear = new ArrayList<Runnable>();
    ValidationSupport validation;
    @Inject
    aup properties;
    @Inject
    axb commandService;
    @Inject
    axp device;
    @Inject
    axk selector;
    @Inject
    ayn fileChooser;
    @Inject
    awh notificationService;
    @Inject
    SaveMotorDriverXmlDialog saveMotorDriverXmlDialog;
    @Inject
    MotorEncoderCalibrationDialog motorEncoderCalibrationDialog;
    @Inject
    AdcCalibrationDialog adcCalibrationDialog;
    @Inject
    awb dialogService;

    @Override
    public void initializeFx() {
        this.validation = bcq.a();
        MotorDriverCommand motorDriverCommand = new MotorDriverCommand();
        this.setupInputFields(motorDriverCommand);
        BooleanBinding booleanBinding = this.selector.selectionSingle().not();
        this.clearBtn.setOnAction(actionEvent -> this.onClear.forEach(Runnable::run));
        arz.a((Node)this.sendBtn, bcq.b(this.validation));
        this.sendBtn.disableProperty().bind((ObservableValue)booleanBinding.or((ObservableBooleanValue)this.validation.invalidProperty()));
        this.sendBtn.setOnAction(actionEvent -> {
            ((amw)motorDriverCommand).clear();
            this.addInputList.forEach(Runnable::run);
            if (this.persistToggle.isSelected()) {
                motorDriverCommand.setPersistAllFlag();
            }
            this.commandService.a(this.selector.getSelectedAddresses(), motorDriverCommand);
        });
        this.resetBtn.disableProperty().bind((ObservableValue)this.selector.selectionEmpty());
        this.resetBtn.setOnAction(actionEvent -> {
            ((amw)motorDriverCommand).clear();
            this.commandService.a(this.selector.getSelectedAddresses(), motorDriverCommand.setResetFlag());
        });
        arz.a((Node)this.resetBtn, new ObservableBooleanValue[]{this.device.needsResetProperty()});
        this.persistToggle.selectedProperty().bindBidirectional((Property)this.properties.g);
        this.showAdvancedToggle.selectedProperty().bindBidirectional((Property)this.properties.h);
        this.saveFileBtn.disableProperty().bind((ObservableValue)booleanBinding);
        this.loadFileBtn.disableProperty().bind((ObservableValue)booleanBinding);
        this.saveFileBtn.setOnAction(this::saveToFile);
        this.loadFileBtn.setOnAction(this::loadFromFile);
    }

    void saveToFile(ActionEvent actionEvent) {
        this.saveMotorDriverXmlDialog.setContent(aee.fromInfo(this.device.getInfo()));
        this.dialogService.a(this.saveMotorDriverXmlDialog);
    }

    void loadFromFile(ActionEvent actionEvent) {
        Window window = bdc.a(actionEvent);
        ayn ayn2 = this.fileChooser;
        ayn2.a(ayn2.c, "lastDriverConfigChoiceDirectory");
        ayn ayn3 = ayn2;
        File file = ayn3.b(ayn3.c.showOpenDialog(window), "lastDriverConfigChoiceDirectory");
        if (file == null) {
            return;
        }
        try {
            SAXSource sAXSource = afd.getSourceWithIncludes(file);
            aee aee2 = (aee)new ade().readXml(sAXSource);
            this.setFieldsFromXml(aee2);
            return;
        }
        catch (Exception exception) {
            this.notificationService.f(exception);
            return;
        }
    }

    private void setFieldsFromXml(aee aee2) {
        adk adk2;
        aei aei2;
        aeg aeg2 = aee2.getMotor();
        if (aeg2 != null) {
            this.polePairs.setTextNullable(aeg2.getPolePairs());
            this.speedConstant.setTextNullable(aeg2.getSpeedConstant());
            this.torqueConstant.setTextNullable(aeg2.getTorqueConstant());
            this.maxMotorSpeed.setTextNullable(aeg2.getMaxMotorSpeed());
            this.windingResistance.setTextNullable(aeg2.getWindingResistance());
            this.windingInductance.setTextNullable(aeg2.getWindingInductance());
            this.windingMaxCurrent.setTextNullable(aeg2.getMaxWindingCurrent());
            this.windingMaxTemp.setTextNullable(aeg2.getMaxWindingTemperature());
            this.motorTorqueTempConstant.setTextNullable(aeg2.getTorqueTempConstant());
            this.motorVelocityTempConstant.setTextNullable(aeg2.getVelocityTempConstant());
            this.motorRotorInertia.setTextNullable(aeg2.getRotorInertia());
        }
        if ((aei2 = aee2.getThermalModel()) != null) {
            this.windingThermalResistance.setTextNullable(aei2.getWindingThermalResistance());
            this.windingThermalTimeConstant.setTextNullable(aei2.getWindingThermalTimeConst());
            this.housingThermalResistance.setTextNullable(aei2.getHousingThermalResistance());
            this.housingThermalTimeConstant.setTextNullable(aei2.getHousingThermalTimeConst());
            Optional.ofNullable(aei2.getTemperatureSource()).map(ajw::a).ifPresent(this.temperatureSource::setValue);
            this.temperatureSourceUserValue.setTextNullable(aei2.getUserValue());
            this.thermalModelStartPercentage.setTextNullable(aei2.getModelStartPercentage());
        }
        if ((adk2 = aee2.getController()) != null) {
            Optional.ofNullable(adk2.getIqGains()).ifPresent(aea2 -> {
                this.focIqKp.setTextNullable(aea2.getK());
                this.focIqKi.setTextNullable(aea2.getKi());
                this.focIqIClamp.setTextNullable(aea2.getIClamp());
            });
            Optional.ofNullable(adk2.getIdGains()).ifPresent(aea2 -> {
                this.focIdKp.setTextNullable(aea2.getK());
                this.focIdKi.setTextNullable(aea2.getKi());
                this.focIdIClamp.setTextNullable(aea2.getIClamp());
            });
            this.slewRateCurrent.setTextNullable(adk2.getSlewRateCurrent());
            this.slewRateVoltage.setTextNullable(adk2.getSlewRateVoltage());
            this.motorElectricalPowerLimit.setTextNullable(adk2.getMotorElectricalPowerLimit());
            this.motorMechanicalPowerLimit.setTextNullable(adk2.getMotorMechanicalPowerLimit());
        }
        Optional.ofNullable(aee2.getEncoders()).ifPresent(ado2 -> {
            Optional.ofNullable(ado2.getMotorEncoderPort()).map(ajr::a).ifPresent(this.motorEncoder::setValue);
            Optional.ofNullable(ado2.getOutputEncoderPort()).map(ajr::a).ifPresent(this.outputEncoder::setValue);
            Optional.ofNullable(ado2.getDeflectionEncoderPort()).map(ajr::a).ifPresent(this.deflectionEncoder::setValue);
            Optional.ofNullable(ado2.getTorqueSource()).map(ajx::a).ifPresent(this.torqueSource::setValue);
            Optional.ofNullable(ado2.getHallSwitches()).ifPresent(this.encoderHallsController::setFromXml);
            Optional.ofNullable(ado2.getEncoderA1()).ifPresent(this.encoderA1Controller::setFromXml);
            Optional.ofNullable(ado2.getEncoderA2()).ifPresent(this.encoderA2Controller::setFromXml);
            Optional.ofNullable(ado2.getEncoderB1()).ifPresent(this.encoderB1Controller::setFromXml);
            Optional.ofNullable(ado2.getEncoderB2()).ifPresent(this.encoderB2Controller::setFromXml);
        });
        Optional.ofNullable(aee2.getBoard()).ifPresent(adi2 -> {
            this.minDutyCycle.setTextNullable(adi2.getMinDutyCycle());
            this.maxDutyCycle.setTextNullable(adi2.getMaxDutyCycle());
            this.maxBoardCurrent.setTextNullable(adi2.getMaxBoardCurrent());
            this.switchingFreq.setTextNullable(adi2.getSwitchingFrequency());
            this.currentSenseThresholdVds.setTextNullable(adi2.getCurrentSenseThresholdVds());
            this.currentSenseThresholdWinding.setTextNullable(adi2.getCurrentSenseThresholdWinding());
            this.currentSenseGain.setTextNullable(adi2.getCurrentSenseGain());
            this.currentFilterSize.setTextNullable(adi2.getCurrentFilterSize());
            this.controlDivider.setTextNullable(adi2.getControlDivider());
            Optional.ofNullable(adi2.getWindingOrder()).map(ajy::a).ifPresent(this.windingOrder::setValue);
            Optional.ofNullable(adi2.getHallOrder()).map(aju::a).ifPresent(this.hallOrder::setValue);
            Optional.ofNullable(adi2.getHallOffset()).map(ajt::a).ifPresent(this.hallOffset::setValue);
        });
        Optional.ofNullable(aee2.getBoardCalibration()).ifPresent(adg2 -> {
            this.calibOffsetIa.setTextNullable(adg2.getOffsetIa());
            this.calibOffsetIb.setTextNullable(adg2.getOffsetIb());
            this.calibOffsetIc.setTextNullable(adg2.getOffsetIc());
            this.calibOffsetIBus.setTextNullable(adg2.getOffsetIBus());
            this.calibOffsetVa.setTextNullable(adg2.getOffsetVa());
            this.calibOffsetVb.setTextNullable(adg2.getOffsetVb());
            this.calibOffsetVc.setTextNullable(adg2.getOffsetVc());
        });
        Optional.ofNullable(aee2.getGearTrain()).ifPresent(aec2 -> {
            this.gearRatioNumerator.setTextNullable(aee2.getGearTrain().getGearRatioNumerator());
            this.gearRatioDenominator.setTextNullable(aee2.getGearTrain().getGearRatioDenominator());
            this.gearEfficiency.setTextNullable(aee2.getGearTrain().getEfficiency());
            this.maxOutputTorque.setTextNullable(aec2.getMaxOutputTorque());
        });
    }

    private void setupInputFields(MotorDriverCommand motorDriverCommand) {
        Object object2 = this.device.getInfo();
        aug aug2 = ((aua)object2).a;
        object2 = aug2;
        auh auh2 = aug2.a;
        object2 = aug2;
        aul aul2 = ((aug)object2).a;
        object2 = aug2;
        atw atw2 = ((aug)object2).a;
        object2 = aug2;
        ats ats2 = ((aug)object2).a;
        Object object3 = aug2;
        ato ato2 = ((aug)object3).a;
        object3 = aug2;
        atp atp2 = ((aug)object3).a;
        object3 = aug2;
        atn atn2 = ((aug)object3).a;
        MotorDriverController motorDriverController = this;
        object3 = atw2;
        motorDriverController.bindIntField(motorDriverController.gearRatioNumerator, (ReadOnlyDoubleProperty)((atw)object3).bx, n2 -> motorDriverCommand.gearTrain().a(n2));
        MotorDriverController motorDriverController2 = this;
        object3 = atw2;
        motorDriverController2.bindIntField(motorDriverController2.gearRatioDenominator, (ReadOnlyDoubleProperty)((atw)object3).bw, n2 -> motorDriverCommand.gearTrain().b(n2));
        MotorDriverController motorDriverController3 = this;
        object3 = atw2;
        motorDriverController3.bindField(motorDriverController3.gearEfficiency, (ReadOnlyDoubleProperty)((atw)object3).bv, f2 -> motorDriverCommand.gearTrain().a(f2));
        MotorDriverController motorDriverController4 = this;
        object3 = atw2;
        motorDriverController4.bindField(motorDriverController4.maxOutputTorque, (ReadOnlyDoubleProperty)((atw)object3).by, f2 -> motorDriverCommand.gearTrain().b(f2));
        for (CustomTextField customTextField : List.of(this.gearRatioNumerator.getTextInput(), this.gearRatioDenominator.getTextInput())) {
            this.validation.registerValidator((Control)customTextField, (control, object) -> {
                boolean bl2 = (!this.gearRatioNumerator.getText().isBlank() || !this.gearRatioDenominator.getText().isBlank()) && !ParseUtils.isInteger(customTextField.getText());
                return ValidationResult.fromErrorIf((Control)customTextField, "Numerator and denominator must be set together.", bl2);
            });
            PropUtil.runOnChange(this.validation::revalidate, new ObservableValue[]{customTextField.textProperty()});
        }
        MotorDriverController motorDriverController5 = this;
        object2 = ats2;
        motorDriverController5.bindEnumField(motorDriverController5.outputEncoder, (ReadOnlyObjectProperty)((ats)object2).s, (Consumer)ajr2 -> motorDriverCommand.encoders().b(ajr2.a));
        MotorDriverController motorDriverController6 = this;
        object2 = ats2;
        motorDriverController6.bindEnumField(motorDriverController6.deflectionEncoder, (ReadOnlyObjectProperty)((ats)object2).q, (Consumer)ajr2 -> motorDriverCommand.encoders().c(ajr2.a));
        MotorDriverController motorDriverController7 = this;
        object2 = ats2;
        motorDriverController7.bindEnumField(motorDriverController7.motorEncoder, (ReadOnlyObjectProperty)((ats)object2).r, (Consumer)ajr2 -> motorDriverCommand.encoders().a(ajr2.a));
        MotorDriverController motorDriverController8 = this;
        object3 = ats2;
        motorDriverController8.bindEnumField(motorDriverController8.torqueSource, (ReadOnlyObjectProperty)((ats)object3).t, (Consumer)ajx2 -> motorDriverCommand.encoders().a(ajx2.a));
        this.encoderA1Controller.bindFields(this, ajr.c, motorDriverCommand);
        this.encoderA2Controller.bindFields(this, ajr.d, motorDriverCommand);
        this.encoderB1Controller.bindFields(this, ajr.e, motorDriverCommand);
        this.encoderB2Controller.bindFields(this, ajr.f, motorDriverCommand);
        this.encoderHallsController.bindFields(this, ajr.g, motorDriverCommand);
        MotorDriverController motorDriverController9 = this;
        object3 = ato2;
        motorDriverController9.bindField(motorDriverController9.minDutyCycle, (ReadOnlyDoubleProperty)((ato)object3).aj, f2 -> motorDriverCommand.board().a(f2));
        MotorDriverController motorDriverController10 = this;
        object3 = ato2;
        motorDriverController10.bindField(motorDriverController10.maxDutyCycle, (ReadOnlyDoubleProperty)((ato)object3).ai, f2 -> motorDriverCommand.board().b(f2));
        MotorDriverController motorDriverController11 = this;
        object3 = ato2;
        motorDriverController11.bindField(motorDriverController11.maxBoardCurrent, (ReadOnlyDoubleProperty)((ato)object3).ah, f2 -> motorDriverCommand.board().c(f2));
        MotorDriverController motorDriverController12 = this;
        object3 = ato2;
        motorDriverController12.bindField(motorDriverController12.switchingFreq, (ReadOnlyDoubleProperty)((ato)object3).ac, f2 -> motorDriverCommand.board().d(f2));
        MotorDriverController motorDriverController13 = this;
        object3 = ato2;
        motorDriverController13.bindField(motorDriverController13.controlDivider, (ReadOnlyDoubleProperty)((ato)object3).ab, f2 -> motorDriverCommand.board().e((int)f2));
        MotorDriverController motorDriverController14 = this;
        object3 = ato2;
        motorDriverController14.bindField(motorDriverController14.currentSenseThresholdVds, (ReadOnlyDoubleProperty)((ato)object3).af, f2 -> motorDriverCommand.board().a((int)f2));
        MotorDriverController motorDriverController15 = this;
        object3 = ato2;
        motorDriverController15.bindField(motorDriverController15.currentSenseThresholdWinding, (ReadOnlyDoubleProperty)((ato)object3).ag, f2 -> motorDriverCommand.board().b((int)f2));
        MotorDriverController motorDriverController16 = this;
        object3 = ato2;
        motorDriverController16.bindField(motorDriverController16.currentFilterSize, (ReadOnlyDoubleProperty)((ato)object3).ad, f2 -> motorDriverCommand.board().d((int)f2));
        MotorDriverController motorDriverController17 = this;
        object3 = ato2;
        motorDriverController17.bindField(motorDriverController17.currentSenseGain, (ReadOnlyDoubleProperty)((ato)object3).ae, f2 -> motorDriverCommand.board().c((int)f2));
        MotorDriverController motorDriverController18 = this;
        object3 = ato2;
        motorDriverController18.bindEnumField(motorDriverController18.windingOrder, (ReadOnlyObjectProperty)((ato)object3).k, (Consumer)ajy2 -> motorDriverCommand.board().a(ajy2.a));
        MotorDriverController motorDriverController19 = this;
        object3 = ato2;
        motorDriverController19.bindEnumField(motorDriverController19.hallOrder, (ReadOnlyObjectProperty)((ato)object3).j, (Consumer)aju2 -> motorDriverCommand.board().a(aju2.a));
        MotorDriverController motorDriverController20 = this;
        object3 = ato2;
        motorDriverController20.bindEnumField(motorDriverController20.hallOffset, (ReadOnlyObjectProperty)((ato)object3).i, (Consumer)ajt2 -> motorDriverCommand.board().a(ajt2.a));
        MotorDriverController motorDriverController21 = this;
        object3 = atn2;
        motorDriverController21.bindField(motorDriverController21.calibOffsetIa, (ReadOnlyDoubleProperty)((atn)object3).V, f2 -> motorDriverCommand.boardCalibration().a(f2));
        MotorDriverController motorDriverController22 = this;
        object3 = atn2;
        motorDriverController22.bindField(motorDriverController22.calibOffsetIb, (ReadOnlyDoubleProperty)((atn)object3).W, f2 -> motorDriverCommand.boardCalibration().b(f2));
        MotorDriverController motorDriverController23 = this;
        object3 = atn2;
        motorDriverController23.bindField(motorDriverController23.calibOffsetIc, (ReadOnlyDoubleProperty)((atn)object3).X, f2 -> motorDriverCommand.boardCalibration().c(f2));
        MotorDriverController motorDriverController24 = this;
        object3 = atn2;
        motorDriverController24.bindField(motorDriverController24.calibOffsetIBus, (ReadOnlyDoubleProperty)((atn)object3).U, f2 -> motorDriverCommand.boardCalibration().d(f2));
        MotorDriverController motorDriverController25 = this;
        object3 = atn2;
        motorDriverController25.bindField(motorDriverController25.calibOffsetVa, (ReadOnlyDoubleProperty)((atn)object3).Y, f2 -> motorDriverCommand.boardCalibration().e(f2));
        MotorDriverController motorDriverController26 = this;
        object3 = atn2;
        motorDriverController26.bindField(motorDriverController26.calibOffsetVb, (ReadOnlyDoubleProperty)((atn)object3).Z, f2 -> motorDriverCommand.boardCalibration().f(f2));
        MotorDriverController motorDriverController27 = this;
        object3 = atn2;
        motorDriverController27.bindField(motorDriverController27.calibOffsetVc, (ReadOnlyDoubleProperty)((atn)object3).aa, f2 -> motorDriverCommand.boardCalibration().g(f2));
        MotorDriverController motorDriverController28 = this;
        object3 = aul2;
        motorDriverController28.bindField(motorDriverController28.windingThermalResistance, (ReadOnlyDoubleProperty)((aul)object3).cN, f2 -> motorDriverCommand.thermalModel().a(f2));
        MotorDriverController motorDriverController29 = this;
        object3 = aul2;
        motorDriverController29.bindField(motorDriverController29.windingThermalTimeConstant, (ReadOnlyDoubleProperty)((aul)object3).cO, f2 -> motorDriverCommand.thermalModel().c(f2));
        MotorDriverController motorDriverController30 = this;
        object3 = aul2;
        motorDriverController30.bindField(motorDriverController30.housingThermalResistance, (ReadOnlyDoubleProperty)((aul)object3).cK, f2 -> motorDriverCommand.thermalModel().b(f2));
        MotorDriverController motorDriverController31 = this;
        object3 = aul2;
        motorDriverController31.bindField(motorDriverController31.housingThermalTimeConstant, (ReadOnlyDoubleProperty)((aul)object3).cL, f2 -> motorDriverCommand.thermalModel().d(f2));
        MotorDriverController motorDriverController32 = this;
        object3 = aul2;
        motorDriverController32.bindField(motorDriverController32.thermalModelStartPercentage, (ReadOnlyDoubleProperty)((aul)object3).cM, f2 -> motorDriverCommand.thermalModel().f(f2));
        MotorDriverController motorDriverController33 = this;
        object3 = aul2;
        motorDriverController33.bindField(motorDriverController33.temperatureSourceUserValue, (ReadOnlyDoubleProperty)((aul)object3).cJ, f2 -> motorDriverCommand.thermalModel().e(f2));
        MotorDriverController motorDriverController34 = this;
        object3 = aul2;
        motorDriverController34.bindEnumField(motorDriverController34.temperatureSource, (ReadOnlyObjectProperty)((aul)object3).H, (Consumer)ajw2 -> motorDriverCommand.thermalModel().a(ajw2.a));
        MotorDriverController motorDriverController35 = this;
        object3 = atp2;
        motorDriverController35.bindField(motorDriverController35.slewRateVoltage, (ReadOnlyDoubleProperty)((atp)object3).ao, f2 -> motorDriverCommand.controller().b(f2));
        MotorDriverController motorDriverController36 = this;
        object3 = atp2;
        motorDriverController36.bindField(motorDriverController36.slewRateCurrent, (ReadOnlyDoubleProperty)((atp)object3).an, f2 -> motorDriverCommand.controller().c(f2));
        MotorDriverController motorDriverController37 = this;
        object3 = atp2;
        motorDriverController37.bindField(motorDriverController37.motorElectricalPowerLimit, (ReadOnlyDoubleProperty)((atp)object3).ak, f2 -> motorDriverCommand.controller().d(f2));
        MotorDriverController motorDriverController38 = this;
        object3 = atp2;
        motorDriverController38.bindField(motorDriverController38.motorMechanicalPowerLimit, (ReadOnlyDoubleProperty)((atp)object3).al, f2 -> motorDriverCommand.controller().e(f2));
        MotorDriverController motorDriverController39 = this;
        object2 = auh2;
        motorDriverController39.bindField(motorDriverController39.polePairs, (ReadOnlyDoubleProperty)((auh)object2).cv, f2 -> motorDriverCommand.motor().a((int)f2));
        MotorDriverController motorDriverController40 = this;
        object3 = auh2;
        motorDriverController40.bindField(motorDriverController40.speedConstant, (ReadOnlyDoubleProperty)((auh)object3).cx, f2 -> motorDriverCommand.motor().f(f2));
        MotorDriverController motorDriverController41 = this;
        object3 = auh2;
        motorDriverController41.bindField(motorDriverController41.torqueConstant, (ReadOnlyDoubleProperty)((auh)object3).cy, f2 -> motorDriverCommand.motor().g(f2));
        MotorDriverController motorDriverController42 = this;
        object3 = auh2;
        motorDriverController42.bindField(motorDriverController42.maxMotorSpeed, (ReadOnlyDoubleProperty)((auh)object3).cs, f2 -> motorDriverCommand.motor().c(f2));
        MotorDriverController motorDriverController43 = this;
        object3 = auh2;
        motorDriverController43.bindField(motorDriverController43.windingResistance, (ReadOnlyDoubleProperty)((auh)object3).cC, f2 -> motorDriverCommand.motor().e(f2));
        MotorDriverController motorDriverController44 = this;
        object3 = auh2;
        motorDriverController44.bindField(motorDriverController44.windingInductance, (ReadOnlyDoubleProperty)((auh)object3).cB, f2 -> motorDriverCommand.motor().d((float)((double)f2 * 0.001)));
        MotorDriverController motorDriverController45 = this;
        object2 = auh2;
        motorDriverController45.bindField(motorDriverController45.windingMaxCurrent, (ReadOnlyDoubleProperty)((auh)object2).ct, f2 -> motorDriverCommand.motor().a(f2));
        MotorDriverController motorDriverController46 = this;
        object3 = auh2;
        motorDriverController46.bindField(motorDriverController46.windingMaxTemp, (ReadOnlyDoubleProperty)((auh)object3).cu, f2 -> motorDriverCommand.motor().b(f2));
        MotorDriverController motorDriverController47 = this;
        object3 = auh2;
        motorDriverController47.bindField(motorDriverController47.motorVelocityTempConstant, (ReadOnlyDoubleProperty)((auh)object3).cA, f2 -> motorDriverCommand.motor().i(f2));
        MotorDriverController motorDriverController48 = this;
        object3 = auh2;
        motorDriverController48.bindField(motorDriverController48.motorTorqueTempConstant, (ReadOnlyDoubleProperty)((auh)object3).cz, f2 -> motorDriverCommand.motor().h(f2));
        MotorDriverController motorDriverController49 = this;
        object3 = auh2;
        motorDriverController49.bindField(motorDriverController49.motorRotorInertia, (ReadOnlyDoubleProperty)((auh)object3).cw, f2 -> motorDriverCommand.motor().j(f2));
        MotorDriverController motorDriverController50 = this;
        object2 = atp2;
        object2 = ((atp)object2).b;
        motorDriverController50.bindField(motorDriverController50.focIqKp, (ReadOnlyDoubleProperty)((atu)object2).aE, f2 -> motorDriverCommand.controller().b().a(f2));
        MotorDriverController motorDriverController51 = this;
        object2 = atp2;
        object2 = ((atp)object2).b;
        motorDriverController51.bindField(motorDriverController51.focIqKi, (ReadOnlyDoubleProperty)((atu)object2).aD, f2 -> motorDriverCommand.controller().b().b(f2));
        MotorDriverController motorDriverController52 = this;
        object2 = atp2;
        object2 = ((atp)object2).b;
        motorDriverController52.bindField(motorDriverController52.focIqIClamp, (ReadOnlyDoubleProperty)((atu)object2).aC, f2 -> motorDriverCommand.controller().b().f(f2));
        MotorDriverController motorDriverController53 = this;
        object2 = atp2;
        object2 = ((atp)object2).a;
        motorDriverController53.bindField(motorDriverController53.focIdKp, (ReadOnlyDoubleProperty)((atu)object2).aE, f2 -> motorDriverCommand.controller().a().a(f2));
        MotorDriverController motorDriverController54 = this;
        object2 = atp2;
        object2 = ((atp)object2).a;
        motorDriverController54.bindField(motorDriverController54.focIdKi, (ReadOnlyDoubleProperty)((atu)object2).aD, f2 -> motorDriverCommand.controller().a().b(f2));
        MotorDriverController motorDriverController55 = this;
        object2 = atp2;
        object2 = ((atp)object2).a;
        motorDriverController55.bindField(motorDriverController55.focIdIClamp, (ReadOnlyDoubleProperty)((atu)object2).aC, f2 -> motorDriverCommand.controller().a().f(f2));
        this.suggestFocGainsButton.disableProperty().bind((ObservableValue)this.focIdKp.getTextInput().disableProperty());
        this.suggestFocGainsButton.setOnAction(actionEvent -> {
            ato ato3 = ato2;
            Object object = ato3;
            object = ato2;
            double d2 = ato3.ac.get() / Math.max(((ato)object).ab.get(), 1.0);
            long l2 = Math.round(d2 * 0.05);
            TextInputDialog textInputDialog = new TextInputDialog(String.valueOf(l2));
            textInputDialog.setHeaderText("The controller bandwidth defaults to 5% of the sampling frequency (" + apr.a(d2 / 1000.0) + " KHz).");
            textInputDialog.setContentText("Controller bandwidth [Hz]");
            Optional optional = textInputDialog.showAndWait();
            if (optional.isPresent()) {
                double d3 = TextUtil.parseDouble((String)optional.get());
                if (!Double.isFinite(d3)) {
                    awg.a((String)optional.get() + " is not a valid value.", bdc.a(actionEvent));
                    return;
                }
                auh auh3 = auh2;
                object = auh3;
                object = auh2;
                double d4 = d3;
                double d5 = d2;
                double d6 = (float)(((auh)object).cB.get() * 0.001);
                double d7 = auh3.cC.get();
                double d8 = 1.0 / d5;
                double d9 = d4 * (Math.PI * 2) * d8;
                double d10 = d7 * (d9 / (1.0 - Math.exp(-d7 * d8 / d6)));
                double d11 = 1.0 - Math.exp(-d7 * d8 / d6);
                ayd ayd2 = new ayd(d10, d11);
                object = auh2;
                double d12 = ((auh)object).ct.get() * 0.1;
                this.focIqKp.setTextNullable(ayd2.dv);
                this.focIqKi.setTextNullable(ayd2.dw);
                this.focIqIClamp.setTextNullable(d12);
                if (this.showAdvancedToggle.isSelected()) {
                    this.focIdKp.setTextNullable(ayd2.dv);
                    this.focIdKi.setTextNullable(ayd2.dw);
                    this.focIdIClamp.setTextNullable(d12);
                }
            }
        });
        this.calibrateMotorEncoderBtn.disableProperty().bind((ObservableValue)this.motorEncoder.disabledProperty());
        this.calibrateMotorEncoderBtn.setOnAction(actionEvent -> this.dialogService.a(this.motorEncoderCalibrationDialog).setOnResult(ayk2 -> {}));
        this.calibrateAdcBtn.disableProperty().bind((ObservableValue)this.calibOffsetIa.getTextInput().disabledProperty());
        this.calibrateAdcBtn.setOnAction(actionEvent -> this.dialogService.a(this.adcCalibrationDialog).setOnResult(axw2 -> {
            this.calibOffsetIa.setTextNullable(Float.valueOf(axw2.Q));
            this.calibOffsetIb.setTextNullable(Float.valueOf(axw2.R));
            this.calibOffsetIc.setTextNullable(Float.valueOf(axw2.S));
            this.calibOffsetIBus.setTextNullable(Float.valueOf(axw2.T));
        }));
        bdc.b(() -> {
            if (!this.showAdvancedToggle.isSelected()) {
                this.focIdKp.setText(this.focIqKp.getText());
                this.focIdKi.setText(this.focIqKi.getText());
                this.focIdIClamp.setText(this.focIqIClamp.getText());
            }
        }, new Observable[]{this.showAdvancedToggle.selectedProperty(), this.focIqKp.textProperty(), this.focIqKi.textProperty(), this.focIqIClamp.textProperty()});
        this.controlMode.getChoiceBox().setDisable(true);
        MotorDriverController motorDriverController56 = this;
        object3 = atp2;
        motorDriverController56.bindEnumField(motorDriverController56.controlMode, (ReadOnlyObjectProperty)((atp)object3).l, (Consumer)ajv2 -> {});
    }

    <E extends Enum<E>> void bindEnumField(HEnumInputField<E> hEnumInputField, ReadOnlyObjectProperty<E> readOnlyObjectProperty, Consumer<E> consumer) {
        Enum enum_ = MotorDriverController.getDefaultEnumValue((Enum)readOnlyObjectProperty.get());
        hEnumInputField.initValues(readOnlyObjectProperty, enum_);
        this.validation.registerValidator((Control)hEnumInputField.getChoiceBox(), false, bcq.a(hEnumInputField));
        this.onClear.add(hEnumInputField::clear);
        this.addInputList.add(() -> {
            Object e2 = hEnumInputField.getValue();
            if (e2 != null && e2 != enum_) {
                consumer.accept(e2);
            }
        });
    }

    private static <E extends Enum<E>> E getDefaultEnumValue(E e2) {
        if (e2 instanceof ajs) {
            return (E)((Object)ajs.a);
        }
        if (e2 instanceof ajr) {
            return (E)((Object)ajr.a);
        }
        if (e2 instanceof ajx) {
            return (E)((Object)ajx.a);
        }
        if (e2 instanceof ajw) {
            return (E)((Object)ajw.a);
        }
        if (e2 instanceof ajy) {
            return (E)((Object)ajy.a);
        }
        if (e2 instanceof aju) {
            return (E)((Object)aju.a);
        }
        if (e2 instanceof ajt) {
            return (E)((Object)ajt.a);
        }
        if (e2 instanceof ajp) {
            return (E)((Object)ajp.a);
        }
        if (e2 instanceof ajq) {
            return (E)((Object)ajq.a);
        }
        if (e2 instanceof ajo) {
            return (E)((Object)ajo.a);
        }
        if (e2 instanceof ajv) {
            return (E)((Object)ajv.a);
        }
        throw new IllegalArgumentException("Unknown default type for: " + String.valueOf(e2));
    }

    void bindField(HDoubleInputField hDoubleInputField, ReadOnlyDoubleProperty readOnlyDoubleProperty, aqn aqn2) {
        hDoubleInputField.feedbackValueProperty().bind((ObservableValue)readOnlyDoubleProperty);
        CustomTextField customTextField = hDoubleInputField.getTextInput();
        Validator<String> validator = bcq.a(customTextField, ParseUtils.FINITE_DOUBLE_VALIDATOR, readOnlyDoubleProperty, 0.001);
        this.validation.registerValidator((Control)customTextField, false, validator);
        this.addInputList.add(() -> {
            Double d2;
            if (!customTextField.getText().isBlank() && (d2 = ParseUtils.tryParseFiniteDouble(customTextField)) != null) {
                aqn2.accept(d2.floatValue());
            }
        });
        this.onClear.add(() -> ((CustomTextField)customTextField).clear());
    }

    void bindIntField(HDoubleInputField hDoubleInputField, ReadOnlyDoubleProperty readOnlyDoubleProperty, IntConsumer intConsumer) {
        hDoubleInputField.feedbackValueProperty().bind((ObservableValue)readOnlyDoubleProperty);
        CustomTextField customTextField = hDoubleInputField.getTextInput();
        Validator<String> validator = bcq.a(customTextField, ParseUtils.INTEGER_VALIDATOR, readOnlyDoubleProperty, 0.001);
        this.validation.registerValidator((Control)customTextField, false, validator);
        this.addInputList.add(() -> {
            Integer n2;
            if (!customTextField.getText().isBlank() && (n2 = ParseUtils.tryParseInteger(customTextField.getText())) != null) {
                intConsumer.accept(n2);
            }
        });
        this.onClear.add(() -> ((CustomTextField)customTextField).clear());
    }

    @Generated
    public ToggleButton getPersistToggle() {
        return this.persistToggle;
    }
}

