/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.assets;

import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.DrawMode;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import us.hebi.gui.lib.apt;
import us.hebi.gui.lib.aqy;
import us.hebi.gui.views.scope.assets.AssetCache;
import us.hebi.gui.views.scope.assets.AssetLoader;

public enum Asset {
    A_2038_02("01-HEBI_A-2038-02_Export.obj", new Transform[0]),
    A_2039_02("02-HEBI_A-2039-02_Export.obj", new Transform[]{new Rotate(180.0, Rotate.Z_AXIS), new Rotate(180.0, Rotate.X_AXIS)}),
    A_2040_01L_Inside("03-HEBI_A-2040-01L-Inside_Export.obj", new Transform[0]),
    A_2040_01L_Outside("04-HEBI_A-2040-01L-Outside_Export.obj", new Transform[0]),
    A_2040_01R_Inside("05-HEBI_A-2040-01R-Inside_Export.obj", new Transform[0]),
    A_2040_01R_Outside("06-HEBI_A-2040-01R-Outside_Export.obj", new Transform[0]),
    A_2042_01L("07-HEBI_A-2042-01L_Export.obj", new Transform[0]),
    A_2042_01R("08-HEBI_A-2042-01R_Export.obj", new Transform[0]),
    A_2043_01("09-HEBI_A-2043-01_Export.obj", new Transform[0]),
    A_2074_01("10-HEBI_A-2074-01_Export.obj", new Transform[0]),
    Gripper("12-HEBI_Gripper_Export.obj", new Transform[0]),
    A_2220_01_Right("HEBI_A-2220-01_Export.obj", new Transform[0]),
    A_2220_01_Left("HEBI_A-2220-01_Export.obj", new Transform[]{new Rotate(180.0, Rotate.Z_AXIS)}),
    A_2221_01_Inside("HEBI_A-2221-01-Inside_Export.obj", new Transform[0]),
    A_2221_01_Inside_Flip("HEBI_A-2221-01-Inside_Export_Flip.obj", new Transform[0]),
    A_2221_01_Outside("HEBI_A-2221-01-Outside_Export.obj", new Transform[0]),
    A_2221_01_Outside_Flip("HEBI_A-2221-01-Outside_Export_Flip.obj", new Transform[0]),
    A_2222_01_Inside("HEBI_A-2222-01-Inside_Export.obj", new Transform[0]),
    A_2222_01_Outside("HEBI_A-2222-01-Outside_Export.obj", new Transform[0]),
    A_2225_01("HEBI_A-2225-01_Export.obj", new Transform[0]),
    A_2119_01("HEBI_A-2119-01_Export.obj", new Transform[0]),
    A_2226_01("HEBI_A-2226-01_Export.obj", new Transform[0]),
    A_2636_01_LightRightAngle_55_Right("A-2636-01.obj", new Transform[0]),
    A_2636_01_LightRightAngle_55_Left("A-2636-01.obj", new Transform[]{new Rotate(180.0, Rotate.Z_AXIS)}),
    A_2635_01_Heavy_Right_Angle_Bracket_Inside_55_Right("A-2635-01_rightInside.obj", new Transform[]{new Rotate(180.0, Rotate.Z_AXIS), new Rotate(90.0, Rotate.X_AXIS)}),
    A_2635_01_Heavy_Right_Angle_Bracket_Inside_55_Left("A-2635-01_leftInside.obj", new Transform[]{new Rotate(90.0, Rotate.X_AXIS)}),
    A_2635_01_Heavy_Right_Angle_Bracket_Outside_55_Right("A-2635-01_rightOutside.obj", new Transform[]{new Rotate(180.0, Rotate.Z_AXIS), new Rotate(90.0, Rotate.X_AXIS)}),
    A_2635_01_Heavy_Right_Angle_Bracket_Outside_55_Left("A-2635-01_leftOutside.obj", new Transform[]{new Rotate(90.0, Rotate.X_AXIS)}),
    A_2631_01_Output_Tube_Adapter_Size_55("A-2631-01.obj", new Transform[]{new Rotate(180.0, Rotate.Z_AXIS), new Rotate(90.0, Rotate.X_AXIS)}),
    A_2632_01_Input_Tube_Adapter_Size_55("A-2632-01.obj", new Transform[]{new Rotate(-90.0, Rotate.X_AXIS)}),
    A_2634_01_Input_Tube_Adapter_Size_55_to_Size_35("A-2634-01.obj", new Transform[]{new Rotate(-90.0, Rotate.X_AXIS)}),
    A_2645_01_Output_Inline_Adapter_55("A-2645-01.obj", new Transform[]{new Rotate(90.0, Rotate.X_AXIS)}),
    A_2646_01_Input_Inline_Adapter_55("A-2646-01.obj", new Transform[]{new Rotate(-90.0, Rotate.X_AXIS)}),
    PE_2033_01("HEBI_PE-2033-01.obj", new Transform[0]),
    PM_2132_01L("HEBI_PM-2132-01L_Export.obj", new Transform[0]),
    PM_2132_01R("HEBI_PM-2132-01R_Export.obj", new Transform[0]),
    PM_2200_01("HEBI_PM-2200-01_Export.obj", new Transform[0]),
    PM_2200_02("HEBI_PM-2200-02_Export.obj", new Transform[0]),
    R8("HEBI_R8_Export.obj", new Transform[0]),
    X5("HEBI_X5_Export.obj", new Transform[0]),
    X8("HEBI_X8_Export.obj", new Transform[0]),
    T5("HEBI_T5_Export.obj", new Transform[0]),
    T8("HEBI_T8_Export.obj", new Transform[0]),
    T25("HEBI_T25_Export.obj", new Transform[]{new Rotate(90.0, Rotate.X_AXIS)}),
    R25("HEBI_R25_Export.obj", new Transform[]{new Translate(0.0, 0.0, 57.5), new Rotate(90.0, Rotate.X_AXIS)}),
    Iphone("GrabCad_Iphone.obj", new Transform[]{new Rotate(90.0, Rotate.X_AXIS)});

    private static final List<Asset> commonAssets;
    public static double X5_TUBE_RADIUS;
    public static double R25_TUBE_RADIUS;
    private static final boolean enableTubeModels = false;
    public static final PhongMaterial TUBE_MATERIAL;
    private final AssetLoader loader;
    private final Transform[] transforms;
    private final URL url;

    private static URL getUrl(String string) {
        return Optional.ofNullable(System.getProperty("hebi.assets.directory")).map(apt.a(string2 -> new URI((String)string2).resolve(string).toURL())).orElseGet(() -> Asset.class.getResource(string));
    }

    private Asset(String string2, Transform ... transformArray) {
        String string3 = string2.replace(".obj", ".fxobj");
        this.url = Objects.requireNonNull(Asset.getUrl(string3), () -> "built-in asset is missing: " + string3);
        this.transforms = transformArray;
        this.loader = AssetCache.getLoader(this.url);
    }

    public final void getModelAsync(Consumer<Group> consumer) {
        this.loader.getModelAsync(group -> consumer.accept(this.applyTransforms((Group)group)));
    }

    public final Group getModel() {
        Asset asset = this;
        return asset.applyTransforms(asset.loader.getModel());
    }

    private Group applyTransforms(Group group) {
        if (this.transforms.length > 0) {
            group.getTransforms().addAll((Object[])this.transforms);
        }
        return group;
    }

    public static Node getTubeModel(double d2, double d3) {
        Cylinder cylinder = new Cylinder(d2, aqy.a.f(d3), 16);
        cylinder.setCullFace(CullFace.BACK);
        cylinder.setDrawMode(DrawMode.FILL);
        cylinder.setMaterial((Material)TUBE_MATERIAL);
        cylinder.getTransforms().add((Object)new Rotate(-90.0, Rotate.X_AXIS));
        Cylinder cylinder2 = cylinder;
        cylinder2.setTranslateZ(cylinder2.getHeight() / 2.0);
        return cylinder;
    }

    final URL getUrl() {
        return this.url;
    }

    public static void loadCommonAssets() {
        commonAssets.forEach(asset -> asset.loader.preloadAsync());
    }

    static {
        commonAssets = List.of(A_2038_02, A_2039_02, A_2074_01, A_2119_01, X5, X8, PM_2132_01R, A_2040_01R_Outside, R8, A_2220_01_Right, A_2221_01_Outside, Gripper);
        X5_TUBE_RADIUS = 15.875;
        R25_TUBE_RADIUS = 22.5;
        TUBE_MATERIAL = new PhongMaterial();
        TUBE_MATERIAL.setDiffuseColor(Color.web((String)"0x404040ff"));
        TUBE_MATERIAL.setSpecularColor(Color.web((String)"0x333333ff"));
        TUBE_MATERIAL.setSpecularPower(20.0);
    }
}

