/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.utils;

import io.fair_acc.dataset.events.ChartBits;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import us.hebi.gui.lib.apr;
import us.hebi.gui.lib.aqm;
import us.hebi.gui.lib.aqy;
import us.hebi.gui.lib.azq;
import us.hebi.gui.lib.bnp;
import us.hebi.gui.lib.bol;
import us.hebi.gui.lib.bpo;

public class MapsFeedbackDataSet
extends azq<MapsFeedbackDataSet> {
    final bol message = bol.a();
    final bpo utData;
    final DoubleProperty soundVelocity;
    final DoubleProperty thicknessMillimeters;
    final BooleanProperty hasThickness;
    aqm xTransform;
    aqm yTransform;

    public MapsFeedbackDataSet(String string) {
        super(string);
        this.utData = this.message.a.a;
        this.soundVelocity = new SimpleDoubleProperty(Double.NaN);
        this.thicknessMillimeters = new SimpleDoubleProperty(Double.NaN);
        this.hasThickness = new SimpleBooleanProperty(false);
        this.xTransform = d2 -> d2 / (double)this.getSamplingRate();
        this.yTransform = d2 -> Math.abs(d2 * 100.0) / 128.0;
        this.soundVelocity.addListener(observable -> {
            if (Double.isNaN(this.soundVelocity.get())) {
                this.xTransform = d2 -> d2 / (double)this.getSamplingRate();
                return;
            }
            this.xTransform = d2 -> d2 * this.getIndexToMillimeterScale();
        });
    }

    public void setData(bol bol2) {
        this.message.a(bol2);
        bnp bnp2 = this.message.a.a;
        if (bnp2.bO()) {
            this.thicknessMillimeters.set(apr.a((double)bnp2.ec * this.getIndexToMillimeterScale()));
            this.hasThickness.set(true);
        } else {
            this.hasThickness.set(false);
        }
        this.recomputeLimitsInternal();
        this.fireInvalidated(ChartBits.DataSetData);
    }

    @Override
    public double getX(int n2) {
        return this.xTransform.apply(n2);
    }

    @Override
    public double getY(int n2) {
        return this.yTransform.apply(this.utData.a.a(n2));
    }

    @Override
    public int getDataCount() {
        return this.utData.a.ar();
    }

    public int getSamplingRate() {
        if (this.utData.dq()) {
            return this.utData.ct;
        }
        return 100000000;
    }

    private double getIndexToMillimeterScale() {
        return aqy.a.f(this.soundVelocity.get()) / (double)this.getSamplingRate() / 2.0;
    }

    public double getSoundVelocity() {
        return this.soundVelocity.get();
    }

    public DoubleProperty soundVelocityProperty() {
        return this.soundVelocity;
    }

    public void setSoundVelocity(double d2) {
        this.soundVelocity.set(d2);
    }

    public double getThicknessMillimeters() {
        return this.thicknessMillimeters.get();
    }

    public ReadOnlyDoubleProperty thicknessMillimetersProperty() {
        return this.thicknessMillimeters;
    }
}

