/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.hebilog;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import us.hebi.gui.lib.ae;
import us.hebi.gui.lib.aqd;
import us.hebi.gui.lib.aqp;
import us.hebi.gui.lib.aqy;
import us.hebi.gui.lib.azk;
import us.hebi.gui.lib.bat;
import us.hebi.gui.lib.bfu;
import us.hebi.gui.lib.bfy;
import us.hebi.gui.lib.bga;
import us.hebi.gui.lib.bgb;
import us.hebi.gui.lib.bge;
import us.hebi.gui.lib.bgg;
import us.hebi.gui.lib.bgi;
import us.hebi.gui.lib.bgl;
import us.hebi.gui.lib.bhm;
import us.hebi.gui.lib.bhn;
import us.hebi.gui.lib.bho;
import us.hebi.gui.lib.blm;
import us.hebi.gui.lib.jc;
import us.hebi.gui.lib.jf;
import us.hebi.gui.lib.lu;
import us.hebi.gui.lib.ne;
import us.hebi.gui.views.logviewer.hebilog.HebiLogFeedback;
import us.hebi.gui.views.logviewer.state.ChartCategory;
import us.hebi.gui.views.logviewer.state.ChartList;
import us.hebi.gui.views.logviewer.state.TDoubleArrayListRegistry;

public class XyzLogData {
    private bho treeFK;
    private bhm FK;
    private bhn numericalJacobian;
    private bgl staticConnections;
    private int numEntries = 0;
    private int numDevices = 0;
    private jc time;
    private jc[] position;
    private jc[] positionCmd;
    private jc[] velocity;
    private jc[] velocityCmd;
    private jc[] gyroX;
    private jc[] gyroY;
    private jc[] gyroZ;
    public jc[] centerOfMass;
    public jc[] xyzPosition;
    public jc[] xyzPositionCmd;
    public jc xyzPositionErrorMagnitude;
    public jc[] xyzVelocity;
    public jc[] xyzVelocityCmd;
    public jc xyzVelocityMagnitude;
    public jc xyzVelocityMagnitudeCmd;
    public jc[] imuVelocity;
    private double[] tmpPos;
    private double[] tmpPosCmd;
    private double[] tmpVel;
    private double[] tmpVelCmd;
    public static final aqp SAME_INDEX = n2 -> n2;
    private aqp indexMap = SAME_INDEX;
    static final double XYZ_SCALE = aqy.a.f(1.0);

    public void setLogData(HebiLogFeedback hebiLogFeedback) {
        this.time = hebiLogFeedback.time;
        this.position = hebiLogFeedback.position;
        this.positionCmd = hebiLogFeedback.positionCmd;
        this.velocity = hebiLogFeedback.velocity;
        this.velocityCmd = hebiLogFeedback.velocityCmd;
        this.gyroX = hebiLogFeedback.gyroX;
        this.gyroY = hebiLogFeedback.gyroY;
        this.gyroZ = hebiLogFeedback.gyroZ;
        this.numEntries = hebiLogFeedback.time.size();
        this.numDevices = hebiLogFeedback.numJoints;
        this.update();
    }

    public void setKinematics(bgi bgi2, aqp aqp2) {
        this.treeFK = new bho(bgi2);
        bgg bgg2 = bgi2.a(true);
        this.FK = new bhm(bgg2);
        this.numericalJacobian = new bhn(this.FK);
        bgi bgi3 = bgi2;
        bgl bgl2 = new bgl(bgi3.Q());
        bfy bfy2 = bfy.d();
        jf jf2 = new jf(bgi3.P());
        for (int i2 = 0; i2 < bgi3.Q(); ++i2) {
            jf2.clear();
            boolean bl2 = false;
            int n2 = bgi3.ak.indexOf(bgi3.N.get(i2));
            block1: for (int i3 = n2 + 1; i3 < bgi3.a.size() && !bl2; ++i3) {
                Object object;
                if (bgi3.a.l(i3) == n2) {
                    object = bgi3.ak.get(i3);
                    if (object instanceof bge) {
                        bl2 = true;
                        bgl2.bj[i2] = bgi3.N.indexOf((bge)object);
                    } else {
                        jf2.d(i3);
                        n2 = i3;
                    }
                }
                int n3 = i2;
                object = bgl2.a[n3];
                bfy2.c();
                int n4 = 0;
                while (true) {
                    jf jf3 = jf2;
                    if (n4 >= jf3.S) continue block1;
                    int n5 = jf2.l(n4);
                    bfy bfy3 = bgi3.ak.get(n5).h();
                    bga.a(bfy2, bfy3, (bfy)object);
                    bfy2.c((bfy)object);
                    ++n4;
                }
            }
        }
        this.staticConnections = bgl2;
        this.indexMap = aqp2 == null ? SAME_INDEX : aqp2;
        this.update();
    }

    public boolean hasValidCombination() {
        return this.FK != null && this.numEntries > 0 && this.FK.c.numJoints == this.numDevices;
    }

    public void update() {
        if (!this.hasValidCombination()) {
            return;
        }
        this.resize();
        bgb bgb2 = bgb.d();
        bgb bgb3 = bgb.d();
        lu lu2 = new lu(0, 0);
        lu lu3 = new lu(0, 0);
        bfy bfy2 = bfy.d();
        bfu bfu2 = new bfu();
        for (int i2 = 0; i2 < this.numEntries; ++i2) {
            this.fillTmpArrays(i2);
            bgb bgb4 = bgb3;
            double[] dArray = this.tmpPos;
            this.treeFK.a(this.tmpPos).a(bgb4);
            bgb3.a(XYZ_SCALE);
            this.centerOfMass[0].c(bgb3.a1);
            this.centerOfMass[1].c(bgb3.a2);
            this.centerOfMass[2].c(bgb3.a3);
            this.FK.a(this.tmpPos, bfy2);
            this.xyzPosition[0].c(XYZ_SCALE * bfy2.ea);
            this.xyzPosition[1].c(XYZ_SCALE * bfy2.ec);
            this.xyzPosition[2].c(XYZ_SCALE * bfy2.eg);
            this.FK.a(this.tmpPosCmd, bfy2);
            this.xyzPositionCmd[0].c(XYZ_SCALE * bfy2.ea);
            this.xyzPositionCmd[1].c(XYZ_SCALE * bfy2.ec);
            this.xyzPositionCmd[2].c(XYZ_SCALE * bfy2.eg);
            double d2 = this.xyzPositionCmd[0].a(i2) - this.xyzPosition[0].a(i2);
            double d3 = this.xyzPositionCmd[1].a(i2) - this.xyzPosition[1].a(i2);
            double d4 = this.xyzPositionCmd[2].a(i2) - this.xyzPosition[2].a(i2);
            double d5 = d2;
            double d6 = d3;
            double d7 = d4;
            this.xyzPositionErrorMagnitude.c(Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7));
            this.numericalJacobian.a(this.tmpPos, bfu2);
            lu2.a(this.tmpVelCmd.length, 1, true, this.tmpVel);
            ne.a(bfu2, lu2, lu3);
            double d8 = XYZ_SCALE * lu3.h[0];
            double d9 = XYZ_SCALE * lu3.h[1];
            double d10 = XYZ_SCALE * lu3.h[2];
            this.xyzVelocity[0].c(d8);
            this.xyzVelocity[1].c(d9);
            this.xyzVelocity[2].c(d10);
            double d11 = d8;
            double d12 = d9;
            double d13 = d10;
            this.xyzVelocityMagnitude.c(Math.sqrt(d11 * d11 + d12 * d12 + d13 * d13));
            this.numericalJacobian.a(this.tmpPosCmd, bfu2);
            lu2.a(this.tmpVelCmd.length, 1, true, this.tmpVelCmd);
            ne.a(bfu2, lu2, lu3);
            d8 = XYZ_SCALE * lu3.h[0];
            d9 = XYZ_SCALE * lu3.h[1];
            d10 = XYZ_SCALE * lu3.h[2];
            this.xyzVelocityCmd[0].c(d8);
            this.xyzVelocityCmd[1].c(d9);
            this.xyzVelocityCmd[2].c(d10);
            double d14 = d8;
            double d15 = d9;
            double d16 = d10;
            this.xyzVelocityMagnitudeCmd.c(Math.sqrt(d14 * d14 + d15 * d15 + d16 * d16));
            for (int i3 = 0; i3 < this.numDevices; ++i3) {
                double d17 = Double.NaN;
                int n2 = i3;
                Object object = this.staticConnections;
                if (n2 < ((bgl)object).bj.length && ((bgl)object).bj[n2] >= 0) {
                    n2 = i3;
                    int n3 = this.staticConnections.bj[n2];
                    bgb2.a1 = this.gyroX[n3].a(i2);
                    bgb2.a2 = this.gyroY[n3].a(i2);
                    bgb2.a3 = this.gyroZ[n3].a(i2);
                    int n4 = i3;
                    bgb4 = bgb3;
                    bgb bgb5 = bgb2;
                    object = this.staticConnections.a[n4];
                    bgb4.a1 = ((bfy)object).u * bgb5.a1 + ((bfy)object).w * bgb5.a2 + ((bfy)object).ed * bgb5.a3;
                    bgb4.a2 = ((bfy)object).v * bgb5.a1 + ((bfy)object).x * bgb5.a2 + ((bfy)object).ee * bgb5.a3;
                    bgb4.a3 = ((bfy)object).dZ * bgb5.a1 + ((bfy)object).eb * bgb5.a2 + ((bfy)object).ef * bgb5.a3;
                    d17 = bgb3.a3 - this.gyroZ[i3].a(i2);
                }
                this.imuVelocity[i3].c(d17);
            }
        }
    }

    public void getCharts(ChartList chartList) {
        if (!this.hasValidCombination()) {
            return;
        }
        chartList.setTime(this.time).setTraceType(bat.a).addXyzCommandChart(ChartCategory.Cartesian, "Position", "mm", -50.0, 50.0, this.xyzPositionCmd, this.xyzPosition).addXyzErrorChart(ChartCategory.Cartesian, "Position Error", "mm", 0.0, 50.0, this.xyzPositionCmd, this.xyzPosition).addSingleTrace(ChartCategory.Cartesian, "Position Error Magnitude", "mm", 0.0, 10.0, this.xyzPositionErrorMagnitude).addXyzCommandChart(ChartCategory.Cartesian, "Velocity", "mm/s", -50.0, 50.0, this.xyzVelocityCmd, this.xyzVelocity).addXyzErrorChart(ChartCategory.Cartesian, "Velocity Error", "mm/s", 0.0, 50.0, this.xyzVelocityCmd, this.xyzVelocity).addTimeTraces((Supplier<String>)ChartCategory.Cartesian, "Velocity Magnitude", "mm/s", 0.0, 500.0, new jc[]{this.xyzVelocityMagnitudeCmd, this.xyzVelocityMagnitude}, renderer -> {
            azk.a(renderer, 0, "xyz velocity command", "trace-dashed", "color-primary-muted");
            azk.a(renderer, 1, "xyz velocity feedback", "trace-solid", "color-primary");
        }).addXyzChart(ChartCategory.Cartesian, "Center of Mass", "mm", -50.0, 50.0, this.centerOfMass).addCommandChart(ChartCategory.Encoders, "Velocity IMU", "rad/s", -5.0, 5.0, this.imuVelocity, this.velocity).addErrorChart(ChartCategory.Encoders, "Velocity IMU Error", "rad/s", 0.0, 0.05, this.imuVelocity, this.velocity);
    }

    public static aqp createIndexMap(List<String> list, List<String> list2) {
        blm.a(list.size() == list2.size(), "source names do not match hrdf names");
        if (Objects.equals(list, list2)) {
            return SAME_INDEX;
        }
        ToIntFunction<String> toIntFunction = string -> {
            String string2 = string;
            if (ae.b(string2).contains("*") || string2.contains("?")) {
                Pattern pattern = aqd.a(string, true);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    if (!pattern.matcher((CharSequence)list.get(i2)).matches()) continue;
                    return i2;
                }
            } else {
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    if (!string.equalsIgnoreCase((String)list.get(i3))) continue;
                    return i3;
                }
            }
            throw new IllegalArgumentException("Source does not contain device name: " + string);
        };
        int n3 = list2.size();
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = toIntFunction.applyAsInt(list2.get(i2));
        }
        return n2 -> nArray[n2];
    }

    private void fillTmpArrays(int n2) {
        for (int i2 = 0; i2 < this.numDevices; ++i2) {
            int n3 = this.indexMap.apply(i2);
            this.tmpPos[i2] = this.position[n3].a(n2);
            this.tmpPosCmd[i2] = this.positionCmd[n3].a(n2);
            this.tmpVel[i2] = this.velocity[n3].a(n2);
            this.tmpVelCmd[i2] = this.velocityCmd[n3].a(n2);
        }
    }

    private void resize() {
        this.centerOfMass = TDoubleArrayListRegistry.resizeMultiple(this.centerOfMass, 3, this.numEntries);
        this.xyzPosition = TDoubleArrayListRegistry.resizeMultiple(this.xyzPosition, 3, this.numEntries);
        this.xyzPositionCmd = TDoubleArrayListRegistry.resizeMultiple(this.xyzPositionCmd, 3, this.numEntries);
        this.xyzPositionErrorMagnitude = TDoubleArrayListRegistry.resizeSingle(this.xyzPositionErrorMagnitude, this.numEntries);
        this.xyzVelocity = TDoubleArrayListRegistry.resizeMultiple(this.xyzVelocity, 3, this.numEntries);
        this.xyzVelocityCmd = TDoubleArrayListRegistry.resizeMultiple(this.xyzVelocityCmd, 3, this.numEntries);
        this.xyzVelocityMagnitude = TDoubleArrayListRegistry.resizeSingle(this.xyzVelocityMagnitude, this.numEntries);
        this.xyzVelocityMagnitudeCmd = TDoubleArrayListRegistry.resizeSingle(this.xyzVelocityMagnitudeCmd, this.numEntries);
        this.imuVelocity = TDoubleArrayListRegistry.resizeMultiple(this.imuVelocity, this.numDevices, this.numEntries);
        this.tmpPos = new double[this.position.length];
        this.tmpPosCmd = new double[this.position.length];
        this.tmpVel = new double[this.position.length];
        this.tmpVelCmd = new double[this.position.length];
    }
}

