/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.custom;

import com.jfoenix.controls.JFXListCell;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.plugins.Zoomer;
import io.fair_acc.chartfx.utils.FXUtils;
import io.fair_acc.dataset.DataSet;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.AnchorPane;
import javax.inject.Inject;
import us.hebi.gui.lib.aup;
import us.hebi.gui.lib.ayn;
import us.hebi.gui.lib.azk;
import us.hebi.gui.lib.bau;
import us.hebi.gui.lib.bax;
import us.hebi.gui.lib.bba;
import us.hebi.gui.lib.bbb;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bdx;
import us.hebi.gui.lib.bed;
import us.hebi.gui.lib.bee;
import us.hebi.gui.lib.zm;
import us.hebi.gui.views.logviewer.custom.DeviceData;
import us.hebi.gui.views.logviewer.hebilog.HebiLogAnalysis$BasicLogInfo;
import us.hebi.gui.views.logviewer.hebilog.HebiLogAnalysis$FeedbackSynchronizer;

public class CustomLogviewerPresenter {
    @FXML
    private Parent root;
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    public ListView<DeviceData> deviceList;
    @FXML
    public ListView<String> chartList;
    @FXML
    private AnchorPane chartPane;
    public final List<bba> xmlCharts = new ArrayList<bba>();
    final HashMap<String, bau> valueFunctions = new HashMap();
    final List<List<bau>> xmlChartValues = new ArrayList<List<bau>>();
    @Inject
    String logPath;
    public DeviceData[] devices = new DeviceData[0];
    @Inject
    aup properties;
    @Inject
    bax customChartDirectory;
    @Inject
    ayn fileChooser;

    private void setupXmlChartSelector() throws IOException {
        this.customChartDirectory.forEachXml(bba2 -> {
            this.xmlCharts.add((bba)bba2);
            this.chartList.getItems().add((Object)bba2.getTitle());
            List list = bba2.getTraces().stream().map(bbb::getFunc).collect(Collectors.toList());
            this.xmlChartValues.add(list);
        });
    }

    private void loadDeviceData() throws IOException {
        try (DeviceData[] deviceDataArray = zm.a(new File(this.logPath));){
            HebiLogAnalysis$BasicLogInfo hebiLogAnalysis$BasicLogInfo = deviceDataArray.a(new HebiLogAnalysis$BasicLogInfo());
            HebiLogAnalysis$FeedbackSynchronizer hebiLogAnalysis$FeedbackSynchronizer = new HebiLogAnalysis$FeedbackSynchronizer();
            hebiLogAnalysis$FeedbackSynchronizer.addHandler(new bed(this, hebiLogAnalysis$BasicLogInfo, hebiLogAnalysis$FeedbackSynchronizer));
            deviceDataArray.a(hebiLogAnalysis$FeedbackSynchronizer);
        }
        deviceDataArray = this.devices;
        int n2 = this.devices.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            deviceDataArray[i2].convertToDataSets();
        }
    }

    @FXML
    void initialize() throws IOException {
        assert (this.deviceList != null) : "fx:id=\"deviceList\" was not injected: check your FXML file 'logviewer.fxml'.";
        assert (this.chartList != null) : "fx:id=\"chartList\" was not injected: check your FXML file 'logviewer.fxml'.";
        assert (this.chartPane != null) : "fx:id=\"chartPane\" was not injected: check your FXML file 'logviewer.fxml'.";
        this.setupXmlChartSelector();
        this.loadDeviceData();
        bdc.b(this::initializeOnFxThread);
    }

    private XYChart newChart() {
        XYChart xYChart = azk.a(0.0, 0.0, "");
        FXUtils.assertJavaFxThread();
        azk.a(xYChart, (BooleanProperty)this.properties.e);
        return xYChart;
    }

    private void setChart(Node node) {
        for (Node node2 : this.chartPane.getChildren()) {
            if (!(node2 instanceof XYChart)) continue;
            XYChart xYChart = (XYChart)node2;
            xYChart.getGridRenderer().getVerticalMajorGrid().visibleProperty().unbind();
            xYChart.getGridRenderer().getHorizontalMajorGrid().visibleProperty().unbind();
            xYChart.getDatasets().clear();
            xYChart.getRenderers().clear();
        }
        this.chartPane.getChildren().setAll((Object[])new Node[]{node});
        bdc.c(node);
    }

    public void saveVisibilityState(int n2, int n3) {
        if (n3 < 0 || n3 > this.devices.length || n2 < 0 || n2 > this.chartList.getItems().size()) {
            return;
        }
        List<DataSet> list = this.devices[n3].getDataSets(n2);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            DeviceData[] deviceDataArray = this.devices;
            int n4 = this.devices.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                DeviceData cfr_ignored_0 = deviceDataArray[i3];
            }
        }
    }

    private void initializeOnFxThread() {
        Optional<Object> optional;
        XYChart xYChart;
        block1: {
            bdx.e(this.root);
            xYChart = this.newChart();
            this.setChart((Node)xYChart);
            for (ChartPlugin chartPlugin : xYChart.getPlugins()) {
                if (!(chartPlugin instanceof Zoomer)) continue;
                optional = Optional.of((Zoomer)chartPlugin);
                break block1;
            }
            optional = Optional.empty();
        }
        Optional optional2 = optional;
        bee bee2 = new bee(this, xYChart, optional2);
        this.deviceList.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)bee2);
        this.chartList.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)bee2);
        this.deviceList.setCellFactory(CustomLogviewerPresenter::createStyledCell);
        this.chartList.setCellFactory(CustomLogviewerPresenter::createStyledCell);
    }

    private static <T> ListCell<T> createStyledCell(ListView<T> listView) {
        JFXListCell jFXListCell = new JFXListCell();
        jFXListCell.getStyleClass().add((Object)"lm-DeviceCell");
        return jFXListCell;
    }
}

