/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.imitation;

import atlantafx.base.controls.CustomTextField;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextArea;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import us.hebi.gui.lib.afj;
import us.hebi.gui.lib.ahp;
import us.hebi.gui.lib.apt;
import us.hebi.gui.lib.arq;
import us.hebi.gui.lib.arr;
import us.hebi.gui.lib.arz;
import us.hebi.gui.lib.aup;
import us.hebi.gui.lib.awg;
import us.hebi.gui.lib.bcq;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bdx;
import us.hebi.gui.lib.bea;
import us.hebi.gui.lib.beb;
import us.hebi.gui.lib.yo;
import us.hebi.gui.lib.yp;
import us.hebi.gui.lib.zc;
import us.hebi.gui.views.imitation.ImitationPresenter$Properties;
import us.hebi.gui.views.scope.components.ParseUtils;

public class ImitationPresenter {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private AnchorPane rootPane;
    @FXML
    private ToggleButton arm6Regular;
    @FXML
    private ToggleGroup selectedArm;
    @FXML
    private ToggleButton arm6DoubleShoulder;
    @FXML
    private ToggleButton arm7Regular;
    @FXML
    private ToggleGroup selectedArm1;
    @FXML
    private ToggleButton arm7DoubleShoulder;
    @FXML
    private ToggleButton baseOmni;
    @FXML
    private ToggleGroup selectedBase;
    @FXML
    private ToggleButton baseHexapod;
    @FXML
    private ToggleButton baseMecanum;
    @FXML
    private ToggleButton baseTready;
    @FXML
    private ToggleButton baseDiffDrive;
    @FXML
    private ToggleButton baseIgor;
    @FXML
    private ToggleGroup selectedPort;
    @FXML
    private ToggleGroup selectedInterface;
    @FXML
    private TextArea customNames;
    @FXML
    private CustomTextField familyName;
    @FXML
    private VBox interfaceToggleBox;
    @FXML
    private ToggleButton interfaceLocalhost;
    @FXML
    private ToggleButton interfaceAny;
    @FXML
    private ToggleButton portDefault;
    @FXML
    private ToggleButton portCustom;
    @FXML
    public Text localAddressPort;
    @FXML
    public Text localAddressIp;
    @FXML
    private Circle connectionLed;
    int uniqueId;
    private final List<yo> kitDeviceList = new ArrayList<yo>();
    private final List<yo> customDeviceList = new ArrayList<yo>();
    private Map<beb, List<yo>> kitMap;
    private yp deviceWrapper = new yp();
    private zc server;
    BooleanProperty hasErrors = new SimpleBooleanProperty(false);
    @Inject
    ImitationPresenter$Properties properties;
    @Inject
    aup scopeProperties;

    @FXML
    void initialize() throws IOException {
        bdc.b(this::initializeOnFxThread);
    }

    public void setNamesFromRobotConfig(afj afj2) {
        this.selectedArm.selectToggle(null);
        this.selectedBase.selectToggle(null);
        this.familyName.setText(String.valueOf(afj2.getFamilies()));
        this.customNames.setText(String.valueOf(afj2.getNames()));
    }

    private void initializeOnFxThread() {
        this.selectedArm.selectedToggleProperty().addListener(observable -> this.update());
        this.selectedBase.selectedToggleProperty().addListener(observable -> this.update());
        bcq.a((Labeled)this.portDefault, (ReadOnlyBooleanProperty)this.hasErrors);
        int n2 = this.properties.selectedArmIndex.get();
        if (n2 >= 0 && n2 < this.selectedArm.getToggles().size()) {
            this.selectedArm.selectToggle((Toggle)this.selectedArm.getToggles().get(n2));
        }
        this.selectedArm.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            int n2 = toggle2 == null ? -1 : this.selectedArm.getToggles().indexOf(toggle2);
            this.properties.selectedArmIndex.set(n2);
        });
        n2 = this.properties.selectedBaseIndex.get();
        if (n2 >= 0 && n2 < this.selectedBase.getToggles().size()) {
            this.selectedBase.selectToggle((Toggle)this.selectedBase.getToggles().get(n2));
        }
        this.selectedBase.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            int n2 = toggle2 == null ? -1 : this.selectedBase.getToggles().indexOf(toggle2);
            this.properties.selectedBaseIndex.set(n2);
        });
        this.customNames.textProperty().addListener((observableValue, string, string2) -> this.updateCustomNames());
        this.customNames.textProperty().bindBidirectional((Property)this.properties.customNames);
        this.customNames.setTooltip(bdx.a("delimiters\n*  newline\n*  comma\n*  semicolon\n\nignored\n*  quotes\n*  brackets\n*  parentheses\n*  whitespace"));
        this.familyName.textProperty().addListener((observableValue, string, string2) -> this.applyFamily());
        this.familyName.textProperty().bindBidirectional((Property)this.properties.familyName);
        this.localAddressPort.visibleProperty().bind((ObservableValue)this.portCustom.selectedProperty());
        this.localAddressPort.managedProperty().bind((ObservableValue)this.localAddressPort.visibleProperty());
        this.localAddressIp.visibleProperty().bind((ObservableValue)this.interfaceLocalhost.selectedProperty());
        this.localAddressIp.managedProperty().bind((ObservableValue)this.localAddressIp.visibleProperty());
        this.properties.useLocalhost.a(this.interfaceLocalhost.selectedProperty());
        this.properties.useCustomPort.a(this.portCustom.selectedProperty());
        awg.a("Note that Scope and the APIs may not check localhost by default. You may need to manually add 127.0.0.1 to the lookup addresses.", this.interfaceLocalhost);
        this.selectedPort.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            if (toggle2 == this.portCustom) {
                Window window = bdc.a((Node)this.portCustom);
                Optional<String> optional = arr.a("Custom port", "        Pick a custom port that the server should be run on. '0' opens a random\n        available port. Note that non-standard ports need to be manually added\n        to the lookup addresses in Scope and the APIs.\n", String.valueOf(this.properties.customPort.get()), window);
                if (optional.isEmpty()) {
                    this.portDefault.setSelected(true);
                    return;
                }
                Integer n2 = ParseUtils.tryParseInteger(optional.get());
                if (n2 == null || n2 < 0 || n2 > 65535) {
                    awg.a("Input is not a valid port: '" + optional.get() + "'", window);
                    this.portDefault.setSelected(true);
                    return;
                }
                this.properties.customPort.set(n2.intValue());
            }
            this.initServer();
        });
        this.selectedInterface.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            if (toggle2 == null) {
                this.selectedInterface.selectToggle((Toggle)this.interfaceAny);
                return;
            }
            this.initServer();
        });
        this.initServer();
        bdx.e((Parent)this.rootPane);
    }

    void initServer() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{};
        zc zc2 = this.server;
        apt.a(zc2);
        int cfr_ignored_0 = autoCloseableArray.length;
        arz.a((Node)this.connectionLed, arq.a);
        if (this.selectedPort.getSelectedToggle() == null) {
            this.server = null;
            return;
        }
        try {
            InetAddress inetAddress = this.interfaceLocalhost.isSelected() ? InetAddress.getLoopbackAddress() : null;
            int n2 = this.portDefault.isSelected() ? 16665 : this.properties.customPort.get();
            this.deviceWrapper.l(this.properties.uniqueSenderId.get());
            this.deviceWrapper.a(this.getFullDeviceList());
            this.server = new bea(this, inetAddress, n2, this.deviceWrapper);
            arz.a((Node)this.connectionLed, arq.b);
            this.hasErrors.set(false);
            this.localAddressPort.setText(String.valueOf(((ahp)this.server).b.getPort()));
            this.localAddressIp.setText(((ahp)this.server).b.getAddress().getHostAddress());
            zc zc3 = this.server;
            Thread thread = new Thread(zc3);
            thread.setDaemon(true);
            thread.start();
            return;
        }
        catch (IOException iOException) {
            arz.a((Node)this.connectionLed, arq.c);
            this.hasErrors.set(true);
            Platform.runLater(() -> awg.a(new RuntimeException("You may already be running another imitation process", iOException), this.rootPane.getScene().getWindow()));
            return;
        }
    }

    void applyFamily() {
        ImitationPresenter imitationPresenter = this;
        List<String> list = imitationPresenter.parseNames(imitationPresenter.familyName.getText());
        String string = list.isEmpty() ? "" : list.get(0);
        Iterator<yo> iterator = this.kitDeviceList.iterator();
        while (iterator.hasNext()) {
            iterator.next().a(string);
        }
        iterator = this.customDeviceList.iterator();
        while (iterator.hasNext()) {
            iterator.next().a(string);
        }
        if (list.size() > 1) {
            for (int i2 = 1; i2 < Math.min(this.customDeviceList.size(), list.size()); ++i2) {
                this.customDeviceList.get(i2).a(list.get(i2));
            }
        }
    }

    private List<String> parseNames(String string2) {
        return Arrays.stream(string2.split("[,;\n]")).map(string -> string.replaceAll("['\"{}\\[\\]()]", "")).map(String::strip).filter(string -> !string.isEmpty()).limit(16382 - this.kitDeviceList.size()).toList();
    }

    void updateCustomNames() {
        ImitationPresenter imitationPresenter = this;
        List<String> list = imitationPresenter.parseNames(imitationPresenter.customNames.getText());
        boolean bl2 = false;
        while (this.customDeviceList.size() < list.size()) {
            this.customDeviceList.add(yo.a());
            bl2 = true;
        }
        this.applyFamily();
        int n2 = 0;
        for (yo yo2 : this.customDeviceList) {
            if (n2 < list.size()) {
                yo2.b(list.get(n2));
                yo2.W = false;
            } else {
                yo2.W = true;
            }
            ++n2;
        }
        if (bl2 && this.server != null) {
            this.deviceWrapper.a(this.getFullDeviceList());
        }
    }

    @PostConstruct
    public void init() {
        this.kitMap = new HashMap<beb, List<yo>>();
        for (beb beb2 : beb.values()) {
            List<yo> list = beb2.aj.stream().map(string -> {
                yo yo2 = yo.a();
                yo.a().W = true;
                return yo2.b((String)string);
            }).toList();
            this.kitMap.put(beb2, list);
            this.kitDeviceList.addAll(list);
        }
    }

    private List<yo> getFullDeviceList() {
        if (this.customDeviceList.size() == 0) {
            return this.kitDeviceList;
        }
        ArrayList<yo> arrayList = new ArrayList<yo>(this.kitDeviceList.size() + this.customDeviceList.size());
        arrayList.addAll(this.kitDeviceList);
        arrayList.addAll(this.customDeviceList);
        return arrayList;
    }

    @PreDestroy
    public void stop() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{};
        zc zc2 = this.server;
        apt.a(zc2);
        int cfr_ignored_0 = autoCloseableArray.length;
    }

    void update() {
        ArrayList arrayList = new ArrayList();
        Toggle toggle = this.selectedArm.getSelectedToggle();
        if (toggle == this.arm6Regular) {
            arrayList.addAll(this.kitMap.get((Object)beb.a));
        } else if (toggle == this.arm6DoubleShoulder) {
            arrayList.addAll(this.kitMap.get((Object)beb.b));
        } else if (toggle == this.arm7Regular) {
            arrayList.addAll(this.kitMap.get((Object)beb.c));
        } else if (toggle == this.arm7DoubleShoulder) {
            arrayList.addAll(this.kitMap.get((Object)beb.d));
        }
        Toggle toggle2 = this.selectedBase.getSelectedToggle();
        if (toggle2 == this.baseOmni) {
            arrayList.addAll(this.kitMap.get((Object)beb.e));
        } else if (toggle2 == this.baseDiffDrive) {
            arrayList.addAll(this.kitMap.get((Object)beb.f));
        } else if (toggle2 == this.baseMecanum) {
            arrayList.addAll(this.kitMap.get((Object)beb.g));
        } else if (toggle2 == this.baseHexapod) {
            arrayList.addAll(this.kitMap.get((Object)beb.h));
        } else if (toggle2 == this.baseTready) {
            arrayList.addAll(this.kitMap.get((Object)beb.i));
        } else if (toggle2 == this.baseIgor) {
            arrayList.addAll(this.kitMap.get((Object)beb.j));
        }
        Iterator<yo> iterator = this.kitDeviceList.iterator();
        while (iterator.hasNext()) {
            iterator.next().W = true;
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            iterator.next().W = false;
        }
        this.applyFamily();
    }
}

