/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.lib;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import picocli.CommandLine;
import us.hebi.gui.lib.aft;
import us.hebi.gui.lib.ahc;
import us.hebi.gui.lib.ahg;
import us.hebi.gui.lib.aif;
import us.hebi.gui.lib.ajo;
import us.hebi.gui.lib.ajr;
import us.hebi.gui.lib.aln;
import us.hebi.gui.lib.apt;
import us.hebi.gui.lib.awx;
import us.hebi.gui.lib.axv;
import us.hebi.gui.lib.axw;
import us.hebi.gui.lib.axy;
import us.hebi.gui.lib.ayf;
import us.hebi.gui.lib.ayg;
import us.hebi.gui.lib.ayk;
import us.hebi.gui.lib.bbn;
import us.hebi.gui.lib.bbu;
import us.hebi.gui.lib.bbw;
import us.hebi.gui.lib.bbz;
import us.hebi.gui.lib.bca;
import us.hebi.gui.lib.bdk;
import us.hebi.gui.lib.but;
import us.hebi.gui.lib.bux;
import us.hebi.gui.lib.bvy;
import us.hebi.gui.lib.cec;
import us.hebi.gui.lib.zm;
import us.hebi.gui.lib.zo;

public final class bbt
extends bbn {
    @CommandLine.Parameters(index="0", paramLabel="mode", description={"Chooses the operating mode [calibration, errorlog, getinfo, getfbk, readlog, program]"})
    protected bbw mode;
    @CommandLine.Option(names={"--frequency"}, description={"Sets the frequency [Hz] for modes that poll device data."})
    private double frequency = 10.0;
    @CommandLine.Option(names={"--imu-accel-offset"}, description={"Sets the xyz accelerometer offset after calibration. Expects 3 numbers separated by commas."}, split=",")
    private float[] imuAccelOffsets;
    @CommandLine.Option(names={"--imu-rotation"}, description={"Sets the 3x3 rotation matrix of the IMU after calibration. Expects 9 numbers  separated by commas."}, split=",")
    private float[] imuRotation;
    @CommandLine.Option(names={"--md-motor-adc"}, description={"Runs a calibration procedure and sets motor driver offsets"})
    private boolean mdMotorAdc;
    @CommandLine.Option(names={"--md-encoder-offset"}, description={"Runs a calibration procedure and sets encoder offsets"})
    private boolean mdEncoderOffset;
    @CommandLine.Option(names={"--md-table-index"}, description={"Selects the target calibration table index."})
    private int targetTableIndex = 0;
    @CommandLine.Option(names={"--md-read-encoder-offset-table"}, description={"Reads the current encoder offset table"})
    private boolean mdReadEncoderOffsetTable;
    @CommandLine.Option(names={"--hebilog"}, description={"Loads a .hebilog file and prints the output"})
    private File hebilogFile;
    @CommandLine.Option(names={"--application"}, description={"Application firmware file"})
    private File applicationFile;

    @Override
    protected final void run() throws Exception {
        if (this.frequency < 0.0) {
            throw bca.a("frequency");
        }
        if (this.mode == bbw.errorlog || this.mode == bbw.getinfo || this.mode == bbw.getfbk) {
            aft aft2;
            bbt bbt2 = this;
            ahg ahg2 = bbt2.b();
            System.out.println("Polling of " + String.valueOf(ahg2) + " at " + bbt2.frequency + " Hz");
            bbz bbz2 = new bbz(ahg2);
            bbz2.a(bbt2.frequency);
            bvy bvy3 = bbz2.h.c();
            switch (bbt2.mode.ordinal()) {
                case 1: {
                    bvy3.j(true);
                    break;
                }
                case 2: {
                    bvy3.l(true).k(true).a(bux.b).c(true).b(true).a(true).d(true).g(true).e(true).f(true).h(true);
                    break;
                }
                case 3: {
                    bvy3.b(true).a(true).d(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported poll mode: " + String.valueOf((Object)bbt2.mode));
                }
            }
            bbz2.a = aft2 = (bvy2, l2, bl2) -> {
                switch (this.mode.ordinal()) {
                    case 1: {
                        but but2 = bvy2.a;
                        if (but2.hz()) {
                            System.out.print("[error] ");
                            System.out.println(but2.T.a(cec.a));
                        }
                        if (but2.hy()) {
                            System.out.print("[flags] ");
                            System.out.println(but2.S.a(cec.a));
                        }
                        return;
                    }
                }
                System.out.println(bvy2);
            };
            bbz2.a();
            Runtime.getRuntime().addShutdownHook(new Thread(bbz2::bC));
            while (true) {
                apt.b(100L, TimeUnit.MILLISECONDS);
            }
        }
        if (this.mode == bbw.calibration) {
            if (this.mdMotorAdc) {
                bbt bbt3 = this;
                bbt3.b();
                ahg ahg3 = bbt3.b();
                System.out.println("Running ADC calibration on " + String.valueOf(ahg3));
                new bbz(ahg3);
                float cfr_ignored_0 = 4.0f / 200.0f;
                axw axw2 = new axv(ahg3, aif.b, 200, 38.0f, 4.0f).a();
                System.out.println("Computed fit coefficients for ADC offsets");
                System.out.println("A:   " + Arrays.toString(axw2.a.h()));
                System.out.println("B:   " + Arrays.toString(axw2.b.h()));
                System.out.println("C:   " + Arrays.toString(axw2.c.h()));
                System.out.println("Bus: " + Arrays.toString(axw2.d.h()));
                return;
            }
            if (this.mdEncoderOffset) {
                ajr ajr2;
                bbt bbt4 = this;
                bbt4.b();
                bbt bbt5 = bbt4;
                ahg ahg4 = bbt4.b();
                System.out.println("Running encoder offset calibration on " + String.valueOf(ahg4));
                System.out.println("Make sure the following are set:\n   Motor Driver: [Output Encoder] is set to your configured encoder (e.g. A1)\n   Motor Driver: [Motor Encoder] is set to POSITION_COMMAND\n   Motor Driver: [Controller Mode] is set to FOC\n   Gains:        [Control Strategy] is set to DIRECT_FOC\nPress Enter to continue...\n");
                if (bbt5.verbose) {
                    System.out.println("Requesting current motor encoder configuration");
                }
                try {
                    aln aln2 = ahc.a(ahg4);
                    ajr2 = aln2.a.a().a();
                }
                catch (IOException iOException) {
                    throw bca.a("Failed to get info message from device", new Object[0]);
                }
                if (bbt5.verbose) {
                    System.out.println("Using motor encoder " + String.valueOf((Object)ajr2));
                }
                ayk ayk2 = new ayf(ahg4, ajr2, 15.0, 2.0, 11, ayg.Calibrate).a();
                System.out.println("Fit Coeffs: " + Arrays.toString(ayk2.e.h()));
                return;
            }
            if (this.mdReadEncoderOffsetTable) {
                ajr ajr3;
                bbt bbt6 = this;
                ahg ahg5 = bbt6.b();
                bbt bbt7 = bbt6;
                if (bbt6.verbose) {
                    System.out.println("Requesting current motor encoder offsets");
                }
                System.err.println("TODO: currently hardcoded A1 w/ 256 buckets. We need to add more parameters to define the target.");
                axy axy2 = new axy(ajo.d);
                new axy(ajo.d).l = ajr3 = ajr.c;
                axy2.a(ahg5, bvy2 -> {
                    if (this.verbose) {
                        System.out.println(bvy2);
                    }
                }, bvy2 -> {
                    if (this.verbose) {
                        System.out.println(bvy2);
                    }
                });
                System.out.println(Arrays.toString(axy2.z));
                return;
            }
        }
        if (this.mode == bbw.readlog) {
            bbt bbt8 = this;
            if (!bbt8.c(bbt8.hebilogFile)) {
                throw bca.a("Invalid '--hebilog' parameter : " + String.valueOf(bbt8.hebilogFile), new Object[0]);
            }
            try (zo zo2 = zm.a(bbt8.hebilogFile);){
                zo2.a(new bbu(bbt8));
                return;
            }
            catch (IOException iOException) {
                throw bca.a("Failed to read log file. Reason: %s", iOException.getMessage());
            }
        }
        if (this.mode == bbw.program) {
            bbt bbt9 = this;
            if (!bbt9.c(bbt9.applicationFile)) {
                throw bca.a("Invalid '--application' parameter : " + String.valueOf(this.applicationFile), new Object[0]);
            }
            if (!bdk.a(this.b(), System.out::println)) {
                throw new IllegalStateException("Failed to get into bootloader");
            }
            awx.a(this.b(), this.applicationFile).U();
            System.out.println("Booting into application.");
            bdk.b(this.b());
        }
        super.run();
    }

    @Override
    protected final void g(List<BiConsumer<bvy, Integer>> list) {
        if (this.imuAccelOffsets != null) {
            bbt.c(this.imuAccelOffsets.length == 3, "Accelerometer offset expects 3 values: [x,y,z]. Got %d.", this.imuAccelOffsets.length);
            list.add((bvy2, n2) -> bvy2.a().e().i(true).b(this.imuAccelOffsets));
        }
        if (this.imuRotation != null) {
            bbt.c(this.imuRotation.length == 9, "IMU rotation expects 9 values separated by commas. Got %d. ", this.imuRotation.length);
            list.add((bvy2, n2) -> bvy2.a().e().h(true).a(this.imuRotation));
        }
    }

    @Override
    protected final void w(int n2) {
        if (n2 > 1) {
            bbt.c(this.imuAccelOffsets == null, "--imu-accel-offset only supports single devices", new Object[0]);
            bbt.c(this.imuRotation == null, "--imu-rotation only supports single devices", new Object[0]);
        }
    }

    private ahg b() throws bca {
        List<ahg> list = this.d();
        if (list.size() > 1) {
            throw bca.b();
        }
        return list.get(0);
    }
}

