/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.tableview2;

import impl.org.controlsfx.tableview2.SortUtils;
import impl.org.controlsfx.tableview2.TableView2Skin;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Skin;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;

public class TableView2<S>
extends TableView<S> {
    private static final double DEFAULT_ROW_HEADER_WIDTH = 30.0;
    private final ObservableList<Integer> fixedRows = FXCollections.observableArrayList();
    private final ObservableList<TableColumn> fixedColumns = FXCollections.observableArrayList();
    private final BooleanProperty rowFixingEnabled = new SimpleBooleanProperty(true);
    private final BooleanProperty columnFixingEnabled = new SimpleBooleanProperty(true);
    private final BooleanProperty rowHeaderVisible = new SimpleBooleanProperty((Object)true, "showRowHeader", false);
    private BitSet rowFix;
    private final DoubleProperty rowHeaderWidth = new SimpleDoubleProperty(30.0);
    private String stylesheet;
    private final ObjectProperty<TableColumn<S, ?>> rowHeader = new SimpleObjectProperty((Object)this, "rowHeader");
    private ObjectProperty<BiFunction<Integer, S, ContextMenu>> rowHeaderContextMenuFactory;
    private final BooleanProperty southHeaderBlended = new SimpleBooleanProperty((Object)this, "southHeaderBlended", true);
    private final ListChangeListener<Integer> fixedRowsListener = change -> {
        while (change.next()) {
            if (change.wasAdded()) {
                List list = change.getAddedSubList();
                if (!this.areRowsFixable(list)) {
                    throw new IllegalArgumentException(this.computeReason(list));
                }
                FXCollections.sort(this.fixedRows);
            }
            if (!change.wasRemoved()) continue;
        }
    };
    private final ListChangeListener<TableColumn> fixedColumnsListener = new ListChangeListener<TableColumn>(){

        public void onChanged(ListChangeListener.Change<? extends TableColumn> change) {
            while (change.next()) {
                List list;
                if (!change.wasAdded() || TableView2.this.areTableViewColumnsFixable(list = change.getAddedSubList())) continue;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (TableColumn tableColumn : list) {
                    if (tableColumn == null) continue;
                    arrayList.add(TableView2.this.getColumns().indexOf((Object)tableColumn));
                }
                throw new IllegalArgumentException(this.computeReason(arrayList));
            }
        }

        private String computeReason(List<Integer> list) {
            Object object = "\n This column cannot be fixed.";
            for (Integer n2 : list) {
                if (TableView2.this.isColumnFixable(n2)) continue;
                int n3 = 1;
                int n4 = n2 + n3 - 1;
                for (int i2 = n2 + 1; i2 < n4; ++i2) {
                    if (list.contains(i2)) continue;
                    object = (String)object + "One cell on the column " + n2 + " has a column span of " + n3 + ". But the column " + i2 + " contained within that span is not fixed.\n";
                }
            }
            return object;
        }
    };

    public TableView2() {
        this(FXCollections.observableArrayList());
    }

    public TableView2(ObservableList<S> observableList) {
        super(observableList);
        this.getStyleClass().add((Object)"table-view2");
        this.fixedRows.addListener(this.fixedRowsListener);
        this.fixedColumns.addListener(this.fixedColumnsListener);
        this.skinProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable2) {
                ((TableView2Skin)TableView2.this.getSkin()).sizeProperty().addListener(observable -> TableView2.this.initRowFix());
                TableView2.this.skinProperty().removeListener((InvalidationListener)this);
            }
        });
        this.getItems().addListener(observable -> this.initRowFix());
        this.initRowFix();
    }

    public int getRowSpan(TablePosition<?, ?> tablePosition, int n2) {
        return 1;
    }

    public int getColumnSpan(TablePosition<?, ?> tablePosition) {
        return 1;
    }

    public final ObservableList<Integer> getFixedRows() {
        return this.fixedRows;
    }

    public final boolean isRowFixable(int n2) {
        return n2 >= 0 && n2 < this.rowFix.size() && this.isRowFixingEnabled() ? this.rowFix.get(n2) : false;
    }

    public final boolean areRowsFixable(List<? extends Integer> list) {
        if (list == null || list.isEmpty() || !this.isRowFixingEnabled() || this.getItems() == null) {
            return false;
        }
        for (Integer n2 : list) {
            if (n2 == null || n2 < 0 || n2 >= this.getItems().size()) {
                return false;
            }
            if (this.isRowFixable(n2)) continue;
            int n3 = 1;
            for (TableColumn tableColumn : this.getColumns()) {
                if (!list.contains(n2)) {
                    return false;
                }
                if (this.getRowSpan(new TablePosition((TableView)this, n2.intValue(), tableColumn), n2) <= n3) continue;
                n3 = 1;
            }
            int n4 = n2 + n3 - 1;
            for (int i2 = n2 + 1; i2 <= n4; ++i2) {
                if (list.contains(i2)) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean isRowFixingEnabled() {
        return this.rowFixingEnabled.get();
    }

    public final void setRowFixingEnabled(boolean bl2) {
        this.rowFixingEnabled.set(bl2);
    }

    public final ReadOnlyBooleanProperty rowFixingEnabledProperty() {
        return this.rowFixingEnabled;
    }

    public final ObservableList<TableColumn> getFixedColumns() {
        return this.fixedColumns;
    }

    public final boolean isColumnFixable(int n2) {
        if (n2 < 0 || n2 >= this.getColumns().size() || !this.isColumnFixingEnabled()) {
            return false;
        }
        TableColumn tableColumn = (TableColumn)this.getColumns().get(n2);
        return tableColumn.getParentColumn() == null;
    }

    private boolean areTableViewColumnsFixable(List<? extends TableColumn> list) {
        return this.areColumnsFixable(list.stream().filter(Objects::nonNull).map(arg_0 -> this.getColumns().indexOf(arg_0)).collect(Collectors.toList()));
    }

    private boolean areColumnsFixable(List<? extends Integer> list) {
        if (list == null || list.isEmpty() || !this.isRowFixingEnabled()) {
            return false;
        }
        for (Integer n2 : list) {
            if (n2 == null || n2 < 0 || n2 >= this.getColumns().size()) {
                return false;
            }
            if (this.isColumnFixable(n2)) continue;
            int n3 = 1;
            int n4 = n2 + n3 - 1;
            for (int i2 = n2 + 1; i2 <= n4; ++i2) {
                if (list.contains(i2)) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean isColumnFixingEnabled() {
        return this.getItems() != null && this.columnFixingEnabled.get();
    }

    public final void setColumnFixingEnabled(boolean bl2) {
        this.columnFixingEnabled.set(bl2);
    }

    public final ReadOnlyBooleanProperty columnFixingEnabledProperty() {
        return this.columnFixingEnabled;
    }

    public final void setRowHeaderVisible(boolean bl2) {
        this.rowHeaderVisible.setValue(Boolean.valueOf(bl2));
    }

    public final boolean isRowHeaderVisible() {
        return this.rowHeaderVisible.get();
    }

    public final BooleanProperty rowHeaderVisibleProperty() {
        return this.rowHeaderVisible;
    }

    public final DoubleProperty rowHeaderWidthProperty() {
        return this.rowHeaderWidth;
    }

    public final void setRowHeaderWidth(double d2) {
        this.rowHeaderWidth.setValue((Number)d2);
    }

    public final double getRowHeaderWidth() {
        return this.rowHeaderWidth.get();
    }

    public final void setRowHeader(TableColumn<S, ?> tableColumn) {
        this.rowHeader.set(tableColumn);
    }

    public final TableColumn<S, ?> getRowHeader() {
        return (TableColumn)this.rowHeader.get();
    }

    public final ObjectProperty<TableColumn<S, ?>> rowHeaderProperty() {
        return this.rowHeader;
    }

    public final void setRowHeaderContextMenuFactory(BiFunction<Integer, S, ContextMenu> biFunction) {
        this.rowHeaderContextMenuFactoryProperty().set(biFunction);
    }

    public final BiFunction<Integer, S, ContextMenu> getRowHeaderContextMenuFactory() {
        return this.rowHeaderContextMenuFactory == null ? null : (BiFunction)this.rowHeaderContextMenuFactory.get();
    }

    public final ObjectProperty<BiFunction<Integer, S, ContextMenu>> rowHeaderContextMenuFactoryProperty() {
        if (this.rowHeaderContextMenuFactory == null) {
            this.rowHeaderContextMenuFactory = new SimpleObjectProperty((Object)this, "rowHeaderContextMenu");
        }
        return this.rowHeaderContextMenuFactory;
    }

    public final void setSouthHeaderBlended(boolean bl2) {
        this.southHeaderBlended.set(bl2);
    }

    public final boolean isSouthHeaderBlended() {
        return this.southHeaderBlended.get();
    }

    public final BooleanProperty southHeaderBlendedProperty() {
        return this.southHeaderBlended;
    }

    public SpanType getSpanType(int n2, int n3) {
        if (this.getSkin() == null) {
            return SpanType.NORMAL_CELL;
        }
        if (n2 < 0 || n3 < 0 || this.getItems() != null && n2 >= this.getItems().size() || n3 >= this.getVisibleLeafColumns().size()) {
            return SpanType.NORMAL_CELL;
        }
        TablePosition tablePosition = new TablePosition((TableView)this, n2, (TableColumn)this.getVisibleLeafColumns().get(n3));
        if (tablePosition.getColumn() < 0) {
            return SpanType.COLUMN_SPAN_INVISIBLE;
        }
        int n4 = n3;
        boolean bl2 = true;
        if (n4 == n3 && bl2) {
            return SpanType.NORMAL_CELL;
        }
        int n5 = this.getColumnSpan(tablePosition);
        boolean bl3 = this.getSkin() == null ? true : ((TableView2Skin)this.getSkin()).containsRow(n2 - 1);
        boolean bl4 = false;
        if (!bl3 || n5 <= 1 || n4 == n3 || bl2 > true) {
            // empty if block
        }
        if (bl2 > true && n4 == n3) {
            return SpanType.ROW_VISIBLE;
        }
        if (n5 > 1) {
            if (n4 == n3) {
                return SpanType.NORMAL_CELL;
            }
            return SpanType.COLUMN_SPAN_INVISIBLE;
        }
        return SpanType.NORMAL_CELL;
    }

    public void sort() {
        SortUtils.SortStartedEvent<TableView2> sortStartedEvent = new SortUtils.SortStartedEvent<TableView2>(this, (EventTarget)this);
        this.fireEvent((Event)sortStartedEvent);
        super.sort();
        SortUtils.SortEndedEvent<TableView2> sortEndedEvent = new SortUtils.SortEndedEvent<TableView2>(this, (EventTarget)this);
        this.fireEvent((Event)sortEndedEvent);
    }

    private void initRowFix() {
        this.rowFix = new BitSet(this.getItems() != null ? this.getItems().size() : 0);
        for (int i2 = 0; i2 < this.rowFix.size(); ++i2) {
            this.rowFix.set(i2);
        }
    }

    private String computeReason(List<? extends Integer> list) {
        Object object = "\n A row cannot be fixed. \n";
        for (Integer n2 : list) {
            if (this.isRowFixable(n2)) continue;
            int n3 = 1;
            int n4 = n2 + n3 - 1;
            for (int i2 = n2 + 1; i2 < n4; ++i2) {
                if (list.contains(i2)) continue;
                object = (String)object + "One cell on the row " + n2 + " has a row span of " + n3 + ". But the row " + i2 + " contained within that span is not fixed.\n";
            }
        }
        return object;
    }

    protected Skin<?> createDefaultSkin() {
        return new TableView2Skin(this);
    }

    public String getUserAgentStylesheet() {
        if (this.stylesheet == null) {
            this.stylesheet = TableView2.class.getResource("tableview2.css").toExternalForm();
        }
        return this.stylesheet;
    }

    public static enum SpanType {
        NORMAL_CELL,
        COLUMN_SPAN_INVISIBLE,
        ROW_SPAN_INVISIBLE,
        ROW_VISIBLE,
        BOTH_INVISIBLE;

    }
}

