/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.action;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.i18n.SimpleLocalizedStringProperty;
import java.util.function.Consumer;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.KeyCombination;
import org.controlsfx.control.action.ActionCheck;

public class Action
implements EventHandler<ActionEvent> {
    private boolean locked = false;
    private Consumer<ActionEvent> eventHandler;
    private StringProperty style;
    private final ObservableList<String> styleClass = FXCollections.observableArrayList();
    private final BooleanProperty selectedProperty = new SimpleBooleanProperty(this, "selected"){

        public void set(boolean bl2) {
            if (Action.this.locked) {
                throw new UnsupportedOperationException("The action is immutable, property change support is disabled.");
            }
            super.set(bl2);
        }
    };
    private final StringProperty textProperty = new SimpleLocalizedStringProperty(this, "text"){

        public void set(String string) {
            if (Action.this.locked) {
                throw new RuntimeException("The action is immutable, property change support is disabled.");
            }
            super.set(string);
        }
    };
    private final BooleanProperty disabledProperty = new SimpleBooleanProperty(this, "disabled"){

        public void set(boolean bl2) {
            if (Action.this.locked) {
                throw new RuntimeException("The action is immutable, property change support is disabled.");
            }
            super.set(bl2);
        }
    };
    private final StringProperty longTextProperty = new SimpleLocalizedStringProperty(this, "longText"){

        public void set(String string) {
            if (Action.this.locked) {
                throw new RuntimeException("The action is immutable, property change support is disabled.");
            }
            super.set(string);
        }
    };
    private final ObjectProperty<Node> graphicProperty = new SimpleObjectProperty<Node>((Object)this, "graphic"){

        public void set(Node node) {
            if (Action.this.locked) {
                throw new RuntimeException("The action is immutable, property change support is disabled.");
            }
            super.set((Object)node);
        }
    };
    private final ObjectProperty<KeyCombination> acceleratorProperty = new SimpleObjectProperty<KeyCombination>((Object)this, "accelerator"){

        public void set(KeyCombination keyCombination) {
            if (Action.this.locked) {
                throw new RuntimeException("The action is immutable, property change support is disabled.");
            }
            super.set((Object)keyCombination);
        }
    };
    private ObservableMap<Object, Object> props;

    public Action(@NamedArg(value="text") String string) {
        this(string, null);
    }

    public Action(Consumer<ActionEvent> consumer) {
        this("", consumer);
    }

    public Action(@NamedArg(value="text") String string, Consumer<ActionEvent> consumer) {
        this.setText(string);
        this.setEventHandler(consumer);
        this.getStyleClass().add((Object)"action");
    }

    protected void lock() {
        this.locked = true;
    }

    public final void setStyle(String string) {
        this.styleProperty().set((Object)string);
    }

    public final String getStyle() {
        return this.style == null ? "" : (String)this.style.get();
    }

    public final StringProperty styleProperty() {
        if (this.style == null) {
            this.style = new SimpleStringProperty(this, "style"){

                public void set(String string) {
                    if (Action.this.locked) {
                        throw new UnsupportedOperationException("The action is immutable, property change support is disabled.");
                    }
                    super.set(string);
                }
            };
        }
        return this.style;
    }

    public ObservableList<String> getStyleClass() {
        return this.styleClass;
    }

    public final BooleanProperty selectedProperty() {
        return this.selectedProperty;
    }

    public final boolean isSelected() {
        return this.selectedProperty.get();
    }

    public final void setSelected(boolean bl2) {
        if (this.isSelected() != bl2) {
            this.selectedProperty.set(bl2);
            if (this.getClass().isAnnotationPresent(ActionCheck.class)) {
                this.eventHandler.accept(null);
            }
        }
    }

    public final StringProperty textProperty() {
        return this.textProperty;
    }

    public final String getText() {
        return (String)this.textProperty.get();
    }

    public final void setText(String string) {
        this.textProperty.set((Object)string);
    }

    public final BooleanProperty disabledProperty() {
        return this.disabledProperty;
    }

    public final boolean isDisabled() {
        return this.disabledProperty.get();
    }

    public final void setDisabled(boolean bl2) {
        this.disabledProperty.set(bl2);
    }

    public final StringProperty longTextProperty() {
        return this.longTextProperty;
    }

    public final String getLongText() {
        return Localization.localize((String)this.longTextProperty.get());
    }

    public final void setLongText(String string) {
        this.longTextProperty.set((Object)string);
    }

    public final ObjectProperty<Node> graphicProperty() {
        return this.graphicProperty;
    }

    public final Node getGraphic() {
        return (Node)this.graphicProperty.get();
    }

    public final void setGraphic(Node node) {
        this.graphicProperty.set((Object)node);
    }

    public final ObjectProperty<KeyCombination> acceleratorProperty() {
        return this.acceleratorProperty;
    }

    public final KeyCombination getAccelerator() {
        return (KeyCombination)this.acceleratorProperty.get();
    }

    public final void setAccelerator(KeyCombination keyCombination) {
        this.acceleratorProperty.set((Object)keyCombination);
    }

    public final synchronized ObservableMap<Object, Object> getProperties() {
        if (this.props == null) {
            this.props = FXCollections.observableHashMap();
        }
        return this.props;
    }

    protected Consumer<ActionEvent> getEventHandler() {
        return this.eventHandler;
    }

    protected void setEventHandler(Consumer<ActionEvent> consumer) {
        this.eventHandler = consumer;
    }

    public final void handle(ActionEvent actionEvent) {
        if (this.eventHandler != null && !this.isDisabled()) {
            this.eventHandler.accept(actionEvent);
        }
    }
}

