/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.generation;

import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.agrona.generation.JavaClassObject;

public class ClassFileManager<M extends JavaFileManager>
extends ForwardingJavaFileManager<M> {
    private final Map<String, JavaClassObject> classObjectByNameMap = new HashMap<String, JavaClassObject>();

    public ClassFileManager(M m2) {
        super(m2);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return new SecureClassLoader(){

            @Override
            protected Class<?> findClass(String string) {
                byte[] byArray = ClassFileManager.this.classObjectByNameMap.get(string).getBytes();
                return super.defineClass(string, byArray, 0, byArray.length);
            }
        };
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) {
        JavaClassObject javaClassObject = new JavaClassObject(string, kind);
        this.classObjectByNameMap.put(string, javaClassObject);
        return javaClassObject;
    }
}

