/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersManager;

public class AtomicCounter
implements AutoCloseable {
    private boolean isClosed = false;
    private final int id;
    private final long addressOffset;
    private final byte[] byteArray;
    private CountersManager countersManager;
    private final ByteBuffer byteBuffer;

    public AtomicCounter(AtomicBuffer atomicBuffer, int n2) {
        this(atomicBuffer, n2, null);
    }

    public AtomicCounter(AtomicBuffer atomicBuffer, int n2, CountersManager countersManager) {
        this.id = n2;
        this.countersManager = countersManager;
        this.byteBuffer = atomicBuffer.byteBuffer();
        this.byteArray = atomicBuffer.byteArray();
        int n3 = CountersManager.counterOffset(n2);
        atomicBuffer.boundsCheck(n3, 8);
        this.addressOffset = atomicBuffer.addressOffset() + (long)n3;
    }

    public int id() {
        return this.id;
    }

    public void disconnectCountersManager() {
        this.countersManager = null;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (null != this.countersManager) {
                this.countersManager.free(this.id);
            }
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String label() {
        return null != this.countersManager ? this.countersManager.getCounterLabel(this.id) : null;
    }

    public void updateLabel(String string) {
        if (null == this.countersManager) {
            throw new IllegalStateException("Not constructed with CountersManager");
        }
        this.countersManager.setCounterLabel(this.id, string);
    }

    public AtomicCounter appendToLabel(String string) {
        if (null == this.countersManager) {
            throw new IllegalStateException("Not constructed with CountersManager");
        }
        this.countersManager.appendToLabel(this.id, string);
        return this;
    }

    public void updateKey(Consumer<MutableDirectBuffer> consumer) {
        if (null == this.countersManager) {
            throw new IllegalStateException("Not constructed with CountersManager");
        }
        this.countersManager.setCounterKey(this.id, consumer);
    }

    public void updateKey(DirectBuffer directBuffer, int n2, int n3) {
        if (null == this.countersManager) {
            throw new IllegalStateException("Not constructed with CountersManager");
        }
        this.countersManager.setCounterKey(this.id, directBuffer, n2, n3);
    }

    public long increment() {
        return UnsafeAccess.UNSAFE.getAndAddLong(this.byteArray, this.addressOffset, 1L);
    }

    public long incrementOrdered() {
        byte[] byArray = this.byteArray;
        long l2 = this.addressOffset;
        long l3 = UnsafeAccess.UNSAFE.getLong(byArray, l2);
        UnsafeAccess.UNSAFE.putOrderedLong(byArray, l2, l3 + 1L);
        return l3;
    }

    public long decrement() {
        return UnsafeAccess.UNSAFE.getAndAddLong(this.byteArray, this.addressOffset, -1L);
    }

    public long decrementOrdered() {
        byte[] byArray = this.byteArray;
        long l2 = this.addressOffset;
        long l3 = UnsafeAccess.UNSAFE.getLong(byArray, l2);
        UnsafeAccess.UNSAFE.putOrderedLong(byArray, l2, l3 - 1L);
        return l3;
    }

    public void set(long l2) {
        UnsafeAccess.UNSAFE.putLongVolatile(this.byteArray, this.addressOffset, l2);
    }

    public void setOrdered(long l2) {
        UnsafeAccess.UNSAFE.putOrderedLong(this.byteArray, this.addressOffset, l2);
    }

    public void setWeak(long l2) {
        UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset, l2);
    }

    public long getAndAdd(long l2) {
        return UnsafeAccess.UNSAFE.getAndAddLong(this.byteArray, this.addressOffset, l2);
    }

    public long getAndAddOrdered(long l2) {
        byte[] byArray = this.byteArray;
        long l3 = this.addressOffset;
        long l4 = UnsafeAccess.UNSAFE.getLong(byArray, l3);
        UnsafeAccess.UNSAFE.putOrderedLong(byArray, l3, l4 + l2);
        return l4;
    }

    public long getAndSet(long l2) {
        return UnsafeAccess.UNSAFE.getAndSetLong(this.byteArray, this.addressOffset, l2);
    }

    public boolean compareAndSet(long l2, long l3) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this.byteArray, this.addressOffset, l2, l3);
    }

    public long get() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this.byteArray, this.addressOffset);
    }

    public long getWeak() {
        return UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset);
    }

    public boolean proposeMax(long l2) {
        boolean bl2 = false;
        byte[] byArray = this.byteArray;
        long l3 = this.addressOffset;
        if (UnsafeAccess.UNSAFE.getLong(byArray, l3) < l2) {
            UnsafeAccess.UNSAFE.putLong(byArray, l3, l2);
            bl2 = true;
        }
        return bl2;
    }

    public boolean proposeMaxOrdered(long l2) {
        boolean bl2 = false;
        byte[] byArray = this.byteArray;
        long l3 = this.addressOffset;
        if (UnsafeAccess.UNSAFE.getLong(byArray, l3) < l2) {
            UnsafeAccess.UNSAFE.putOrderedLong(byArray, l3, l2);
            bl2 = true;
        }
        return bl2;
    }

    public String toString() {
        return "AtomicCounter{isClosed=" + this.isClosed() + ", id=" + this.id + ", value=" + (this.isClosed() ? -1L : this.get()) + ", countersManager=" + this.countersManager + "}";
    }
}

