/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.broadcast;

import java.nio.ByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.broadcast.BroadcastReceiver;

public class CopyBroadcastReceiver {
    public static final int SCRATCH_BUFFER_LENGTH = 4096;
    private final BroadcastReceiver receiver;
    private final MutableDirectBuffer scratchBuffer;

    public CopyBroadcastReceiver(BroadcastReceiver broadcastReceiver, MutableDirectBuffer mutableDirectBuffer) {
        this.receiver = broadcastReceiver;
        this.scratchBuffer = mutableDirectBuffer;
    }

    public BroadcastReceiver broadcastReceiver() {
        return this.receiver;
    }

    public CopyBroadcastReceiver(BroadcastReceiver broadcastReceiver, int n2) {
        this.receiver = broadcastReceiver;
        this.scratchBuffer = new UnsafeBuffer(ByteBuffer.allocateDirect(n2));
    }

    public CopyBroadcastReceiver(BroadcastReceiver broadcastReceiver) {
        this(broadcastReceiver, 4096);
    }

    public int receive(MessageHandler messageHandler) {
        int n2 = 0;
        BroadcastReceiver broadcastReceiver = this.receiver;
        long l2 = broadcastReceiver.lappedCount();
        if (broadcastReceiver.receiveNext()) {
            int n3;
            if (l2 != broadcastReceiver.lappedCount()) {
                throw new IllegalStateException("unable to keep up with broadcast");
            }
            int n4 = broadcastReceiver.length();
            if (n4 > (n3 = this.scratchBuffer.capacity()) && !this.scratchBuffer.isExpandable()) {
                throw new IllegalStateException("buffer required length of " + n4 + " but only has " + n3);
            }
            int n5 = broadcastReceiver.typeId();
            this.scratchBuffer.putBytes(0, broadcastReceiver.buffer(), broadcastReceiver.offset(), n4);
            if (!broadcastReceiver.validate()) {
                throw new IllegalStateException("unable to keep up with broadcast");
            }
            messageHandler.onMessage(n5, this.scratchBuffer, 0, n4);
            n2 = 1;
        }
        return n2;
    }
}

