/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.function.Consumer;
import java.util.function.LongFunction;

public final class LongLruCache<E>
implements AutoCloseable {
    private final int capacity;
    private final LongFunction<E> factory;
    private final Consumer<E> closer;
    private final long[] keys;
    private final Object[] values;
    private int size;

    public LongLruCache(int n2, LongFunction<E> longFunction, Consumer<E> consumer) {
        this.capacity = n2;
        this.factory = longFunction;
        this.closer = consumer;
        this.keys = new long[n2];
        this.values = new Object[n2];
        this.size = 0;
    }

    public E lookup(long l2) {
        int n2 = this.size;
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (l2 != lArray[i2]) continue;
            Object object = objectArray[i2];
            this.makeMostRecent(l2, object, i2);
            return (E)object;
        }
        E e2 = this.factory.apply(l2);
        if (e2 != null) {
            if (this.capacity == n2) {
                this.closer.accept(objectArray[n2 - 1]);
            } else {
                this.size = ++n2;
            }
            this.makeMostRecent(l2, e2, n2 - 1);
        }
        return e2;
    }

    private void makeMostRecent(long l2, Object object, int n2) {
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        for (int i2 = n2; i2 > 0; --i2) {
            lArray[i2] = lArray[i2 - 1];
            objectArray[i2] = objectArray[i2 - 1];
        }
        lArray[0] = l2;
        objectArray[0] = object;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public void close() {
        Consumer<E> consumer = this.closer;
        Object[] objectArray = this.values;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            consumer.accept(objectArray[i2]);
        }
    }
}

