/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class LongHashSet
extends AbstractSet<Long> {
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    static final long MISSING_VALUE = 0L;
    private final boolean shouldAvoidAllocation;
    private boolean containsMissingValue;
    private final float loadFactor;
    private int resizeThreshold;
    private int sizeOfArrayValues;
    private long[] values;
    private LongIterator iterator;

    public LongHashSet() {
        this(8);
    }

    public LongHashSet(int n2) {
        this(n2, 0.65f, true);
    }

    public LongHashSet(int n2, float f2) {
        this(n2, f2, true);
    }

    public LongHashSet(int n2, float f2, boolean bl2) {
        CollectionUtil.validateLoadFactor(f2);
        this.shouldAvoidAllocation = bl2;
        this.loadFactor = f2;
        this.sizeOfArrayValues = 0;
        int n3 = BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2));
        this.resizeThreshold = (int)((float)n3 * f2);
        this.values = new long[n3];
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public boolean add(Long l2) {
        return this.add((long)l2);
    }

    @Override
    public boolean add(long l2) {
        long l3;
        if (0L == l2) {
            boolean bl2 = this.containsMissingValue;
            this.containsMissingValue = true;
            return !bl2;
        }
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(l2, n2);
        while (0L != (l3 = lArray[n3])) {
            if (l3 == l2) {
                return false;
            }
            n3 = LongHashSet.next(n3, n2);
        }
        lArray[n3] = l2;
        ++this.sizeOfArrayValues;
        if (this.sizeOfArrayValues > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return true;
    }

    private void increaseCapacity() {
        int n2 = this.values.length * 2;
        if (n2 < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size());
        }
        this.rehash(n2);
    }

    private void rehash(int n2) {
        long[] lArray;
        int n3 = n2;
        int n4 = n2 - 1;
        this.resizeThreshold = (int)((float)n2 * this.loadFactor);
        long[] lArray2 = new long[n3];
        for (long l2 : lArray = this.values) {
            if (0L == l2) continue;
            int n5 = Hashing.hash(l2, n4);
            while (0L != lArray2[n5]) {
                ++n5;
                n5 &= n4;
            }
            lArray2[n5] = l2;
        }
        this.values = lArray2;
    }

    @Override
    public boolean remove(Object object) {
        return this.remove((Long)object);
    }

    public boolean remove(long l2) {
        long l3;
        if (0L == l2) {
            boolean bl2 = this.containsMissingValue;
            this.containsMissingValue = false;
            return bl2;
        }
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(l2, n2);
        while (0L != (l3 = lArray[n3])) {
            if (l3 == l2) {
                lArray[n3] = 0L;
                this.compactChain(n3);
                --this.sizeOfArrayValues;
                return true;
            }
            n3 = LongHashSet.next(n3, n2);
        }
        return false;
    }

    private static int next(int n2, int n3) {
        return n2 + 1 & n3;
    }

    void compactChain(int n2) {
        long[] lArray = this.values;
        int n3 = lArray.length - 1;
        int n4 = n2;
        long l2;
        while (0L != (l2 = lArray[n4 = LongHashSet.next(n4, n3)])) {
            int n5 = Hashing.hash(l2, n3);
            if ((n4 >= n5 || n5 > n2 && n2 > n4) && (n5 > n2 || n2 > n4)) continue;
            lArray[n2] = l2;
            lArray[n4] = 0L;
            n2 = n4;
        }
        return;
    }

    public void compact() {
        int n2 = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    @Override
    public boolean contains(Object object) {
        return this.contains((Long)object);
    }

    public boolean contains(long l2) {
        long l3;
        if (0L == l2) {
            return this.containsMissingValue;
        }
        int n2 = this.values.length - 1;
        int n3 = Hashing.hash(l2, n2);
        while (0L != (l3 = this.values[n3])) {
            if (l3 == l2) {
                return true;
            }
            n3 = LongHashSet.next(n3, n2);
        }
        return false;
    }

    @Override
    public int size() {
        return this.sizeOfArrayValues + (this.containsMissingValue ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        if (this.size() > 0) {
            Arrays.fill(this.values, 0L);
            this.sizeOfArrayValues = 0;
            this.containsMissingValue = false;
        }
    }

    @Override
    public boolean addAll(Collection<? extends Long> collection) {
        boolean bl2 = false;
        for (Long l2 : collection) {
            bl2 |= this.add(l2);
        }
        return bl2;
    }

    public boolean addAll(LongHashSet longHashSet) {
        boolean bl2 = false;
        for (long l2 : longHashSet.values) {
            if (0L == l2) continue;
            bl2 |= this.add(l2);
        }
        if (longHashSet.containsMissingValue) {
            bl2 |= this.add(0L);
        }
        return bl2;
    }

    public boolean containsAll(LongHashSet longHashSet) {
        for (long l2 : longHashSet.values) {
            if (0L == l2 || this.contains(l2)) continue;
            return false;
        }
        return this.containsMissingValue || !longHashSet.containsMissingValue;
    }

    public LongHashSet difference(LongHashSet longHashSet) {
        long[] lArray;
        LongHashSet longHashSet2 = null;
        for (long l2 : lArray = this.values) {
            if (0L == l2 || longHashSet.contains(l2)) continue;
            if (null == longHashSet2) {
                longHashSet2 = new LongHashSet();
            }
            longHashSet2.add(l2);
        }
        if (this.containsMissingValue && !longHashSet.containsMissingValue) {
            if (null == longHashSet2) {
                longHashSet2 = new LongHashSet();
            }
            longHashSet2.add(0L);
        }
        return longHashSet2;
    }

    @Override
    public boolean removeIf(Predicate<? super Long> predicate) {
        return super.removeIf(predicate);
    }

    public boolean removeIfLong(LongPredicate longPredicate) {
        boolean bl2 = false;
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            if (!longPredicate.test(longIterator.nextValue())) continue;
            longIterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl2 = false;
        for (Object obj : collection) {
            bl2 |= this.remove(obj);
        }
        return bl2;
    }

    public boolean removeAll(LongHashSet longHashSet) {
        boolean bl2 = false;
        for (long l2 : longHashSet.values) {
            if (0L == l2) continue;
            bl2 |= this.remove(l2);
        }
        if (longHashSet.containsMissingValue) {
            bl2 |= this.remove(0L);
        }
        return bl2;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl2 = false;
        for (long l2 : this.values) {
            if (0L == l2 || collection.contains(l2)) continue;
            var3_3[var5_5] = 0L;
            --this.sizeOfArrayValues;
            bl2 = true;
        }
        if (bl2 && this.sizeOfArrayValues > 0) {
            int n2 = Math.max(8, BitUtil.findNextPositivePowerOfTwo(this.sizeOfArrayValues));
            this.rehash(n2);
        }
        if (this.containsMissingValue && !collection.contains(0L)) {
            this.containsMissingValue = false;
            bl2 = true;
        }
        return bl2;
    }

    public boolean retainAll(LongHashSet longHashSet) {
        boolean bl2 = false;
        for (long l2 : this.values) {
            if (0L == l2 || longHashSet.contains(l2)) continue;
            this.values[var4_4] = 0L;
            --this.sizeOfArrayValues;
            bl2 = true;
        }
        if (bl2 && this.sizeOfArrayValues > 0) {
            int n2 = Math.max(8, BitUtil.findNextPositivePowerOfTwo(this.sizeOfArrayValues));
            this.rehash(n2);
        }
        if (this.containsMissingValue && !longHashSet.contains(0L)) {
            this.containsMissingValue = false;
            bl2 = true;
        }
        return bl2;
    }

    public LongIterator iterator() {
        LongIterator longIterator = this.iterator;
        if (null == longIterator) {
            longIterator = new LongIterator();
            if (this.shouldAvoidAllocation) {
                this.iterator = longIterator;
            }
        }
        return longIterator.reset();
    }

    public void forEachLong(LongConsumer longConsumer) {
        if (this.sizeOfArrayValues > 0) {
            long[] lArray;
            for (long l2 : lArray = this.values) {
                if (0L == l2) continue;
                longConsumer.accept(l2);
            }
        }
        if (this.containsMissingValue) {
            longConsumer.accept(0L);
        }
    }

    public void copy(LongHashSet longHashSet) {
        if (this.values.length != longHashSet.values.length) {
            throw new IllegalArgumentException("cannot copy object: masks not equal");
        }
        System.arraycopy(longHashSet.values, 0, this.values, 0, this.values.length);
        this.sizeOfArrayValues = longHashSet.sizeOfArrayValues;
        this.containsMissingValue = longHashSet.containsMissingValue;
    }

    @Override
    public String toString() {
        long[] lArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (long l2 : lArray = this.values) {
            if (0L == l2) continue;
            stringBuilder.append(l2).append(", ");
        }
        if (this.containsMissingValue) {
            stringBuilder.append(0L).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Class<Long> clazz = TArray.getClass().getComponentType();
        if (!clazz.isAssignableFrom(Long.class)) {
            throw new ArrayStoreException("cannot store Longs in array of type " + clazz);
        }
        int n2 = this.size();
        Object[] objectArray = TArray.length >= n2 ? TArray : (Object[])Array.newInstance(clazz, n2);
        this.copyValues(objectArray);
        return objectArray;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        this.copyValues(objectArray);
        return objectArray;
    }

    private void copyValues(Object[] objectArray) {
        long[] lArray;
        int n2 = 0;
        for (long l2 : lArray = this.values) {
            if (0L == l2) continue;
            objectArray[n2++] = l2;
        }
        if (this.containsMissingValue) {
            objectArray[this.sizeOfArrayValues] = 0L;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof LongHashSet) {
            LongHashSet longHashSet = (LongHashSet)object;
            return longHashSet.containsMissingValue == this.containsMissingValue && longHashSet.sizeOfArrayValues == this.sizeOfArrayValues && this.containsAll(longHashSet);
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (set.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(set);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        for (long l2 : this.values) {
            if (0L == l2) continue;
            n2 += Long.hashCode(l2);
        }
        if (this.containsMissingValue) {
            n2 += Long.hashCode(0L);
        }
        return n2;
    }

    public final class LongIterator
    implements Iterator<Long> {
        private int remaining;
        private int positionCounter;
        private int stopCounter;
        private boolean isPositionValid = false;

        LongIterator reset() {
            int n2;
            this.remaining = LongHashSet.this.size();
            long[] lArray = LongHashSet.this.values;
            int n3 = n2 = lArray.length;
            if (0L != lArray[n2 - 1]) {
                for (n3 = 0; n3 < n2 && 0L != lArray[n3]; ++n3) {
                }
            }
            this.stopCounter = n3;
            this.positionCounter = n3 + n2;
            this.isPositionValid = false;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        public int remaining() {
            return this.remaining;
        }

        @Override
        public Long next() {
            return this.nextValue();
        }

        public long nextValue() {
            if (this.remaining == 1 && LongHashSet.this.containsMissingValue) {
                this.remaining = 0;
                this.isPositionValid = true;
                return 0L;
            }
            this.findNext();
            long[] lArray = LongHashSet.this.values;
            return lArray[this.position(lArray)];
        }

        @Override
        public void remove() {
            if (this.isPositionValid) {
                if (0 == this.remaining && LongHashSet.this.containsMissingValue) {
                    LongHashSet.this.containsMissingValue = false;
                } else {
                    long[] lArray = LongHashSet.this.values;
                    int n2 = this.position(lArray);
                    lArray[n2] = 0L;
                    --LongHashSet.this.sizeOfArrayValues;
                    LongHashSet.this.compactChain(n2);
                }
            } else {
                throw new IllegalStateException();
            }
            this.isPositionValid = false;
        }

        private void findNext() {
            long[] lArray = LongHashSet.this.values;
            int n2 = lArray.length - 1;
            this.isPositionValid = true;
            int n3 = this.stopCounter;
            for (int i2 = this.positionCounter - 1; i2 >= n3; --i2) {
                int n4 = i2 & n2;
                if (0L == lArray[n4]) continue;
                this.positionCounter = i2;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new NoSuchElementException();
        }

        private int position(long[] lArray) {
            return this.positionCounter & lArray.length - 1;
        }
    }
}

