/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class AsciiSequenceView
implements CharSequence {
    private DirectBuffer buffer;
    private int offset;
    private int length;

    public AsciiSequenceView() {
    }

    public AsciiSequenceView(DirectBuffer directBuffer, int n2, int n3) {
        this.buffer = directBuffer;
        this.offset = n2;
        this.length = n3;
    }

    @Override
    public int length() {
        return this.length;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    @Override
    public char charAt(int n2) {
        if (n2 < 0 || n2 >= this.length) {
            throw new StringIndexOutOfBoundsException("index=" + n2 + " length=" + this.length);
        }
        return (char)this.buffer.getByte(this.offset + n2);
    }

    @Override
    public AsciiSequenceView subSequence(int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException("start=" + n2);
        }
        if (n3 > this.length) {
            throw new StringIndexOutOfBoundsException("end=" + n3 + " length=" + this.length);
        }
        if (n3 - n2 < 0) {
            throw new StringIndexOutOfBoundsException("start=" + n2 + " end=" + n3);
        }
        return new AsciiSequenceView(this.buffer, this.offset + n2, n3 - n2);
    }

    public AsciiSequenceView wrap(DirectBuffer directBuffer, int n2, int n3) {
        this.buffer = directBuffer;
        this.offset = n2;
        this.length = n3;
        return this;
    }

    public void reset() {
        this.buffer = null;
        this.offset = 0;
        this.length = 0;
    }

    public int getBytes(MutableDirectBuffer mutableDirectBuffer, int n2) {
        if (null == this.buffer || this.length <= 0) {
            return 0;
        }
        mutableDirectBuffer.putBytes(n2, this.buffer, this.offset, this.length);
        return this.length;
    }

    @Override
    public String toString() {
        if (null == this.buffer || this.length <= 0) {
            return "";
        }
        return this.buffer.getStringWithoutLengthAscii(this.offset, this.length);
    }
}

