/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.util.Iterator;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.AbstractHistogramIterator;
import org.HdrHistogram.HistogramIterationValue;

public class LogarithmicIterator
extends AbstractHistogramIterator
implements Iterator<HistogramIterationValue> {
    long valueUnitsInFirstBucket;
    double logBase;
    double nextValueReportingLevel;
    long currentStepHighestValueReportingLevel;
    long currentStepLowestValueReportingLevel;

    public void reset(long l2, double d2) {
        this.reset(this.histogram, l2, d2);
    }

    private void reset(AbstractHistogram abstractHistogram, long l2, double d2) {
        super.resetIterator(abstractHistogram);
        this.logBase = d2;
        this.valueUnitsInFirstBucket = l2;
        this.nextValueReportingLevel = l2;
        this.currentStepHighestValueReportingLevel = (long)this.nextValueReportingLevel - 1L;
        this.currentStepLowestValueReportingLevel = abstractHistogram.lowestEquivalentValue(this.currentStepHighestValueReportingLevel);
    }

    public LogarithmicIterator(AbstractHistogram abstractHistogram, long l2, double d2) {
        this.reset(abstractHistogram, l2, d2);
    }

    @Override
    public boolean hasNext() {
        if (super.hasNext()) {
            return true;
        }
        return this.histogram.lowestEquivalentValue((long)this.nextValueReportingLevel) < this.nextValueAtIndex;
    }

    @Override
    void incrementIterationLevel() {
        this.nextValueReportingLevel *= this.logBase;
        this.currentStepHighestValueReportingLevel = (long)this.nextValueReportingLevel - 1L;
        this.currentStepLowestValueReportingLevel = this.histogram.lowestEquivalentValue(this.currentStepHighestValueReportingLevel);
    }

    @Override
    long getValueIteratedTo() {
        return this.currentStepHighestValueReportingLevel;
    }

    @Override
    boolean reachedIterationLevel() {
        return this.currentValueAtIndex >= this.currentStepLowestValueReportingLevel || this.currentIndex >= this.histogram.countsArrayLength - 1;
    }
}

