/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.Base64;
import okio.Buffer;
import okio.Util;

public class ByteString
implements Serializable,
Comparable<ByteString> {
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final long serialVersionUID = 1L;
    public static final ByteString EMPTY = ByteString.of(new byte[0]);
    final byte[] data;
    transient int hashCode;
    transient String utf8;

    ByteString(byte[] byArray) {
        this.data = byArray;
    }

    public static ByteString of(byte ... byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("data == null");
        }
        return new ByteString((byte[])byArray.clone());
    }

    public static ByteString of(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new IllegalArgumentException("data == null");
        }
        Util.checkOffsetAndCount(byArray.length, n2, n3);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return new ByteString(byArray2);
    }

    public static ByteString of(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("data == null");
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return new ByteString(byArray);
    }

    public static ByteString encodeUtf8(String string) {
        if (string == null) {
            throw new IllegalArgumentException("s == null");
        }
        ByteString byteString = new ByteString(string.getBytes(Util.UTF_8));
        byteString.utf8 = string;
        return byteString;
    }

    public static ByteString encodeString(String string, Charset charset) {
        if (string == null) {
            throw new IllegalArgumentException("s == null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        return new ByteString(string.getBytes(charset));
    }

    public String utf8() {
        String string = this.utf8;
        return string != null ? string : (this.utf8 = new String(this.data, Util.UTF_8));
    }

    public String string(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        return new String(this.data, charset);
    }

    public String base64() {
        return Base64.encode(this.data);
    }

    public ByteString md5() {
        return this.digest("MD5");
    }

    public ByteString sha1() {
        return this.digest("SHA-1");
    }

    public ByteString sha256() {
        return this.digest("SHA-256");
    }

    public ByteString sha512() {
        return this.digest("SHA-512");
    }

    private ByteString digest(String string) {
        try {
            return ByteString.of(MessageDigest.getInstance(string).digest(this.data));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    public ByteString hmacSha1(ByteString byteString) {
        return this.hmac("HmacSHA1", byteString);
    }

    public ByteString hmacSha256(ByteString byteString) {
        return this.hmac("HmacSHA256", byteString);
    }

    public ByteString hmacSha512(ByteString byteString) {
        return this.hmac("HmacSHA512", byteString);
    }

    private ByteString hmac(String string, ByteString byteString) {
        try {
            Mac mac = Mac.getInstance(string);
            mac.init(new SecretKeySpec(byteString.toByteArray(), string));
            return ByteString.of(mac.doFinal(this.data));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }

    public String base64Url() {
        return Base64.encodeUrl(this.data);
    }

    @Nullable
    public static ByteString decodeBase64(String string) {
        if (string == null) {
            throw new IllegalArgumentException("base64 == null");
        }
        byte[] byArray = Base64.decode(string);
        return byArray != null ? new ByteString(byArray) : null;
    }

    public String hex() {
        char[] cArray = new char[this.data.length * 2];
        int n2 = 0;
        for (byte by2 : this.data) {
            cArray[n2++] = HEX_DIGITS[by2 >> 4 & 0xF];
            cArray[n2++] = HEX_DIGITS[by2 & 0xF];
        }
        return new String(cArray);
    }

    public static ByteString decodeHex(String string) {
        if (string == null) {
            throw new IllegalArgumentException("hex == null");
        }
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("Unexpected hex string: " + string);
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = ByteString.decodeHexDigit(string.charAt(i2 * 2)) << 4;
            int n3 = ByteString.decodeHexDigit(string.charAt(i2 * 2 + 1));
            byArray[i2] = (byte)(n2 + n3);
        }
        return ByteString.of(byArray);
    }

    private static int decodeHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        throw new IllegalArgumentException("Unexpected hex digit: " + c2);
    }

    public static ByteString read(InputStream inputStream, int n2) throws IOException {
        int n3;
        if (inputStream == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("byteCount < 0: " + n2);
        }
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; i2 += n3) {
            n3 = inputStream.read(byArray, i2, n2 - i2);
            if (n3 != -1) continue;
            throw new EOFException();
        }
        return new ByteString(byArray);
    }

    public ByteString toAsciiLowercase() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            byte by2 = this.data[i2];
            if (by2 < 65 || by2 > 90) continue;
            byte[] byArray = (byte[])this.data.clone();
            byArray[i2++] = (byte)(by2 - -32);
            while (i2 < byArray.length) {
                by2 = byArray[i2];
                if (by2 >= 65 && by2 <= 90) {
                    byArray[i2] = (byte)(by2 - -32);
                }
                ++i2;
            }
            return new ByteString(byArray);
        }
        return this;
    }

    public ByteString toAsciiUppercase() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            byte by2 = this.data[i2];
            if (by2 < 97 || by2 > 122) continue;
            byte[] byArray = (byte[])this.data.clone();
            byArray[i2++] = (byte)(by2 - 32);
            while (i2 < byArray.length) {
                by2 = byArray[i2];
                if (by2 >= 97 && by2 <= 122) {
                    byArray[i2] = (byte)(by2 - 32);
                }
                ++i2;
            }
            return new ByteString(byArray);
        }
        return this;
    }

    public ByteString substring(int n2) {
        return this.substring(n2, this.data.length);
    }

    public ByteString substring(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("beginIndex < 0");
        }
        if (n3 > this.data.length) {
            throw new IllegalArgumentException("endIndex > length(" + this.data.length + ")");
        }
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException("endIndex < beginIndex");
        }
        if (n2 == 0 && n3 == this.data.length) {
            return this;
        }
        byte[] byArray = new byte[n4];
        System.arraycopy(this.data, n2, byArray, 0, n4);
        return new ByteString(byArray);
    }

    public byte getByte(int n2) {
        return this.data[n2];
    }

    public int size() {
        return this.data.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.data.clone();
    }

    byte[] internalArray() {
        return this.data;
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.data).asReadOnlyBuffer();
    }

    public void write(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        outputStream.write(this.data);
    }

    void write(Buffer buffer) {
        buffer.write(this.data, 0, this.data.length);
    }

    public boolean rangeEquals(int n2, ByteString byteString, int n3, int n4) {
        return byteString.rangeEquals(n3, this.data, n2, n4);
    }

    public boolean rangeEquals(int n2, byte[] byArray, int n3, int n4) {
        return n2 >= 0 && n2 <= this.data.length - n4 && n3 >= 0 && n3 <= byArray.length - n4 && Util.arrayRangeEquals(this.data, n2, byArray, n3, n4);
    }

    public final boolean startsWith(ByteString byteString) {
        return this.rangeEquals(0, byteString, 0, byteString.size());
    }

    public final boolean startsWith(byte[] byArray) {
        return this.rangeEquals(0, byArray, 0, byArray.length);
    }

    public final boolean endsWith(ByteString byteString) {
        return this.rangeEquals(this.size() - byteString.size(), byteString, 0, byteString.size());
    }

    public final boolean endsWith(byte[] byArray) {
        return this.rangeEquals(this.size() - byArray.length, byArray, 0, byArray.length);
    }

    public final int indexOf(ByteString byteString) {
        return this.indexOf(byteString.internalArray(), 0);
    }

    public final int indexOf(ByteString byteString, int n2) {
        return this.indexOf(byteString.internalArray(), n2);
    }

    public final int indexOf(byte[] byArray) {
        return this.indexOf(byArray, 0);
    }

    public int indexOf(byte[] byArray, int n2) {
        int n3 = this.data.length - byArray.length;
        for (int i2 = n2 = Math.max(n2, 0); i2 <= n3; ++i2) {
            if (!Util.arrayRangeEquals(this.data, i2, byArray, 0, byArray.length)) continue;
            return i2;
        }
        return -1;
    }

    public final int lastIndexOf(ByteString byteString) {
        return this.lastIndexOf(byteString.internalArray(), this.size());
    }

    public final int lastIndexOf(ByteString byteString, int n2) {
        return this.lastIndexOf(byteString.internalArray(), n2);
    }

    public final int lastIndexOf(byte[] byArray) {
        return this.lastIndexOf(byArray, this.size());
    }

    public int lastIndexOf(byte[] byArray, int n2) {
        for (int i2 = n2 = Math.min(n2, this.data.length - byArray.length); i2 >= 0; --i2) {
            if (!Util.arrayRangeEquals(this.data, i2, byArray, 0, byArray.length)) continue;
            return i2;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof ByteString && ((ByteString)object).size() == this.data.length && ((ByteString)object).rangeEquals(0, this.data, 0, this.data.length);
    }

    public int hashCode() {
        int n2 = this.hashCode;
        return n2 != 0 ? n2 : (this.hashCode = Arrays.hashCode(this.data));
    }

    @Override
    public int compareTo(ByteString byteString) {
        int n2 = this.size();
        int n3 = byteString.size();
        int n4 = Math.min(n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            int n6 = this.getByte(i2) & 0xFF;
            if (n6 == (n5 = byteString.getByte(i2) & 0xFF)) continue;
            return n6 < n5 ? -1 : 1;
        }
        if (n2 == n3) {
            return 0;
        }
        return n2 < n3 ? -1 : 1;
    }

    public String toString() {
        if (this.data.length == 0) {
            return "[size=0]";
        }
        String string = this.utf8();
        int n2 = ByteString.codePointIndexToCharIndex(string, 64);
        if (n2 == -1) {
            return this.data.length <= 64 ? "[hex=" + this.hex() + "]" : "[size=" + this.data.length + " hex=" + this.substring(0, 64).hex() + "\u2026]";
        }
        String string2 = string.substring(0, n2).replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r");
        return n2 < string.length() ? "[size=" + this.data.length + " text=" + string2 + "\u2026]" : "[text=" + string2 + "]";
    }

    static int codePointIndexToCharIndex(String string, int n2) {
        int n3;
        int n4 = 0;
        int n5 = string.length();
        for (int i2 = 0; i2 < n5; i2 += Character.charCount(n3)) {
            if (n4 == n2) {
                return i2;
            }
            n3 = string.codePointAt(i2);
            if (Character.isISOControl(n3) && n3 != 10 && n3 != 13 || n3 == 65533) {
                return -1;
            }
            ++n4;
        }
        return string.length();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n2 = objectInputStream.readInt();
        ByteString byteString = ByteString.read(objectInputStream, n2);
        try {
            Field field = ByteString.class.getDeclaredField("data");
            field.setAccessible(true);
            field.set(this, byteString.data);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.data.length);
        objectOutputStream.write(this.data);
    }
}

