/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import okhttp3.CipherSuite;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;

public final class Handshake {
    private final TlsVersion tlsVersion;
    private final CipherSuite cipherSuite;
    private final List<Certificate> peerCertificates;
    private final List<Certificate> localCertificates;

    private Handshake(TlsVersion tlsVersion, CipherSuite cipherSuite, List<Certificate> list, List<Certificate> list2) {
        this.tlsVersion = tlsVersion;
        this.cipherSuite = cipherSuite;
        this.peerCertificates = list;
        this.localCertificates = list2;
    }

    public static Handshake get(SSLSession sSLSession) {
        Certificate[] certificateArray;
        String string = sSLSession.getCipherSuite();
        if (string == null) {
            throw new IllegalStateException("cipherSuite == null");
        }
        CipherSuite cipherSuite = CipherSuite.forJavaName(string);
        String string2 = sSLSession.getProtocol();
        if (string2 == null) {
            throw new IllegalStateException("tlsVersion == null");
        }
        TlsVersion tlsVersion = TlsVersion.forJavaName(string2);
        try {
            certificateArray = sSLSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            certificateArray = null;
        }
        List<Certificate> list = certificateArray != null ? Util.immutableList(certificateArray) : Collections.emptyList();
        Certificate[] certificateArray2 = sSLSession.getLocalCertificates();
        List<Certificate> list2 = certificateArray2 != null ? Util.immutableList(certificateArray2) : Collections.emptyList();
        return new Handshake(tlsVersion, cipherSuite, list, list2);
    }

    public static Handshake get(TlsVersion tlsVersion, CipherSuite cipherSuite, List<Certificate> list, List<Certificate> list2) {
        if (tlsVersion == null) {
            throw new NullPointerException("tlsVersion == null");
        }
        if (cipherSuite == null) {
            throw new NullPointerException("cipherSuite == null");
        }
        return new Handshake(tlsVersion, cipherSuite, Util.immutableList(list), Util.immutableList(list2));
    }

    public TlsVersion tlsVersion() {
        return this.tlsVersion;
    }

    public CipherSuite cipherSuite() {
        return this.cipherSuite;
    }

    public List<Certificate> peerCertificates() {
        return this.peerCertificates;
    }

    @Nullable
    public Principal peerPrincipal() {
        return !this.peerCertificates.isEmpty() ? ((X509Certificate)this.peerCertificates.get(0)).getSubjectX500Principal() : null;
    }

    public List<Certificate> localCertificates() {
        return this.localCertificates;
    }

    @Nullable
    public Principal localPrincipal() {
        return !this.localCertificates.isEmpty() ? ((X509Certificate)this.localCertificates.get(0)).getSubjectX500Principal() : null;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Handshake)) {
            return false;
        }
        Handshake handshake = (Handshake)object;
        return this.tlsVersion.equals((Object)handshake.tlsVersion) && this.cipherSuite.equals(handshake.cipherSuite) && this.peerCertificates.equals(handshake.peerCertificates) && this.localCertificates.equals(handshake.localCertificates);
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 31 * n2 + this.tlsVersion.hashCode();
        n2 = 31 * n2 + this.cipherSuite.hashCode();
        n2 = 31 * n2 + this.peerCertificates.hashCode();
        n2 = 31 * n2 + this.localCertificates.hashCode();
        return n2;
    }
}

