/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra.wavelet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FastWaveletTransform {
    private static final Logger LOGGER = LoggerFactory.getLogger(FastWaveletTransform.class);
    static final double[] scale = new double[]{0.0322231f, -0.01260396745055914, -0.09921954572200775, 0.2978578f, 0.8037387728691101, 0.4976186752319336, -0.029635528102517128, -0.0757657140493393};
    static final double[] wavelet = new double[]{-scale[7], scale[6], -scale[5], scale[4], -scale[3], scale[2], -scale[1], scale[0]};

    private FastWaveletTransform() {
    }

    public static void invTransform(double[] dArray) {
        int n2 = 8;
        while (2 * n2 <= dArray.length) {
            FastWaveletTransform.invTransform(dArray, n2);
            n2 *= 2;
        }
        if (n2 != dArray.length) {
            LOGGER.atWarn().addArgument(dArray.length).log("Careful! this should be a power of 2 : {}");
        }
    }

    public static void transform(double[] dArray) {
        int n2;
        for (n2 = dArray.length; n2 > 8; n2 /= 2) {
            FastWaveletTransform.transform(dArray, n2);
        }
        if (n2 != 8) {
            LOGGER.atWarn().addArgument(dArray.length).log("Careful! this should be a power of 2 : {}");
        }
    }

    public static void invTransform(double[] dArray, int n2) {
        int n3 = n2 << 1;
        double[] dArray2 = new double[n3];
        try {
            for (int i2 = 0; i2 < dArray.length / 2 - scale.length; ++i2) {
                for (int i3 = wavelet.length - 1; i3 >= 0; --i3) {
                    int n4 = 2 * i2 + i3;
                    dArray2[n4] = dArray2[n4] + (scale[i3] * dArray[i2] + wavelet[i3] * dArray[i2 + n2]);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            LOGGER.atWarn().addArgument(n2).setCause(indexOutOfBoundsException).log("exception {}  message:");
        }
        int n5 = n3 - 6;
        dArray2[n5] = dArray2[n5] + (scale[0] * dArray[n2 - 3] + wavelet[0] * dArray[n3 - 3]);
        int n6 = n3 - 5;
        dArray2[n6] = dArray2[n6] + (scale[1] * dArray[n2 - 3] + wavelet[1] * dArray[n3 - 3]);
        int n7 = n3 - 4;
        dArray2[n7] = dArray2[n7] + (scale[2] * dArray[n2 - 3] + wavelet[2] * dArray[n3 - 3]);
        int n8 = n3 - 3;
        dArray2[n8] = dArray2[n8] + (scale[3] * dArray[n2 - 3] + wavelet[3] * dArray[n3 - 3]);
        int n9 = n3 - 2;
        dArray2[n9] = dArray2[n9] + (scale[4] * dArray[n2 - 3] + wavelet[4] * dArray[n3 - 3]);
        int n10 = n3 - 1;
        dArray2[n10] = dArray2[n10] + (scale[5] * dArray[n2 - 3] + wavelet[5] * dArray[n3 - 3]);
        dArray2[0] = dArray2[0] + (scale[6] * dArray[n2 - 3] + wavelet[6] * dArray[n3 - 3]);
        dArray2[1] = dArray2[1] + (scale[7] * dArray[n2 - 3] + wavelet[7] * dArray[n3 - 3]);
        int n11 = n3 - 4;
        dArray2[n11] = dArray2[n11] + (scale[0] * dArray[n2 - 2] + wavelet[0] * dArray[n3 - 2]);
        int n12 = n3 - 3;
        dArray2[n12] = dArray2[n12] + (scale[1] * dArray[n2 - 2] + wavelet[1] * dArray[n3 - 2]);
        int n13 = n3 - 2;
        dArray2[n13] = dArray2[n13] + (scale[2] * dArray[n2 - 2] + wavelet[2] * dArray[n3 - 2]);
        int n14 = n3 - 1;
        dArray2[n14] = dArray2[n14] + (scale[3] * dArray[n2 - 2] + wavelet[3] * dArray[n3 - 2]);
        dArray2[0] = dArray2[0] + (scale[4] * dArray[n2 - 2] + wavelet[4] * dArray[n3 - 2]);
        dArray2[1] = dArray2[1] + (scale[5] * dArray[n2 - 2] + wavelet[5] * dArray[n3 - 2]);
        dArray2[2] = dArray2[2] + (scale[6] * dArray[n2 - 2] + wavelet[6] * dArray[n3 - 2]);
        dArray2[3] = dArray2[3] + (scale[7] * dArray[n2 - 2] + wavelet[7] * dArray[n3 - 2]);
        int n15 = n3 - 2;
        dArray2[n15] = dArray2[n15] + (scale[0] * dArray[n2 - 1] + wavelet[0] * dArray[n3 - 1]);
        int n16 = n3 - 1;
        dArray2[n16] = dArray2[n16] + (scale[1] * dArray[n2 - 1] + wavelet[1] * dArray[n3 - 1]);
        dArray2[0] = dArray2[0] + (scale[2] * dArray[n2 - 1] + wavelet[2] * dArray[n3 - 1]);
        dArray2[1] = dArray2[1] + (scale[3] * dArray[n2 - 1] + wavelet[3] * dArray[n3 - 1]);
        dArray2[2] = dArray2[2] + (scale[4] * dArray[n2 - 1] + wavelet[4] * dArray[n3 - 1]);
        dArray2[3] = dArray2[3] + (scale[5] * dArray[n2 - 1] + wavelet[5] * dArray[n3 - 1]);
        dArray2[4] = dArray2[4] + (scale[6] * dArray[n2 - 1] + wavelet[6] * dArray[n3 - 1]);
        dArray2[5] = dArray2[5] + (scale[7] * dArray[n2 - 1] + wavelet[7] * dArray[n3 - 1]);
        System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
    }

    public static int mirror(int n2, int n3) {
        if (n2 < n3) {
            return n2;
        }
        return 2 * n3 - n2;
    }

    public static void transform(double[] dArray, int n2) {
        double[] dArray2 = new double[n2];
        int n3 = n2 >> 1;
        try {
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int i3 = 0; i3 < wavelet.length; ++i3) {
                    double d2 = dArray[FastWaveletTransform.mirror(2 * i2 + i3, dArray.length)] * wavelet[i3];
                    double d3 = dArray[FastWaveletTransform.mirror(2 * i2 + i3, dArray.length)] * scale[i3];
                    int n4 = i2 + n3;
                    dArray2[n4] = dArray2[n4] + d2;
                    int n5 = i2;
                    dArray2[n5] = dArray2[n5] + d3;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            LOGGER.atWarn().addArgument(n2).setCause(indexOutOfBoundsException).log("exception {}  message:");
        }
        System.arraycopy(dArray2, 0, dArray, 0, n2);
    }
}

