/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.spi.DataSetBuilder;
import io.fair_acc.math.Math;
import io.fair_acc.math.MathBase;
import io.fair_acc.math.Spline;
import io.fair_acc.math.TRandom;
import io.fair_acc.math.matrix.MatrixD;
import io.fair_acc.math.spectra.Convolution;
import io.fair_acc.math.spectra.HilbertTransform;
import io.fair_acc.math.spectra.SpectrumTools;
import io.fair_acc.math.utils.ConcurrencyUtils;

public class EEMD {
    private static final TRandom rnd = new TRandom(0L);
    private int fstatus = 100;

    public MatrixD eemd(double[] dArray, double d2, double d3) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        double d4 = Math.rms(dArray);
        int n3 = (int)Math.floor(MathBase.log2(n2)) - 1;
        int n4 = n3 + 2;
        MatrixD matrixD = new MatrixD(n2, n4 + 1);
        MatrixD matrixD2 = new MatrixD(n2, n4 + 1);
        int n5 = 0;
        while ((double)n5 < d3) {
            int n6;
            for (n6 = 0; n6 < n2; ++n6) {
                double d5 = TRandom.Gaus(0.0, d2);
                dArray2[n6] = dArray[n6] / d4 + d5;
            }
            for (n6 = 0; n6 < n2; ++n6) {
                matrixD2.set(n6, 0, dArray[n6]);
            }
            System.arraycopy(dArray2, 0, dArray3, 0, n2);
            System.arraycopy(dArray2, 0, dArray6, 0, n2);
            for (n6 = 1; n6 < n3; ++n6) {
                int n7;
                System.arraycopy(dArray6, 0, dArray4, 0, n2);
                System.arraycopy(dArray6, 0, dArray5, 0, n2);
                this.fstatus = (int)((double)n6 / (double)n3) * 100;
                boolean bl2 = false;
                for (n7 = 0; n7 < 30000; ++n7) {
                    double d6;
                    double[][] dArray7 = SpectrumTools.computeMaxima(dArray4);
                    double[][] dArray8 = SpectrumTools.computeMinima(dArray4);
                    int n8 = dArray7[0].length + dArray8[0].length;
                    int n9 = EEMD.computeZeroCrossings(dArray4);
                    if (dArray7[0].length < 3 || dArray8[0].length < 3) {
                        bl2 = true;
                        System.err.println("break loop: iter = " + n7 + " nmode " + n6);
                        break;
                    }
                    Spline spline = new Spline(dArray7[0], dArray7[1]);
                    Spline spline2 = new Spline(dArray8[0], dArray8[1]);
                    int n10 = 0;
                    while (n10 < n2) {
                        double d7 = (spline.getValue(n10) + spline2.getValue(n10)) / 2.0;
                        int n11 = n10++;
                        dArray4[n11] = dArray4[n11] - d7;
                    }
                    double d8 = 0.0;
                    double d9 = 0.0;
                    for (int i2 = 0; i2 < dArray4.length; ++i2) {
                        d9 += MathBase.sqr(dArray5[i2] - dArray4[i2]);
                        d8 += MathBase.sqr(dArray5[i2]);
                    }
                    double d10 = 1.0E-12;
                    double d11 = d6 = d8 != 0.0 ? d9 / d8 : 42.0;
                    if (d8 == 0.0 || d6 < 1.0E-12) {
                        System.err.printf("break at mode %d and  iteration %d with criteria %e\n", n6, n7, d6);
                        break;
                    }
                    if (d8 == 0.0 || Math.abs(n8 - n9) <= 0) {
                        System.err.printf("break (crossing) at mode %d and  iteration %d with criteria %f\n", n6, n7, d9 / d8);
                        break;
                    }
                    System.arraycopy(dArray4, 0, dArray5, 0, dArray4.length);
                }
                for (n7 = 0; n7 < n2; ++n7) {
                    int n12 = n7;
                    dArray6[n12] = dArray6[n12] - dArray4[n7];
                }
                for (n7 = 0; n7 < n2; ++n7) {
                    matrixD2.set(n7, n6, dArray4[n7]);
                }
                if (!bl2) continue;
                n6 = n3 + 1;
            }
            for (n6 = 0; n6 < n2; ++n6) {
                matrixD2.set(n6, n3 + 1, dArray6[n6]);
            }
            matrixD.plus(matrixD2);
            ++n5;
        }
        matrixD.times(1.0 / d3);
        matrixD.times(d4);
        return matrixD2;
    }

    public synchronized DataSet getScalogram(double[] dArray, int n2, int n3) {
        int n4;
        this.fstatus = 0;
        int n5 = dArray.length;
        double[] dArray2 = new double[n5];
        double[] dArray3 = new double[n5 / 2];
        for (n4 = 0; n4 < n5; ++n4) {
            dArray2[n4] = n4;
        }
        for (n4 = 0; n4 < n5 / 2; ++n4) {
            dArray3[n4] = (double)n4 / (double)n5;
        }
        DataSet dataSet = new DataSetBuilder("HilbertSpectrum").setValues(0, dArray2).setValues(1, dArray3).setValues(2, this.getSpectrumArray(dArray, n2, n3)).build();
        this.fstatus = 100;
        return dataSet;
    }

    public double[][] getSpectrumArray(double[] dArray, int n2, int n3) {
        int n4 = dArray.length;
        double[][] dArray2 = new double[n4 / 2][n4];
        for (int i2 = 0; i2 < n4 / 2; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                dArray2[i2][i3] = Double.NaN;
            }
        }
        HilbertTransform hilbertTransform = new HilbertTransform();
        MatrixD matrixD = this.eemd(dArray, 0.0, 1.0);
        double[] dArray3 = new double[n4];
        int n5 = matrixD.getColumnDimension() - 1;
        for (int i4 = 1; i4 < n5; ++i4) {
            for (int i5 = 0; i5 < n4; ++i5) {
                dArray3[i5] = matrixD.get(i5, i4);
            }
            Convolution convolution = new Convolution();
            double[] dArray4 = Convolution.getLowPassFilter(ConcurrencyUtils.nextPow2(3 * n4), 0.3);
            double[] dArray5 = hilbertTransform.computeInstantaneousAmplitude(dArray3);
            double[] dArray6 = hilbertTransform.computeInstantaneousFrequency(dArray3);
            double[] dArray7 = convolution.transform(dArray5, dArray4, false);
            double[] dArray8 = convolution.transform(dArray6, dArray4, false);
            for (int i6 = 0; i6 < n4; ++i6) {
                if (i6 >= n4) continue;
                int n6 = (int)(dArray8[i6] * (double)n4);
                if (n6 < 0) {
                    n6 = 0;
                } else if (n6 >= n4 / 2) {
                    n6 = n4 / 2 - 1;
                }
                dArray2[n6][i6] = 10.0 * Math.log(dArray7[i6]);
                if (!(dArray2[n6][i6] < -10.0) && !(dArray2[n6][i6] > 10.0)) continue;
                dArray2[n6][i6] = Double.NaN;
            }
        }
        return dArray2;
    }

    public int getStatus() {
        return this.fstatus;
    }

    public boolean isBusy() {
        return this.fstatus < 100;
    }

    public static int computeZeroCrossings(double[] dArray) {
        int n2 = dArray.length;
        int n3 = 0;
        boolean bl2 = dArray[0] >= 0.0;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (bl2) {
                if (!(dArray[i2] < 0.0)) continue;
                bl2 = false;
                ++n3;
                continue;
            }
            if (!(dArray[i2] > 0.0)) continue;
            bl2 = true;
            ++n3;
        }
        return n3;
    }

    public static int extrema(double[] dArray, double[][] dArray2, double[][] dArray3) {
        int n2 = dArray.length;
        int n3 = 0;
        int n4 = 0;
        if (dArray[0] >= dArray[1]) {
            dArray2[0][0] = 0.0;
            dArray2[1][0] = dArray[0];
            ++n3;
        } else {
            dArray3[0][0] = 0.0;
            dArray3[1][0] = dArray[0];
            ++n4;
        }
        for (int i2 = 1; i2 < n2 - 1; ++i2) {
            if (dArray[i2 - 1] <= dArray[i2] && dArray[i2] >= dArray[i2 + 1]) {
                dArray2[0][n3] = i2;
                dArray2[1][n3] = dArray[i2];
                ++n3;
                continue;
            }
            if (!(dArray[i2 - 1] >= dArray[i2]) || !(dArray[i2] <= dArray[i2 + 1])) continue;
            dArray3[0][n4] = i2;
            dArray3[1][n4] = dArray[i2];
            ++n4;
        }
        if (dArray[n2 - 2] <= dArray[n2 - 1]) {
            dArray2[0][n3] = (double)n2 - 1.0;
            dArray2[1][n3] = dArray[n2 - 1];
            ++n3;
        } else {
            dArray3[0][n4] = (double)n2 - 1.0;
            dArray3[1][n4] = dArray[n2 - 1];
            ++n4;
        }
        return n3 + n4 > 2 ? 1 : -1;
    }
}

