/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math;

public class MathBase {
    public static final double SQRT_2 = 1.4142135623730951;
    public static final double PI = Math.PI;
    public static final double PI_OVER_2 = 1.5707963267948966;
    public static final double PI_OVER_4 = 0.7853981633974483;
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;
    public static final double TWO_PI = Math.PI * 2;
    public static final double INV_PI = 0.3183098861837907;
    public static final double E = Math.E;
    public static final double LOG_E = 0.4342944819032518;
    public static final double LOG_2 = 0.201029996;
    public static final double LN_10 = 2.302585092994046;
    public static final double EULER_GAMMA = 0.5772156649015329;
    public static final double C = 2.99792458E8;
    public static final double C_UNCERTAINTY = 0.0;
    public static final double C_CGS = 2.99792458E10;
    public static final double G = 6.673E-11;
    public static final double G_UNCERTAINTY = 1.0E-13;
    public static final double G_CGS = 6.673E-14;
    public static final double GHBAR_C = 6.707E-39;
    public static final double GHBAR_C_UNCERTAINTY = 1.0E-41;
    public static final double GN = 9.80665;
    public static final double GN_UNCERTAINTY = 0.0;
    public static final double QE = 1.602176462E-19;
    public static final double QE_UNCERTAINTY = 6.3E-27;
    public static final double H = 6.62606876E-34;
    public static final double H_BAR = 1.054571596E-34;
    public static final double H_BAR_UNCERTAINTY = 8.2E-42;
    public static final double H_BAR_CGS = 1.054571596E-27;
    public static final double HC = 1.9864454404374119E-25;
    public static final double K = 1.3806503E-23;
    public static final double K_UNCERTAINTY = 2.4E-29;
    public static final double K_CGS = 1.3806503E-16;
    public static final double SIGMA = 5.6704E-8;
    public static final double SIGMA_UNCERTAINTY = 4.0E-13;
    public static final double N_A = 6.02214199E23;
    public static final double N_A_UNCERTAINTY = 4.7E16;
    public static final double R = 8.314472145136097;
    public static final double H_UNCERTAINTY = 5.2E-41;
    public static final double H_CGS = 6.62606876E-27;
    public static final double HC_CGS = 1.986445440437412E-16;
    public static final double MW_AIR = 28.9644;
    public static final double RG_AIR = 287.0583248793725;
    public static final double R_UNCERTAINTY = 1.5102046417E-5;

    public static double log(double d2) {
        return Math.log(d2);
    }

    public static double log10(double d2) {
        return Math.log10(d2);
    }

    public static double aCosH(double d2) {
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = Math.abs(d2);
        return Math.log(d2 + d3 * Math.sqrt(1.0 - 1.0 / (d3 * d3)));
    }

    public static double aSinH(double d2) {
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = Math.abs(d2);
        return Math.log(d2 + d3 * Math.sqrt(1.0 + 1.0 / (d3 * d3)));
    }

    public static double aTanH(double d2) {
        return Math.log((1.0 + d2) / (1.0 - d2)) / 2.0;
    }

    public static double hypot(double d2, double d3) {
        return Math.hypot(d2, d3);
    }

    public static double abs(double d2) {
        return d2 >= 0.0 ? d2 : -d2;
    }

    public static float abs(float f2) {
        return f2 >= 0.0f ? f2 : -f2;
    }

    public static int abs(int n2) {
        return n2 >= 0 ? n2 : -n2;
    }

    public static long abs(long l2) {
        return l2 >= 0L ? l2 : -l2;
    }

    public static short abs(short s2) {
        return s2 >= 0 ? s2 : (short)(-s2);
    }

    public static double aCos(double d2) {
        return Math.acos(d2);
    }

    public static double aSin(double d2) {
        return Math.asin(d2);
    }

    public static double aTan(double d2) {
        return Math.atan(d2);
    }

    public static double aTan2(double d2, double d3) {
        if (d3 != 0.0) {
            return Math.atan2(d2, d3);
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        if (d2 > 0.0) {
            return 1.5707963267948966;
        }
        return -1.5707963267948966;
    }

    public static double ceil(double d2) {
        return Math.ceil(d2);
    }

    public static int ceilNInt(double d2) {
        return MathBase.nInt(Math.ceil(d2));
    }

    public static double cos(double d2) {
        return Math.cos(d2);
    }

    public static double cosH(double d2) {
        return Math.cosh(d2);
    }

    public static boolean even(long l2) {
        return (l2 & 1L) == 0L;
    }

    public static double exp(double d2) {
        return Math.exp(d2);
    }

    public static boolean finite(double d2) {
        return !Double.isInfinite(d2) && !Double.isNaN(d2);
    }

    public static double floor(double d2) {
        return Math.floor(d2);
    }

    public static int floorNint(double d2) {
        return MathBase.nInt(Math.floor(d2));
    }

    public static boolean isNaN(double d2) {
        return Double.isNaN(d2);
    }

    public static double ldExp(double d2, int n2) {
        return d2 * Math.pow(2.0, n2);
    }

    public static double log2(double d2) {
        return Math.log(d2) / 0.201029996;
    }

    public static double max(double d2, double d3) {
        return d2 >= d3 ? d2 : d3;
    }

    public static float max(float f2, float f3) {
        return f2 >= f3 ? f2 : f3;
    }

    public static int max(int n2, int n3) {
        return n2 >= n3 ? n2 : n3;
    }

    public static long max(long l2, long l3) {
        return l2 >= l3 ? l2 : l3;
    }

    public static short max(short s2, short s3) {
        return s2 >= s3 ? s2 : s3;
    }

    public static double min(double d2, double d3) {
        return d2 <= d3 ? d2 : d3;
    }

    public static float min(float f2, float f3) {
        return f2 <= f3 ? f2 : f3;
    }

    public static int min(int n2, int n3) {
        return n2 <= n3 ? n2 : n3;
    }

    public static long min(long l2, long l3) {
        return l2 <= l3 ? l2 : l3;
    }

    public static short min(short s2, short s3) {
        return s2 <= s3 ? s2 : s3;
    }

    public static long nextPrime(long l2) {
        if (l2 <= 2L) {
            return 2L;
        }
        if (l2 == 3L) {
            return 3L;
        }
        long l3 = l2 % 2L == 0L ? l2 + 1L : l2;
        long l4 = (long)Math.sqrt(l3) + 1L;
        while (true) {
            long l5;
            for (l5 = 3L; l5 <= l4 && l3 % l5 != 0L; l5 += 2L) {
            }
            if (l5 > l4) {
                return l3;
            }
            l3 += 2L;
        }
    }

    public static int nInt(double d2) {
        int n2;
        if (d2 >= 0.0) {
            n2 = (int)(d2 + 0.5);
            if (d2 + 0.5 == (double)n2 && (n2 & 1) > 0) {
                --n2;
            }
        } else {
            n2 = (int)(d2 - 0.5);
            if (d2 - 0.5 == (double)n2 && (n2 & 1) > 0) {
                ++n2;
            }
        }
        return n2;
    }

    public static int nInt(float f2) {
        int n2;
        if (f2 >= 0.0f) {
            n2 = (int)(f2 + 0.5f);
            if (f2 + 0.5f == (float)n2 && (n2 & 1) > 0) {
                --n2;
            }
        } else {
            n2 = (int)((double)f2 - 0.5);
            if (f2 - 0.5f == (float)n2 && (n2 & 1) > 0) {
                ++n2;
            }
        }
        return n2;
    }

    public static boolean odd(long l2) {
        return (l2 & 1L) != 0L;
    }

    public static double pow(double d2, double d3) {
        return Math.pow(d2, d3);
    }

    public static double range(double d2, double d3, double d4) {
        return d4 < d2 ? d2 : (d4 > d3 ? d3 : d4);
    }

    public static int range(int n2, int n3, int n4) {
        return n4 < n2 ? n2 : (n4 > n3 ? n3 : n4);
    }

    public static long range(long l2, long l3, long l4) {
        return l4 < l2 ? l2 : (l4 > l3 ? l3 : l4);
    }

    public static short range(short s2, short s3, short s4) {
        return s4 < s2 ? s2 : (s4 > s3 ? s3 : s4);
    }

    public static double sign(double d2, double d3) {
        return d3 >= 0.0 ? MathBase.abs(d2) : -MathBase.abs(d2);
    }

    public static double sin(double d2) {
        return Math.sin(d2);
    }

    public static double sinH(double d2) {
        return Math.sinh(d2);
    }

    public static double sqr(double d2) {
        return d2 * d2;
    }

    public static double sqrt(double d2) {
        return Math.sqrt(d2);
    }

    public static double tan(double d2) {
        return Math.tan(d2);
    }

    public static double tanH(double d2) {
        return Math.tanh(d2);
    }
}

