/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSetMetaData;
import io.fair_acc.dataset.GridDataSet;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.events.StateListener;
import io.fair_acc.dataset.spi.DoubleDataSet;

public class DimReductionDataSet
extends DoubleDataSet
implements StateListener {
    private static final long serialVersionUID = 1L;
    private final Option reductionOption;
    private final GridDataSet source;
    private final int dimIndex;
    private int minIndex;
    private int maxIndex;
    private double minValue;
    private double maxValue;

    public DimReductionDataSet(GridDataSet gridDataSet, int n2, Option option) {
        super(gridDataSet.getName() + "-" + option + "-dim" + n2);
        this.source = gridDataSet;
        this.dimIndex = n2;
        this.reductionOption = option;
        this.source.addListener(this);
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public Option getReductionOption() {
        return this.reductionOption;
    }

    public DataSet getSourceDataSet() {
        return this.source;
    }

    public void handle(int n2) {
        this.lock().writeLockGuard(() -> this.source.lock().readLockGuard(() -> {
            this.getWarningList().clear();
            if (this.source instanceof DataSetMetaData) {
                this.getWarningList().addAll(((DataSetMetaData)((Object)this.source)).getWarningList());
            }
            if (this.source.getDimension() != 3 || this.source.getNGrid() != 2) {
                this.getWarningList().add("input data set not 3 dim grid data set");
                return;
            }
            this.minIndex = this.source.getGridIndex(this.dimIndex == 0 ? 1 : 0, this.minValue);
            this.maxIndex = this.source.getGridIndex(this.dimIndex == 0 ? 1 : 0, this.maxValue);
            switch (this.reductionOption) {
                case MIN: {
                    this.updateMinMax(true);
                    break;
                }
                case MAX: {
                    this.updateMinMax(false);
                    break;
                }
                case MEAN: {
                    this.updateMeanIntegral(true);
                    break;
                }
                case INTEGRAL: {
                    this.updateMeanIntegral(false);
                    break;
                }
                default: {
                    this.updateSlice();
                }
            }
        }));
        this.fireInvalidated(ChartBits.DataSetDataAdded);
    }

    public void setMaxValue(double d2) {
        this.lock().writeLockGuard(() -> {
            this.maxValue = d2;
            return this.maxValue;
        });
        this.handle(ChartBits.DataSetData.getAsInt());
    }

    public void setMinValue(double d2) {
        this.lock().writeLockGuard(() -> {
            this.minValue = d2;
            return this.minValue;
        });
        this.handle(ChartBits.DataSetData.getAsInt());
    }

    public void setRange(double d2, double d3) {
        this.lock().writeLockGuard(() -> {
            this.minValue = d2;
            this.maxValue = d3;
        });
        this.handle(ChartBits.DataSetData.getAsInt());
    }

    protected void updateMeanIntegral(boolean bl2) {
        int n2 = Math.min(this.minIndex, this.maxIndex);
        int n3 = Math.max(Math.max(this.minIndex, this.maxIndex), n2 + 1);
        this.clearData();
        int n4 = this.source.getShape(this.dimIndex);
        for (int i2 = 0; i2 < n4; ++i2) {
            double d2 = this.source.getGrid(this.dimIndex, i2);
            double d3 = 0.0;
            double d4 = 0.0;
            for (int i3 = n2; i3 <= Math.min(n3, n4 - 1); ++i3) {
                d3 = this.dimIndex == 1 ? (d3 += this.source.get(2, i3, i2)) : (d3 += this.source.get(2, i2, i3));
                d4 += 1.0;
            }
            if (bl2) {
                this.add(d2, d4 == 0.0 ? Double.NaN : d3 / d4);
                continue;
            }
            this.add(d2, d3);
        }
    }

    protected void updateMinMax(boolean bl2) {
        int n2 = Math.min(this.minIndex, this.maxIndex);
        int n3 = Math.max(Math.max(this.minIndex, this.maxIndex), n2 + 1);
        this.clearData();
        int n4 = this.source.getShape(this.dimIndex);
        for (int i2 = 0; i2 < n4; ++i2) {
            double d2 = this.source.get(this.dimIndex, i2);
            double d3 = this.dimIndex == 1 ? this.source.get(2, n2, i2) : this.source.get(2, i2, n2);
            for (int i3 = n2 + 1; i3 <= Math.min(n3, n4 - 1); ++i3) {
                double d4 = this.dimIndex == 1 ? this.source.get(2, i3, i2) : this.source.get(2, i2, i3);
                d3 = bl2 ? Math.min(d4, d3) : Math.max(d4, d3);
            }
            this.add(d2, d3);
        }
    }

    protected void updateSlice() {
        this.clearData();
        int n2 = this.source.getShape(this.dimIndex);
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2 = this.source.getGrid(this.dimIndex, i2);
            double d3 = this.dimIndex == 1 ? this.source.get(2, this.minIndex, i2) : this.source.get(2, i2, this.minIndex);
            this.add(d2, d3);
        }
    }

    public static enum Option {
        MIN,
        MEAN,
        MAX,
        INTEGRAL,
        SLICE;

    }
}

