/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.DataRange;
import io.fair_acc.dataset.spi.utils.MathUtils;
import java.util.Objects;
import java.util.function.IntSupplier;

public class DefaultAxisDescription
extends DataRange
implements AxisDescription {
    private final transient BitState state = BitState.initDirty(this);
    private final Runnable notifyRangeChanged = this.state.onAction(ChartBits.AxisDescriptionRange, new IntSupplier[0]);
    private final Runnable notifyNameChanged = this.state.onAction(ChartBits.AxisDescriptionName, new IntSupplier[0]);
    private final int dimIndex;
    private String name;
    private String unit;

    public DefaultAxisDescription(int n2) {
        this.dimIndex = n2;
        this.name = "unknown axis";
        this.unit = "a.u.";
    }

    public DefaultAxisDescription(AxisDescription axisDescription) {
        this.dimIndex = axisDescription.getDimIndex();
        this.set(axisDescription.getName(), axisDescription.getUnit(), axisDescription.getMin(), axisDescription.getMax());
    }

    public DefaultAxisDescription(int n2, String string, String ... stringArray) {
        this.dimIndex = n2;
        this.set(string, stringArray);
    }

    public DefaultAxisDescription(int n2, String string, String string2, double d2, double d3) {
        this.dimIndex = n2;
        this.set(string, string2, d2, d3);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AxisDescription)) {
            return false;
        }
        return this.equals(object, 1.0E-6);
    }

    public boolean equals(Object object, double d2) {
        if (!(object instanceof AxisDescription)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        AxisDescription axisDescription = (AxisDescription)object;
        if (this.hashCode() == axisDescription.hashCode()) {
            return true;
        }
        if (!DefaultAxisDescription.strEqual(this.getName(), axisDescription.getName())) {
            return false;
        }
        if (!DefaultAxisDescription.strEqual(this.getUnit(), axisDescription.getUnit())) {
            return false;
        }
        if (d2 <= 0.0) {
            if (this.getMin() != axisDescription.getMin()) {
                return false;
            }
            return this.getMax() == axisDescription.getMax();
        }
        if (!MathUtils.nearlyEqual(this.getMin(), axisDescription.getMin(), d2)) {
            return false;
        }
        return MathUtils.nearlyEqual(this.getMax(), axisDescription.getMax(), d2);
    }

    @Override
    public final int getDimIndex() {
        return this.dimIndex;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getUnit() {
        return this.unit;
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.name == null ? 0 : this.name.hashCode());
        n3 = 31 * n3 + (this.unit == null ? 0 : this.unit.hashCode());
        n3 = 31 * n3 + Double.hashCode(this.getMin());
        n3 = 31 * n3 + Double.hashCode(this.getMax());
        return n3;
    }

    @Override
    public final boolean set(String string, String ... stringArray) {
        boolean bl2 = !DefaultAxisDescription.strEqual(this.name, string);
        this.name = string;
        if (stringArray.length > 0 && !DefaultAxisDescription.strEqual(this.unit, stringArray[0])) {
            this.unit = stringArray[0];
            bl2 = true;
            if (stringArray.length > 1) {
                throw new IllegalArgumentException("more than one unit is not allowed");
            }
        }
        if (bl2) {
            this.notifyNameChanged.run();
        }
        return false;
    }

    @Override
    public final boolean set(String string, String string2, double d2, double d3) {
        boolean bl2 = this.set(d2, d3);
        boolean bl3 = this.set(string, string2);
        return bl2 || bl3;
    }

    @Override
    public boolean add(double d2) {
        if (!super.add(d2)) {
            return false;
        }
        this.notifyRangeChanged.run();
        return true;
    }

    @Override
    public boolean setMax(double d2) {
        if (!super.setMax(d2)) {
            return false;
        }
        if (this.notifyRangeChanged != null) {
            this.notifyRangeChanged.run();
        }
        return true;
    }

    @Override
    public boolean setMin(double d2) {
        if (!super.setMin(d2)) {
            return false;
        }
        if (this.notifyRangeChanged != null) {
            this.notifyRangeChanged.run();
        }
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + ", axisName = '" + this.getName() + "', axisUnit = '" + this.getUnit() + "'";
    }

    @Override
    public BitState getBitState() {
        return this.state;
    }

    private String updateMessage() {
        return "updated axis range for '" + this.name + "' '[" + this.unit + "]'";
    }

    private static boolean strEqual(String string, String string2) {
        return Objects.equals(string, string2);
    }
}

