/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.marchingsquares;

import io.fair_acc.chartfx.renderer.spi.marchingsquares.Cell;
import io.fair_acc.chartfx.renderer.spi.marchingsquares.GeneralPath;
import io.fair_acc.chartfx.renderer.spi.marchingsquares.Grid;
import io.fair_acc.chartfx.renderer.spi.marchingsquares.PathGenerator;
import io.fair_acc.dataset.utils.CachedDaemonThreadFactory;
import io.fair_acc.dataset.utils.ProcessingProfiler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class MarchingSquares {
    private static final ExecutorService ES = Executors.newCachedThreadPool(CachedDaemonThreadFactory.getInstance());
    private double[] isovalues;

    public GeneralPath[] buildContours(double[][] dArray, double[] dArray2) throws InterruptedException, ExecutionException {
        long l2 = ProcessingProfiler.getTimeStamp();
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                double d4 = dArray[i2][i3];
                d2 = Math.min(d2, d4);
                d3 = Math.max(d3, d4);
            }
        }
        this.isovalues = new double[dArray2.length];
        System.arraycopy(dArray2, 0, this.isovalues, 0, dArray2.length);
        GeneralPath[] generalPathArray = null;
        if (d2 == d3) {
            String string = "All values are equal. Cannot build contours for a constant field";
            throw new IllegalArgumentException("All values are equal. Cannot build contours for a constant field");
        }
        double d5 = d2 - 1.0;
        double[][] dArray3 = MarchingSquares.pad(dArray, d5);
        generalPathArray = this.doConcurrent(dArray3);
        ProcessingProfiler.getTimeDiff(l2, "built " + dArray2.length + " contours");
        return generalPathArray;
    }

    private GeneralPath[] doConcurrent(double[][] dArray) throws InterruptedException, ExecutionException {
        ArrayList<Task> arrayList = new ArrayList<Task>();
        for (int i2 = 0; i2 < this.isovalues.length; ++i2) {
            arrayList.add(new Task(i2, dArray, this.isovalues[i2]));
        }
        List list = ES.invokeAll(arrayList);
        GeneralPath[] generalPathArray = new GeneralPath[this.isovalues.length];
        for (Future future : list) {
            Result result = (Result)future.get();
            generalPathArray[result.ndx] = result.path;
        }
        return generalPathArray;
    }

    private static Grid contour(double[][] dArray, double d2) {
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        Cell[][] cellArray = new Cell[n2 - 1][n3 - 1];
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            for (int i3 = 0; i3 < n3 - 1; ++i3) {
                int n4 = 0;
                double d3 = dArray[i2 + 1][i3];
                double d4 = dArray[i2 + 1][i3 + 1];
                double d5 = dArray[i2][i3 + 1];
                double d6 = dArray[i2][i3];
                n4 |= d3 > d2 ? 0 : 8;
                n4 |= d4 > d2 ? 0 : 4;
                n4 |= d5 > d2 ? 0 : 2;
                int n5 = d6 > d2 ? 0 : 1;
                boolean bl2 = false;
                if ((n4 |= n5) == 5 || n4 == 10) {
                    double d7 = (d3 + d4 + d5 + d6) / 4.0;
                    if (n4 == 5 && d7 < d2) {
                        bl2 = true;
                    } else if (n4 == 10 && d7 < d2) {
                        bl2 = true;
                    }
                }
                if (n4 == 0 || n4 == 15) continue;
                float f2 = 0.5f;
                float f3 = 0.5f;
                float f4 = 0.5f;
                float f5 = 0.5f;
                switch (n4) {
                    case 1: 
                    case 14: {
                        f2 = (float)((d2 - d6) / (d3 - d6));
                        f5 = (float)((d2 - d6) / (d5 - d6));
                        break;
                    }
                    case 2: 
                    case 13: {
                        f5 = (float)((d2 - d6) / (d5 - d6));
                        f4 = (float)((d2 - d5) / (d4 - d5));
                        break;
                    }
                    case 3: 
                    case 12: {
                        f2 = (float)((d2 - d6) / (d3 - d6));
                        f4 = (float)((d2 - d5) / (d4 - d5));
                        break;
                    }
                    case 4: 
                    case 11: {
                        f3 = (float)((d2 - d3) / (d4 - d3));
                        f4 = (float)((d2 - d5) / (d4 - d5));
                        break;
                    }
                    case 5: 
                    case 10: {
                        f2 = (float)((d2 - d6) / (d3 - d6));
                        f5 = (float)((d2 - d6) / (d5 - d6));
                        f3 = (float)((d2 - d3) / (d4 - d3));
                        f4 = (float)((d2 - d5) / (d4 - d5));
                        break;
                    }
                    case 6: 
                    case 9: {
                        f5 = (float)((d2 - d6) / (d5 - d6));
                        f3 = (float)((d2 - d3) / (d4 - d3));
                        break;
                    }
                    case 7: 
                    case 8: {
                        f2 = (float)((d2 - d6) / (d3 - d6));
                        f3 = (float)((d2 - d3) / (d4 - d3));
                        break;
                    }
                    default: {
                        String string = "Unexpected cell index " + n4;
                        throw new IllegalStateException(string);
                    }
                }
                cellArray[i2][i3] = new Cell(n4, bl2, f2, f3, f4, f5);
            }
        }
        Grid grid = new Grid(cellArray, d2);
        return grid;
    }

    private static double[][] pad(double[][] dArray, double d2) {
        int n2;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        double[][] dArray2 = new double[n3 + 2][n4 + 2];
        for (n2 = 0; n2 < n4 + 2; ++n2) {
            dArray2[0][n2] = d2;
            dArray2[n3 + 1][n2] = d2;
        }
        for (n2 = 1; n2 < n3 + 1; ++n2) {
            dArray2[n2][0] = d2;
            dArray2[n2][n4 + 1] = d2;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            System.arraycopy(dArray[n2], 0, dArray2[n2 + 1], 1, n4);
        }
        return dArray2;
    }

    private static final class Task
    implements Callable<Result> {
        private final int ndx;
        private final double[][] data;
        private final double level;

        Task(int n2, double[][] dArray, double d2) {
            this.ndx = n2;
            this.data = dArray;
            this.level = d2;
        }

        @Override
        public Result call() throws Exception {
            GeneralPath generalPath = null;
            try {
                generalPath = new PathGenerator().generalPath(MarchingSquares.contour(this.data, this.level));
            }
            catch (Exception exception) {
                String string = "Failed making contour at index #" + this.ndx + " for level " + this.level + ": " + exception.getLocalizedMessage();
                throw new IllegalArgumentException(string, exception);
            }
            return new Result(this.ndx, generalPath);
        }
    }

    private static final class Result {
        private final int ndx;
        private final GeneralPath path;
        private String str;

        Result(int n2, GeneralPath generalPath) {
            this.ndx = n2;
            this.path = generalPath;
        }

        public String toString() {
            if (this.str == null) {
                this.str = "Result{ndx=" + this.ndx + ", bbox=}";
            }
            return this.str;
        }
    }
}

