/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.protocol;

import io.aeron.protocol.HeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;

public class NakFlyweight
extends HeaderFlyweight {
    public static final int HEADER_LENGTH = 28;
    private static final int SESSION_ID_FIELD_OFFSET = 8;
    private static final int STREAM_ID_FIELD_OFFSET = 12;
    private static final int TERM_ID_FIELD_OFFSET = 16;
    private static final int TERM_OFFSET_FIELD_OFFSET = 20;
    private static final int LENGTH_FIELD_OFFSET = 24;

    public NakFlyweight() {
    }

    public NakFlyweight(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public NakFlyweight(UnsafeBuffer unsafeBuffer) {
        super(unsafeBuffer);
    }

    public int sessionId() {
        return this.getInt(8, ByteOrder.LITTLE_ENDIAN);
    }

    public NakFlyweight sessionId(int n2) {
        this.putInt(8, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int streamId() {
        return this.getInt(12, ByteOrder.LITTLE_ENDIAN);
    }

    public NakFlyweight streamId(int n2) {
        this.putInt(12, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int termId() {
        return this.getInt(16, ByteOrder.LITTLE_ENDIAN);
    }

    public NakFlyweight termId(int n2) {
        this.putInt(16, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int termOffset() {
        return this.getInt(20, ByteOrder.LITTLE_ENDIAN);
    }

    public NakFlyweight termOffset(int n2) {
        this.putInt(20, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int length() {
        return this.getInt(24, ByteOrder.LITTLE_ENDIAN);
    }

    public NakFlyweight length(int n2) {
        this.putInt(24, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    @Override
    public String toString() {
        return "NAK{frame-length=" + this.frameLength() + " version=" + this.version() + " flags=" + String.valueOf(NakFlyweight.flagsToChars(this.flags())) + " type=" + this.headerType() + " term-offset=" + this.termOffset() + " session-id=" + this.sessionId() + " stream-id=" + this.streamId() + " term-id=" + this.termId() + " length=" + this.length() + "}";
    }
}

