/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class BufferClaim {
    private final UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);

    public void wrap(AtomicBuffer atomicBuffer, int n2, int n3) {
        this.buffer.wrap(atomicBuffer, n2, n3);
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return 32;
    }

    public int length() {
        return this.buffer.capacity() - 32;
    }

    public int headerType() {
        return this.buffer.getShort(6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public byte flags() {
        return this.buffer.getByte(5);
    }

    public BufferClaim flags(byte by2) {
        this.buffer.putByte(5, by2);
        return this;
    }

    public BufferClaim headerType(int n2) {
        this.buffer.putShort(6, (short)n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public long reservedValue() {
        return this.buffer.getLong(24, ByteOrder.LITTLE_ENDIAN);
    }

    public BufferClaim reservedValue(long l2) {
        this.buffer.putLong(24, l2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public BufferClaim putBytes(DirectBuffer directBuffer, int n2, int n3) {
        this.buffer.putBytes(32, directBuffer, n2, n3);
        return this;
    }

    public void commit() {
        int n2 = this.buffer.capacity();
        if (ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
            n2 = Integer.reverseBytes(n2);
        }
        this.buffer.putIntOrdered(0, n2);
    }

    public void abort() {
        int n2 = this.buffer.capacity();
        if (ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
            n2 = Integer.reverseBytes(n2);
        }
        this.buffer.putShort(6, (short)0, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putIntOrdered(0, n2);
    }
}

