/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.status.AtomicCounter;

final class AeronClient
implements DriverManagedResource {
    private final long clientId;
    private final long clientLivenessTimeoutMs;
    private boolean reachedEndOfLife = false;
    private boolean closedByCommand = false;
    private final AtomicCounter clientTimeouts;
    private final AtomicCounter heartbeatTimestamp;

    AeronClient(long l2, long l3, AtomicCounter atomicCounter, AtomicCounter atomicCounter2) {
        this.clientId = l2;
        this.clientLivenessTimeoutMs = Math.max(1L, TimeUnit.NANOSECONDS.toMillis(l3));
        this.clientTimeouts = atomicCounter;
        this.heartbeatTimestamp = atomicCounter2;
    }

    @Override
    public void close() {
        this.heartbeatTimestamp.close();
    }

    @Override
    public void onTimeEvent(long l2, long l3, DriverConductor driverConductor) {
        if (l3 > this.heartbeatTimestamp.get() + this.clientLivenessTimeoutMs) {
            this.reachedEndOfLife = true;
            if (!this.closedByCommand) {
                this.clientTimeouts.incrementOrdered();
                driverConductor.clientTimeout(this.clientId);
            }
            driverConductor.unavailableCounter(this.clientId, this.heartbeatTimestamp.id());
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    public String toString() {
        return "AeronClient{clientId=" + this.clientId + ", clientLivenessTimeoutMs=" + this.clientLivenessTimeoutMs + ", reachedEndOfLife=" + this.reachedEndOfLife + ", closedByCommand=" + this.closedByCommand + ", clientTimeouts=" + this.clientTimeouts + ", heartbeatTimestamp=" + this.heartbeatTimestamp + '}';
    }

    long clientId() {
        return this.clientId;
    }

    boolean hasTimedOut() {
        return this.reachedEndOfLife;
    }

    void timeOfLastKeepaliveMs(long l2) {
        this.heartbeatTimestamp.setOrdered(l2);
    }

    void onClosedByCommand() {
        this.closedByCommand = true;
        this.heartbeatTimestamp.setOrdered(0L);
    }
}

