/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.AbstractMinMulticastFlowControlRhsPadding;
import io.aeron.driver.FlowControl;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.status.FlowControlReceivers;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.SetupFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.util.Arrays;
import org.agrona.AsciiEncoding;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.SystemUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;

public abstract class AbstractMinMulticastFlowControl
extends AbstractMinMulticastFlowControlRhsPadding
implements FlowControl {
    static final Receiver[] EMPTY_RECEIVERS = new Receiver[0];
    private final boolean isGroupTagAware;
    private volatile boolean hasRequiredReceivers;
    private int groupMinSize;
    private long groupTag;
    private long receiverTimeoutNs;
    private Receiver[] receivers = EMPTY_RECEIVERS;
    private String channel;
    private AtomicCounter receiverCount;
    private ErrorHandler errorHandler;

    protected AbstractMinMulticastFlowControl(boolean bl2) {
        this.isGroupTagAware = bl2;
    }

    @Override
    public void initialize(MediaDriver.Context context, CountersManager countersManager, UdpChannel udpChannel, int n2, int n3, long l2, int n4, int n5) {
        this.receiverTimeoutNs = context.flowControlReceiverTimeoutNs();
        this.groupTag = this.isGroupTagAware ? context.flowControlGroupTag() : 0L;
        this.groupMinSize = context.flowControlGroupMinSize();
        this.channel = udpChannel.originalUriString();
        this.parseUriParam(udpChannel.channelUri().get("fc"));
        this.hasRequiredReceivers = this.receivers.length >= this.groupMinSize;
        this.errorHandler = context.errorHandler();
        this.receiverCount = FlowControlReceivers.allocate(context.tempBuffer(), countersManager, l2, n3, n2, this.channel);
        this.timeOfLastSetupNs = 0L;
        this.lastSetupSenderLimit = -1L;
    }

    @Override
    public void close() {
        CloseHelper.close(this.errorHandler, this.receiverCount);
    }

    @Override
    public long onSetup(SetupFlyweight setupFlyweight, long l2, long l3, int n2, long l4) {
        if (this.receivers.length > 0) {
            this.timeOfLastSetupNs = l4;
            this.lastSetupSenderLimit = l2;
        }
        return l2;
    }

    @Override
    public long onIdle(long l2, long l3, long l4, boolean bl2) {
        int n2;
        long l5 = this.lastSetupSenderLimit(l2);
        int n3 = 0;
        Receiver[] receiverArray = this.receivers;
        for (int i2 = n2 = receiverArray.length - 1; i2 >= 0; --i2) {
            Receiver receiver = receiverArray[i2];
            if (receiver.timeOfLastStatusMessageNs + this.receiverTimeoutNs - l2 < 0L || receiver.eosFlagged) {
                if (i2 != n2) {
                    receiverArray[i2] = receiverArray[n2--];
                }
                this.receiverRemoved(receiver.receiverId, receiver.sessionId, receiver.streamId, this.channel, receiverArray.length - ++n3);
                continue;
            }
            l5 = Math.min(l5, receiver.lastPositionPlusWindow);
        }
        if (n3 > 0) {
            this.hasRequiredReceivers = (receiverArray = AbstractMinMulticastFlowControl.truncateReceivers(receiverArray, n3)).length >= this.groupMinSize;
            this.receivers = receiverArray;
            this.receiverCount.setOrdered(receiverArray.length);
        }
        return receiverArray.length < this.groupMinSize || receiverArray.length == 0 ? l3 : l5;
    }

    @Override
    public boolean hasRequiredReceivers() {
        return this.hasRequiredReceivers;
    }

    protected final long processStatusMessage(StatusMessageFlyweight statusMessageFlyweight, long l2, int n2, int n3, long l3, boolean bl2) {
        Receiver[] receiverArray;
        long l4 = LogBufferDescriptor.computePosition(statusMessageFlyweight.consumptionTermId(), statusMessageFlyweight.consumptionTermOffset(), n3, n2);
        long l5 = statusMessageFlyweight.receiverWindowLength();
        long l6 = statusMessageFlyweight.receiverId();
        long l7 = l4 + l5;
        boolean bl3 = 64 == (statusMessageFlyweight.flags() & 0x40);
        boolean bl4 = false;
        long l8 = this.lastSetupSenderLimit(l3);
        for (Receiver receiver : receiverArray = this.receivers) {
            if (bl2 && l6 == receiver.receiverId) {
                receiver.eosFlagged = bl3;
                receiver.lastPosition = Math.max(l4, receiver.lastPosition);
                receiver.lastPositionPlusWindow = l7;
                receiver.timeOfLastStatusMessageNs = l3;
                bl4 = true;
            }
            l8 = Math.min(l8, receiver.lastPositionPlusWindow);
        }
        if (!(bl4 || bl3 || !bl2 || 0 != receiverArray.length && l7 < l8 - l5)) {
            Receiver receiver = new Receiver(l6, statusMessageFlyweight.sessionId(), statusMessageFlyweight.streamId(), l4, l7, l3);
            this.hasRequiredReceivers = (receiverArray = ArrayUtil.add(receiverArray, receiver)).length >= this.groupMinSize;
            this.receivers = receiverArray;
            l8 = Math.min(l8, l7);
            this.receiverAdded(receiver.receiverId, receiver.sessionId, receiver.streamId, this.channel, receiverArray.length);
            this.receiverCount.setOrdered(receiverArray.length);
            this.lastSetupSenderLimit = -1L;
        }
        if (receiverArray.length < this.groupMinSize) {
            return l2;
        }
        if (0 == receiverArray.length) {
            return Math.max(l2, l7);
        }
        return Math.max(l2, l8);
    }

    protected final long receiverTimeoutNs() {
        return this.receiverTimeoutNs;
    }

    protected final boolean hasGroupTag() {
        return this.isGroupTagAware;
    }

    protected final long groupTag() {
        return this.groupTag;
    }

    protected final int groupMinSize() {
        return this.groupMinSize;
    }

    static Receiver[] truncateReceivers(Receiver[] receiverArray, int n2) {
        int n3 = receiverArray.length;
        int n4 = n3 - n2;
        if (0 == n4) {
            return EMPTY_RECEIVERS;
        }
        return Arrays.copyOf(receiverArray, n4);
    }

    private void parseUriParam(String string) {
        if (null != string) {
            for (String string2 : string.split(",")) {
                if (string2.startsWith("t:")) {
                    this.receiverTimeoutNs = SystemUtil.parseDuration("fc receiver timeout", string2.substring(2));
                    continue;
                }
                if (!string2.startsWith("g:")) continue;
                int n2 = string2.indexOf(47);
                if (2 != n2 && this.isGroupTagAware) {
                    int n3 = -1 == n2 ? string2.length() - 2 : n2 - 2;
                    this.groupTag = AsciiEncoding.parseLongAscii(string2, 2, n3);
                }
                if (-1 == n2) continue;
                this.groupMinSize = AsciiEncoding.parseIntAscii(string2, n2 + 1, string2.length() - (n2 + 1));
            }
        }
    }

    private void receiverAdded(long l2, int n2, int n3, String string, int n4) {
    }

    private void receiverRemoved(long l2, int n2, int n3, String string, int n4) {
    }

    private long lastSetupSenderLimit(long l2) {
        if (-1L != this.lastSetupSenderLimit) {
            if (this.timeOfLastSetupNs + this.receiverTimeoutNs - l2 < 0L) {
                this.lastSetupSenderLimit = -1L;
            } else {
                return this.lastSetupSenderLimit;
            }
        }
        return Long.MAX_VALUE;
    }

    static final class Receiver {
        final int sessionId;
        final int streamId;
        final long receiverId;
        long lastPosition;
        long lastPositionPlusWindow;
        long timeOfLastStatusMessageNs;
        boolean eosFlagged;

        Receiver(long l2, int n2, int n3, long l3, long l4, long l5) {
            this.receiverId = l2;
            this.sessionId = n2;
            this.streamId = n3;
            this.lastPosition = l3;
            this.lastPositionPlusWindow = l4;
            this.timeOfLastStatusMessageNs = l5;
            this.eosFlagged = false;
        }
    }
}

