/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.AvailableImageHandler;
import io.aeron.ChannelUri;
import io.aeron.ClientConductor;
import io.aeron.Image;
import io.aeron.SubscriptionFields;
import io.aeron.UnavailableImageHandler;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.BlockHandler;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.RawBlockHandler;
import io.aeron.status.LocalSocketAddressStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.agrona.collections.ArrayUtil;

public final class Subscription
extends SubscriptionFields
implements AutoCloseable {
    byte p064;
    byte p065;
    byte p066;
    byte p067;
    byte p068;
    byte p069;
    byte p070;
    byte p071;
    byte p072;
    byte p073;
    byte p074;
    byte p075;
    byte p076;
    byte p077;
    byte p078;
    byte p079;
    byte p080;
    byte p081;
    byte p082;
    byte p083;
    byte p084;
    byte p085;
    byte p086;
    byte p087;
    byte p088;
    byte p089;
    byte p090;
    byte p091;
    byte p092;
    byte p093;
    byte p094;
    byte p095;
    byte p096;
    byte p097;
    byte p098;
    byte p099;
    byte p100;
    byte p101;
    byte p102;
    byte p103;
    byte p104;
    byte p105;
    byte p106;
    byte p107;
    byte p108;
    byte p109;
    byte p110;
    byte p111;
    byte p112;
    byte p113;
    byte p114;
    byte p115;
    byte p116;
    byte p117;
    byte p118;
    byte p119;
    byte p120;
    byte p121;
    byte p122;
    byte p123;
    byte p124;
    byte p125;
    byte p126;
    byte p127;

    Subscription(ClientConductor clientConductor, String string, int n2, long l2, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        super(l2, n2, clientConductor, string, availableImageHandler, unavailableImageHandler);
    }

    public String channel() {
        return this.channel;
    }

    public int streamId() {
        return this.streamId;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public AvailableImageHandler availableImageHandler() {
        return this.availableImageHandler;
    }

    public UnavailableImageHandler unavailableImageHandler() {
        return this.unavailableImageHandler;
    }

    public int poll(FragmentHandler fragmentHandler, int n2) {
        int n3;
        int n4;
        Image[] imageArray = this.images;
        int n5 = imageArray.length;
        int n6 = 0;
        if ((n4 = this.roundRobinIndex++) >= n5) {
            n4 = 0;
            this.roundRobinIndex = 0;
        }
        for (n3 = n4; n3 < n5 && n6 < n2; n6 += imageArray[n3].poll(fragmentHandler, n2 - n6), ++n3) {
        }
        for (n3 = 0; n3 < n4 && n6 < n2; n6 += imageArray[n3].poll(fragmentHandler, n2 - n6), ++n3) {
        }
        return n6;
    }

    public int controlledPoll(ControlledFragmentHandler controlledFragmentHandler, int n2) {
        int n3;
        int n4;
        Image[] imageArray = this.images;
        int n5 = imageArray.length;
        int n6 = 0;
        if ((n4 = this.roundRobinIndex++) >= n5) {
            n4 = 0;
            this.roundRobinIndex = 0;
        }
        for (n3 = n4; n3 < n5 && n6 < n2; n6 += imageArray[n3].controlledPoll(controlledFragmentHandler, n2 - n6), ++n3) {
        }
        for (n3 = 0; n3 < n4 && n6 < n2; n6 += imageArray[n3].controlledPoll(controlledFragmentHandler, n2 - n6), ++n3) {
        }
        return n6;
    }

    public long blockPoll(BlockHandler blockHandler, int n2) {
        long l2 = 0L;
        for (Image image : this.images) {
            l2 += (long)image.blockPoll(blockHandler, n2);
        }
        return l2;
    }

    public long rawPoll(RawBlockHandler rawBlockHandler, int n2) {
        long l2 = 0L;
        for (Image image : this.images) {
            l2 += (long)image.rawPoll(rawBlockHandler, n2);
        }
        return l2;
    }

    public boolean isConnected() {
        for (Image image : this.images) {
            if (image.isClosed()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNoImages() {
        return this.images.length == 0;
    }

    public int imageCount() {
        return this.images.length;
    }

    public Image imageBySessionId(int n2) {
        Image image = null;
        for (Image image2 : this.images) {
            if (n2 != image2.sessionId()) continue;
            image = image2;
            break;
        }
        return image;
    }

    public Image imageAtIndex(int n2) {
        return this.images[n2];
    }

    public List<Image> images() {
        return Collections.unmodifiableList(Arrays.asList(this.images));
    }

    public void forEachImage(Consumer<Image> consumer) {
        for (Image image : this.images) {
            consumer.accept(image);
        }
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.conductor.removeSubscription(this);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public long channelStatus() {
        if (this.isClosed) {
            return -1L;
        }
        return this.conductor.channelStatus(this.channelStatusId);
    }

    public int channelStatusId() {
        return this.channelStatusId;
    }

    public List<String> localSocketAddresses() {
        return LocalSocketAddressStatus.findAddresses(this.conductor.countersReader(), this.channelStatus(), this.channelStatusId);
    }

    public void addDestination(String string) {
        if (this.isClosed) {
            throw new AeronException("Subscription is closed");
        }
        this.conductor.addRcvDestination(this.registrationId, string);
    }

    public void removeDestination(String string) {
        if (this.isClosed) {
            throw new AeronException("Subscription is closed");
        }
        this.conductor.removeRcvDestination(this.registrationId, string);
    }

    public long asyncAddDestination(String string) {
        if (this.isClosed) {
            throw new AeronException("Subscription is closed");
        }
        return this.conductor.asyncAddRcvDestination(this.registrationId, string);
    }

    public long asyncRemoveDestination(String string) {
        if (this.isClosed) {
            throw new AeronException("Subscription is closed");
        }
        return this.conductor.asyncRemoveRcvDestination(this.registrationId, string);
    }

    public String tryResolveChannelEndpointPort() {
        long l2 = this.channelStatus();
        if (1L == l2) {
            ChannelUri channelUri;
            String string;
            List<String> list = LocalSocketAddressStatus.findAddresses(this.conductor.countersReader(), l2, this.channelStatusId);
            if (1 == list.size() && null != (string = (channelUri = ChannelUri.parse(this.channel)).get("endpoint")) && string.endsWith(":0")) {
                channelUri.replaceEndpointWildcardPort(list.get(0));
                return channelUri.toString();
            }
            return this.channel;
        }
        return null;
    }

    public String resolvedEndpoint() {
        return LocalSocketAddressStatus.findAddress(this.conductor.countersReader(), this.channelStatus(), this.channelStatusId);
    }

    void channelStatusId(int n2) {
        this.channelStatusId = n2;
    }

    void internalClose(long l2) {
        Image[] imageArray = this.images;
        this.images = EMPTY_IMAGES;
        this.isClosed = true;
        this.conductor.closeImages(imageArray, this.unavailableImageHandler, l2);
    }

    void addImage(Image image) {
        this.images = ArrayUtil.add(this.images, image);
    }

    Image removeImage(long l2) {
        Image[] imageArray = this.images;
        Image image = null;
        int n2 = 0;
        for (Image image2 : imageArray) {
            if (image2.correlationId() == l2) {
                image = image2;
                break;
            }
            ++n2;
        }
        if (null != image) {
            image.close();
            this.images = imageArray.length == 1 ? EMPTY_IMAGES : ArrayUtil.remove(imageArray, n2);
            this.conductor.releaseLogBuffers(image.logBuffers(), l2, -1L);
        }
        return image;
    }

    public String toString() {
        return "Subscription{registrationId=" + this.registrationId + ", isClosed=" + this.isClosed + ", streamId=" + this.streamId + ", channel='" + this.channel + '\'' + ", localSocketAddresses=" + this.localSocketAddresses() + ", imageCount=" + this.imageCount() + '}';
    }
}

