/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.exceptions.AeronException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.SemanticVersion;
import org.agrona.concurrent.UnsafeBuffer;

public class CncFileDescriptor {
    public static final String CNC_FILE = "cnc.dat";
    public static final int CNC_VERSION = SemanticVersion.compose(0, 2, 0);
    public static final int CNC_VERSION_FIELD_OFFSET = 0;
    public static final int TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET = CNC_VERSION_FIELD_OFFSET + 4;
    public static final int TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET = TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET + 4;
    public static final int COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET = TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET + 4;
    public static final int COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET = COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET + 4;
    public static final int CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET;
    public static final int ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET;
    public static final int START_TIMESTAMP_FIELD_OFFSET;
    public static final int PID_FIELD_OFFSET;
    public static final int META_DATA_LENGTH;
    public static final int END_OF_METADATA_OFFSET;

    public static int computeCncFileLength(int n2, int n3) {
        return BitUtil.align(END_OF_METADATA_OFFSET + n2, n3);
    }

    public static int cncVersionOffset(int n2) {
        return n2 + CNC_VERSION_FIELD_OFFSET;
    }

    public static int toDriverBufferLengthOffset(int n2) {
        return n2 + TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET;
    }

    public static int toClientsBufferLengthOffset(int n2) {
        return n2 + TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET;
    }

    public static int countersMetaDataBufferLengthOffset(int n2) {
        return n2 + COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET;
    }

    public static int countersValuesBufferLengthOffset(int n2) {
        return n2 + COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET;
    }

    public static int clientLivenessTimeoutOffset(int n2) {
        return n2 + CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET;
    }

    public static int errorLogBufferLengthOffset(int n2) {
        return n2 + ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET;
    }

    public static int startTimestampOffset(int n2) {
        return n2 + START_TIMESTAMP_FIELD_OFFSET;
    }

    public static int pidOffset(int n2) {
        return n2 + PID_FIELD_OFFSET;
    }

    public static void fillMetaData(UnsafeBuffer unsafeBuffer, int n2, int n3, int n4, int n5, long l2, int n6, long l3, long l4) {
        unsafeBuffer.putInt(TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET, n2);
        unsafeBuffer.putInt(TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET, n3);
        unsafeBuffer.putInt(COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET, n4);
        unsafeBuffer.putInt(COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET, n5);
        unsafeBuffer.putInt(ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET, n6);
        unsafeBuffer.putLong(CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET, l2);
        unsafeBuffer.putLong(START_TIMESTAMP_FIELD_OFFSET, l3);
        unsafeBuffer.putLong(PID_FIELD_OFFSET, l4);
    }

    public static void signalCncReady(UnsafeBuffer unsafeBuffer) {
        unsafeBuffer.putIntVolatile(CncFileDescriptor.cncVersionOffset(0), CNC_VERSION);
    }

    public static UnsafeBuffer createMetaDataBuffer(ByteBuffer byteBuffer) {
        return new UnsafeBuffer(byteBuffer, 0, META_DATA_LENGTH);
    }

    public static UnsafeBuffer createToDriverBuffer(ByteBuffer byteBuffer, DirectBuffer directBuffer) {
        return new UnsafeBuffer(byteBuffer, END_OF_METADATA_OFFSET, directBuffer.getInt(CncFileDescriptor.toDriverBufferLengthOffset(0)));
    }

    public static UnsafeBuffer createToClientsBuffer(ByteBuffer byteBuffer, DirectBuffer directBuffer) {
        int n2 = END_OF_METADATA_OFFSET + directBuffer.getInt(CncFileDescriptor.toDriverBufferLengthOffset(0));
        return new UnsafeBuffer(byteBuffer, n2, directBuffer.getInt(CncFileDescriptor.toClientsBufferLengthOffset(0)));
    }

    public static UnsafeBuffer createCountersMetaDataBuffer(ByteBuffer byteBuffer, DirectBuffer directBuffer) {
        int n2 = END_OF_METADATA_OFFSET + directBuffer.getInt(CncFileDescriptor.toDriverBufferLengthOffset(0)) + directBuffer.getInt(CncFileDescriptor.toClientsBufferLengthOffset(0));
        return new UnsafeBuffer(byteBuffer, n2, directBuffer.getInt(CncFileDescriptor.countersMetaDataBufferLengthOffset(0)));
    }

    public static UnsafeBuffer createCountersValuesBuffer(ByteBuffer byteBuffer, DirectBuffer directBuffer) {
        int n2 = END_OF_METADATA_OFFSET + directBuffer.getInt(CncFileDescriptor.toDriverBufferLengthOffset(0)) + directBuffer.getInt(CncFileDescriptor.toClientsBufferLengthOffset(0)) + directBuffer.getInt(CncFileDescriptor.countersMetaDataBufferLengthOffset(0));
        return new UnsafeBuffer(byteBuffer, n2, directBuffer.getInt(CncFileDescriptor.countersValuesBufferLengthOffset(0)));
    }

    public static UnsafeBuffer createErrorLogBuffer(ByteBuffer byteBuffer, DirectBuffer directBuffer) {
        int n2 = END_OF_METADATA_OFFSET + directBuffer.getInt(CncFileDescriptor.toDriverBufferLengthOffset(0)) + directBuffer.getInt(CncFileDescriptor.toClientsBufferLengthOffset(0)) + directBuffer.getInt(CncFileDescriptor.countersMetaDataBufferLengthOffset(0)) + directBuffer.getInt(CncFileDescriptor.countersValuesBufferLengthOffset(0));
        return new UnsafeBuffer(byteBuffer, n2, directBuffer.getInt(CncFileDescriptor.errorLogBufferLengthOffset(0)));
    }

    public static long clientLivenessTimeoutNs(DirectBuffer directBuffer) {
        return directBuffer.getLong(CncFileDescriptor.clientLivenessTimeoutOffset(0));
    }

    public static long startTimestampMs(DirectBuffer directBuffer) {
        return directBuffer.getLong(CncFileDescriptor.startTimestampOffset(0));
    }

    public static long pid(DirectBuffer directBuffer) {
        return directBuffer.getLong(CncFileDescriptor.pidOffset(0));
    }

    public static void checkVersion(int n2) {
        if (SemanticVersion.major(CNC_VERSION) != SemanticVersion.major(n2)) {
            throw new AeronException("CnC version not compatible: app=" + SemanticVersion.toString(CNC_VERSION) + " file=" + SemanticVersion.toString(n2));
        }
    }

    public static boolean isCncFileLengthSufficient(DirectBuffer directBuffer, int n2) {
        int n3 = END_OF_METADATA_OFFSET + directBuffer.getInt(TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET) + directBuffer.getInt(TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET) + directBuffer.getInt(COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET) + directBuffer.getInt(COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET) + directBuffer.getInt(ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET);
        return n2 >= n3;
    }

    public static boolean isCncFile(Path path, BasicFileAttributes basicFileAttributes) {
        return path.getFileName().toString().equals(CNC_FILE);
    }

    static {
        ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET = COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET + 4;
        CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET = ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET + 4;
        START_TIMESTAMP_FIELD_OFFSET = CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET + 8;
        PID_FIELD_OFFSET = START_TIMESTAMP_FIELD_OFFSET + 8;
        META_DATA_LENGTH = PID_FIELD_OFFSET + 8;
        END_OF_METADATA_OFFSET = BitUtil.align(META_DATA_LENGTH, 128);
    }
}

