/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ChannelUri;
import io.aeron.logbuffer.LogBufferDescriptor;
import org.agrona.SystemUtil;

public final class ChannelUriStringBuilder {
    public static final String TAG_PREFIX = "tag:";
    private final StringBuilder sb = new StringBuilder(64);
    private String prefix;
    private String media;
    private String endpoint;
    private String networkInterface;
    private String controlEndpoint;
    private String controlMode;
    private String tags;
    private String alias;
    private String cc;
    private String fc;
    private Boolean reliable;
    private Integer ttl;
    private Integer mtu;
    private Integer termLength;
    private Integer initialTermId;
    private Integer termId;
    private Integer termOffset;
    private Long sessionId;
    private Long groupTag;
    private Long linger;
    private Boolean sparse;
    private Boolean eos;
    private Boolean tether;
    private Boolean group;
    private Boolean rejoin;
    private Boolean ssc;
    private boolean isSessionIdTagged;
    private Integer socketSndbufLength;
    private Integer socketRcvbufLength;
    private Integer receiverWindowLength;
    private String mediaReceiveTimestampOffset;
    private String channelReceiveTimestampOffset;
    private String channelSendTimestampOffset;

    public ChannelUriStringBuilder() {
    }

    public ChannelUriStringBuilder(String string) {
        this(ChannelUri.parse(string));
    }

    public ChannelUriStringBuilder(ChannelUri channelUri) {
        this.isSessionIdTagged = false;
        this.prefix(channelUri);
        this.media(channelUri);
        this.endpoint(channelUri);
        this.networkInterface(channelUri);
        this.controlEndpoint(channelUri);
        this.controlMode(channelUri);
        this.tags(channelUri);
        this.alias(channelUri);
        this.congestionControl(channelUri);
        this.flowControl(channelUri);
        this.reliable(channelUri);
        this.ttl(channelUri);
        this.mtu(channelUri);
        this.termLength(channelUri);
        this.initialTermId(channelUri);
        this.termId(channelUri);
        this.termOffset(channelUri);
        this.sessionId(channelUri);
        this.group(channelUri);
        this.linger(channelUri);
        this.sparse(channelUri);
        this.eos(channelUri);
        this.tether(channelUri);
        this.groupTag(channelUri);
        this.rejoin(channelUri);
        this.spiesSimulateConnection(channelUri);
        this.socketRcvbufLength(channelUri);
        this.socketSndbufLength(channelUri);
        this.receiverWindowLength(channelUri);
        this.mediaReceiveTimestampOffset(channelUri);
        this.channelReceiveTimestampOffset(channelUri);
        this.channelSendTimestampOffset(channelUri);
    }

    public ChannelUriStringBuilder clear() {
        this.prefix = null;
        this.media = null;
        this.endpoint = null;
        this.networkInterface = null;
        this.controlEndpoint = null;
        this.controlMode = null;
        this.tags = null;
        this.alias = null;
        this.cc = null;
        this.fc = null;
        this.reliable = null;
        this.ttl = null;
        this.mtu = null;
        this.termLength = null;
        this.initialTermId = null;
        this.termId = null;
        this.termOffset = null;
        this.sessionId = null;
        this.groupTag = null;
        this.linger = null;
        this.sparse = null;
        this.eos = null;
        this.tether = null;
        this.group = null;
        this.rejoin = null;
        this.isSessionIdTagged = false;
        this.socketRcvbufLength = null;
        this.socketSndbufLength = null;
        this.receiverWindowLength = null;
        this.mediaReceiveTimestampOffset = null;
        this.channelReceiveTimestampOffset = null;
        this.channelSendTimestampOffset = null;
        return this;
    }

    public ChannelUriStringBuilder validate() {
        boolean bl2;
        if (null == this.media) {
            throw new IllegalStateException("media type is mandatory");
        }
        if ("udp".equals(this.media) && null == this.endpoint && null == this.controlEndpoint) {
            throw new IllegalStateException("either 'endpoint' or 'control' must be specified for UDP.");
        }
        boolean bl3 = null != this.initialTermId || null != this.termId || null != this.termOffset;
        boolean bl4 = bl2 = null == this.initialTermId || null == this.termId || null == this.termOffset;
        if (bl3) {
            if (bl2) {
                throw new IllegalStateException("either all or none of the parameters ['initialTermId', 'termId', 'termOffset'] must be provided");
            }
            if (this.termId - this.initialTermId < 0) {
                throw new IllegalStateException("difference greater than 2^31 - 1: termId=" + this.termId + " - initialTermId=" + this.initialTermId);
            }
            if (null != this.termLength && this.termOffset > this.termLength) {
                throw new IllegalStateException("termOffset=" + this.termOffset + " > termLength=" + this.termLength);
            }
        }
        return this;
    }

    public ChannelUriStringBuilder prefix(String string) {
        if (null != string && !string.isEmpty() && !string.equals("aeron-spy")) {
            throw new IllegalArgumentException("invalid prefix: " + string);
        }
        this.prefix = string;
        return this;
    }

    public ChannelUriStringBuilder prefix(ChannelUri channelUri) {
        return this.prefix(channelUri.prefix());
    }

    public String prefix() {
        return this.prefix;
    }

    public ChannelUriStringBuilder media(String string) {
        switch (string) {
            case "udp": 
            case "ipc": {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid media: " + string);
            }
        }
        this.media = string;
        return this;
    }

    public ChannelUriStringBuilder media(ChannelUri channelUri) {
        return this.media(channelUri.media());
    }

    public String media() {
        return this.media;
    }

    public ChannelUriStringBuilder endpoint(String string) {
        this.endpoint = string;
        return this;
    }

    public ChannelUriStringBuilder endpoint(ChannelUri channelUri) {
        return this.endpoint(channelUri.get("endpoint"));
    }

    public String endpoint() {
        return this.endpoint;
    }

    public ChannelUriStringBuilder networkInterface(String string) {
        this.networkInterface = string;
        return this;
    }

    public ChannelUriStringBuilder networkInterface(ChannelUri channelUri) {
        return this.networkInterface(channelUri.get("interface"));
    }

    public String networkInterface() {
        return this.networkInterface;
    }

    public ChannelUriStringBuilder controlEndpoint(String string) {
        this.controlEndpoint = string;
        return this;
    }

    public ChannelUriStringBuilder controlEndpoint(ChannelUri channelUri) {
        return this.controlEndpoint(channelUri.get("control"));
    }

    public String controlEndpoint() {
        return this.controlEndpoint;
    }

    public ChannelUriStringBuilder controlMode(String string) {
        if (null != string && !string.equals("manual") && !string.equals("dynamic")) {
            throw new IllegalArgumentException("invalid control mode: " + string);
        }
        this.controlMode = string;
        return this;
    }

    public ChannelUriStringBuilder controlMode(ChannelUri channelUri) {
        return this.controlMode(channelUri.get("control-mode"));
    }

    public String controlMode() {
        return this.controlMode;
    }

    public ChannelUriStringBuilder reliable(Boolean bl2) {
        this.reliable = bl2;
        return this;
    }

    public ChannelUriStringBuilder reliable(ChannelUri channelUri) {
        String string = channelUri.get("reliable");
        if (null == string) {
            this.reliable = null;
            return this;
        }
        return this.reliable(Boolean.valueOf(string));
    }

    public Boolean reliable() {
        return this.reliable;
    }

    public ChannelUriStringBuilder ttl(Integer n2) {
        if (null != n2 && (n2 < 0 || n2 > 255)) {
            throw new IllegalArgumentException("TTL not in range 0-255: " + n2);
        }
        this.ttl = n2;
        return this;
    }

    public ChannelUriStringBuilder ttl(ChannelUri channelUri) {
        String string = channelUri.get("ttl");
        if (null == string) {
            this.ttl = null;
            return this;
        }
        try {
            return this.ttl(Integer.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'ttl' must be a value integer", numberFormatException);
        }
    }

    public Integer ttl() {
        return this.ttl;
    }

    public ChannelUriStringBuilder mtu(Integer n2) {
        if (null != n2) {
            if (n2 < 32 || n2 > 65504) {
                throw new IllegalArgumentException("MTU not in range 32-65504: " + n2);
            }
            if ((n2 & 0x1F) != 0) {
                throw new IllegalArgumentException("MTU not a multiple of FRAME_ALIGNMENT: mtu=" + n2);
            }
        }
        this.mtu = n2;
        return this;
    }

    public ChannelUriStringBuilder mtu(ChannelUri channelUri) {
        String string = channelUri.get("mtu");
        if (null == string) {
            this.mtu = null;
            return this;
        }
        long l2 = SystemUtil.parseSize("mtu", string);
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalStateException("mtu " + l2 + " > " + Integer.MAX_VALUE);
        }
        return this.mtu((int)l2);
    }

    public Integer mtu() {
        return this.mtu;
    }

    public ChannelUriStringBuilder termLength(Integer n2) {
        if (null != n2) {
            LogBufferDescriptor.checkTermLength(n2);
        }
        this.termLength = n2;
        return this;
    }

    public ChannelUriStringBuilder termLength(ChannelUri channelUri) {
        String string = channelUri.get("term-length");
        if (null == string) {
            this.termLength = null;
            return this;
        }
        long l2 = SystemUtil.parseSize("term-length", string);
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalStateException("term length more than max length of 1073741824: value=" + l2);
        }
        return this.termLength((int)l2);
    }

    public Integer termLength() {
        return this.termLength;
    }

    public ChannelUriStringBuilder initialTermId(Integer n2) {
        this.initialTermId = n2;
        return this;
    }

    public ChannelUriStringBuilder initialTermId(ChannelUri channelUri) {
        String string = channelUri.get("init-term-id");
        if (null == string) {
            this.initialTermId = null;
            return this;
        }
        try {
            return this.initialTermId(Integer.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'initial-term-id' must be a valid integer", numberFormatException);
        }
    }

    public Integer initialTermId() {
        return this.initialTermId;
    }

    public ChannelUriStringBuilder termId(Integer n2) {
        this.termId = n2;
        return this;
    }

    public ChannelUriStringBuilder termId(ChannelUri channelUri) {
        String string = channelUri.get("term-id");
        if (null == string) {
            this.termId = null;
            return this;
        }
        try {
            return this.termId(Integer.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'term-id' must be a valid integer", numberFormatException);
        }
    }

    public Integer termId() {
        return this.termId;
    }

    public ChannelUriStringBuilder termOffset(Integer n2) {
        if (null != n2) {
            if (n2 < 0 || n2 > 0x40000000) {
                throw new IllegalArgumentException("term offset not in range 0-1g: " + n2);
            }
            if (0 != (n2 & 0x1F)) {
                throw new IllegalArgumentException("term offset not multiple of FRAME_ALIGNMENT: " + n2);
            }
        }
        this.termOffset = n2;
        return this;
    }

    public ChannelUriStringBuilder termOffset(ChannelUri channelUri) {
        String string = channelUri.get("term-offset");
        if (null == string) {
            this.termOffset = null;
            return this;
        }
        try {
            return this.termOffset(Integer.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'term-offset' must be a valid integer", numberFormatException);
        }
    }

    public Integer termOffset() {
        return this.termOffset;
    }

    public ChannelUriStringBuilder sessionId(Integer n2) {
        this.sessionId = null != n2 ? Long.valueOf(n2.longValue()) : null;
        return this;
    }

    public ChannelUriStringBuilder sessionId(String string) {
        if (null != string) {
            if (ChannelUri.isTagged(string)) {
                this.taggedSessionId(ChannelUri.getTag(string));
            } else {
                this.isSessionIdTagged(false);
                try {
                    this.sessionId(Integer.valueOf(string));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("'session-id' must be a valid integer", numberFormatException);
                }
            }
        } else {
            this.sessionId((Integer)null);
        }
        return this;
    }

    public ChannelUriStringBuilder taggedSessionId(Long l2) {
        this.isSessionIdTagged(true);
        this.sessionId = l2;
        return this;
    }

    public ChannelUriStringBuilder sessionId(ChannelUri channelUri) {
        return this.sessionId(channelUri.get("session-id"));
    }

    @Deprecated
    public Integer sessionId() {
        return null != this.sessionId ? Integer.valueOf(this.sessionId.intValue()) : null;
    }

    public ChannelUriStringBuilder linger(Long l2) {
        if (null != l2 && l2 < 0L) {
            throw new IllegalArgumentException("linger value cannot be negative: " + l2);
        }
        this.linger = l2;
        return this;
    }

    public ChannelUriStringBuilder linger(ChannelUri channelUri) {
        String string = channelUri.get("linger");
        if (null == string) {
            this.linger = null;
            return this;
        }
        return this.linger(SystemUtil.parseDuration("linger", string));
    }

    public Long linger() {
        return this.linger;
    }

    public ChannelUriStringBuilder sparse(Boolean bl2) {
        this.sparse = bl2;
        return this;
    }

    public ChannelUriStringBuilder sparse(ChannelUri channelUri) {
        String string = channelUri.get("sparse");
        if (null == string) {
            this.sparse = null;
            return this;
        }
        return this.sparse(Boolean.valueOf(string));
    }

    public Boolean sparse() {
        return this.sparse;
    }

    public ChannelUriStringBuilder eos(Boolean bl2) {
        this.eos = bl2;
        return this;
    }

    public ChannelUriStringBuilder eos(ChannelUri channelUri) {
        String string = channelUri.get("eos");
        if (null == string) {
            this.eos = null;
            return this;
        }
        return this.eos(Boolean.valueOf(string));
    }

    public Boolean eos() {
        return this.eos;
    }

    public ChannelUriStringBuilder tether(Boolean bl2) {
        this.tether = bl2;
        return this;
    }

    public ChannelUriStringBuilder tether(ChannelUri channelUri) {
        String string = channelUri.get("tether");
        if (null == string) {
            this.tether = null;
            return this;
        }
        return this.tether(Boolean.valueOf(string));
    }

    public Boolean tether() {
        return this.tether;
    }

    public ChannelUriStringBuilder group(Boolean bl2) {
        this.group = bl2;
        return this;
    }

    public ChannelUriStringBuilder group(ChannelUri channelUri) {
        String string = channelUri.get("group");
        if (null == string) {
            this.group = null;
            return this;
        }
        return this.group(Boolean.valueOf(string));
    }

    public Boolean group() {
        return this.group;
    }

    public ChannelUriStringBuilder tags(String string) {
        this.tags = string;
        return this;
    }

    public ChannelUriStringBuilder tags(ChannelUri channelUri) {
        return this.tags(channelUri.get("tags"));
    }

    public ChannelUriStringBuilder tags(Long l2, Long l3) {
        if (null == l2 && null != l3) {
            throw new IllegalArgumentException("null == channelTag && null != pubSubTag");
        }
        if (null == l2) {
            return this.tags((String)null);
        }
        return this.tags(l2 + (null != l3 ? "," + l3 : ""));
    }

    public String tags() {
        return this.tags;
    }

    public ChannelUriStringBuilder isSessionIdTagged(boolean bl2) {
        this.isSessionIdTagged = bl2;
        return this;
    }

    public boolean isSessionIdTagged() {
        return this.isSessionIdTagged;
    }

    public ChannelUriStringBuilder alias(String string) {
        this.alias = string;
        return this;
    }

    public ChannelUriStringBuilder alias(ChannelUri channelUri) {
        return this.alias(channelUri.get("alias"));
    }

    public String alias() {
        return this.alias;
    }

    public ChannelUriStringBuilder congestionControl(String string) {
        this.cc = string;
        return this;
    }

    public ChannelUriStringBuilder congestionControl(ChannelUri channelUri) {
        return this.congestionControl(channelUri.get("cc"));
    }

    public String congestionControl() {
        return this.cc;
    }

    public ChannelUriStringBuilder flowControl(String string) {
        this.fc = string;
        return this;
    }

    public ChannelUriStringBuilder taggedFlowControl(Long l2, Integer n2, String string) {
        String string2 = "tagged";
        if (null != l2 || null != n2) {
            string2 = string2 + ",g:";
            if (null != l2) {
                string2 = string2 + l2;
            }
            if (null != n2) {
                string2 = string2 + "/" + n2;
            }
        }
        if (null != string) {
            string2 = string2 + ",t:" + string;
        }
        return this.flowControl(string2);
    }

    public ChannelUriStringBuilder minFlowControl(Integer n2, String string) {
        String string2 = "min";
        if (null != n2) {
            string2 = string2 + ",g:/" + n2;
        }
        if (null != string) {
            string2 = string2 + ",t:" + string;
        }
        return this.flowControl(string2);
    }

    public ChannelUriStringBuilder flowControl(ChannelUri channelUri) {
        return this.flowControl(channelUri.get("fc"));
    }

    public String flowControl() {
        return this.fc;
    }

    public ChannelUriStringBuilder groupTag(Long l2) {
        this.groupTag = l2;
        return this;
    }

    public ChannelUriStringBuilder groupTag(ChannelUri channelUri) {
        String string = channelUri.get("gtag");
        if (null == string) {
            this.groupTag = null;
            return this;
        }
        try {
            return this.groupTag(Long.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'gtag' must be a valid long value", numberFormatException);
        }
    }

    public Long groupTag() {
        return this.groupTag;
    }

    public ChannelUriStringBuilder rejoin(Boolean bl2) {
        this.rejoin = bl2;
        return this;
    }

    public ChannelUriStringBuilder rejoin(ChannelUri channelUri) {
        String string = channelUri.get("rejoin");
        if (null == string) {
            this.rejoin = null;
            return this;
        }
        return this.rejoin(Boolean.valueOf(string));
    }

    public Boolean rejoin() {
        return this.rejoin;
    }

    public ChannelUriStringBuilder spiesSimulateConnection(Boolean bl2) {
        this.ssc = bl2;
        return this;
    }

    public ChannelUriStringBuilder spiesSimulateConnection(ChannelUri channelUri) {
        String string = channelUri.get("ssc");
        if (null == string) {
            this.ssc = null;
            return this;
        }
        return this.spiesSimulateConnection(Boolean.valueOf(string));
    }

    public Boolean spiesSimulateConnection() {
        return this.ssc;
    }

    public ChannelUriStringBuilder initialPosition(long l2, int n2, int n3) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid position=" + l2 + " < 0");
        }
        if (0L != (l2 & 0x1FL)) {
            throw new IllegalArgumentException("invalid position=" + l2 + " does not have frame alignment=" + 32);
        }
        int n4 = LogBufferDescriptor.positionBitsToShift(n3);
        this.initialTermId = n2;
        this.termId = LogBufferDescriptor.computeTermIdFromPosition(l2, n4, n2);
        this.termOffset = (int)(l2 & (long)(n3 - 1));
        this.termLength = n3;
        return this;
    }

    public ChannelUriStringBuilder socketSndbufLength(Integer n2) {
        this.socketSndbufLength = n2;
        return this;
    }

    public ChannelUriStringBuilder socketSndbufLength(ChannelUri channelUri) {
        String string = channelUri.get("so-sndbuf");
        if (null == string) {
            this.socketSndbufLength = null;
            return this;
        }
        long l2 = SystemUtil.parseSize("so-sndbuf", string);
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalStateException("value exceeds maximum permitted: value=" + l2);
        }
        return this.socketSndbufLength((int)l2);
    }

    public Integer socketSndbufLength() {
        return this.socketSndbufLength;
    }

    public ChannelUriStringBuilder socketRcvbufLength(Integer n2) {
        this.socketRcvbufLength = n2;
        return this;
    }

    public ChannelUriStringBuilder socketRcvbufLength(ChannelUri channelUri) {
        String string = channelUri.get("so-rcvbuf");
        if (null == string) {
            this.socketRcvbufLength = null;
            return this;
        }
        long l2 = SystemUtil.parseSize("so-rcvbuf", string);
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalStateException("value exceeds maximum permitted: value=" + l2);
        }
        return this.socketRcvbufLength((int)l2);
    }

    public Integer socketRcvbufLength() {
        return this.socketRcvbufLength;
    }

    public ChannelUriStringBuilder receiverWindowLength(Integer n2) {
        this.receiverWindowLength = n2;
        return this;
    }

    public ChannelUriStringBuilder receiverWindowLength(ChannelUri channelUri) {
        String string = channelUri.get("rcv-wnd");
        if (null == string) {
            this.receiverWindowLength = null;
            return this;
        }
        long l2 = SystemUtil.parseSize("rcv-wnd", string);
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalStateException("value exceeds maximum permitted: value=" + l2);
        }
        return this.receiverWindowLength((int)l2);
    }

    public Integer receiverWindowLength() {
        return this.receiverWindowLength;
    }

    public String mediaReceiveTimestampOffset() {
        return this.mediaReceiveTimestampOffset;
    }

    public ChannelUriStringBuilder mediaReceiveTimestampOffset(String string) {
        if (null != string && !"reserved".equals(string)) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("mediaReceiveTimestampOffset must be a number or the value 'reserved'");
            }
        }
        this.mediaReceiveTimestampOffset = string;
        return this;
    }

    public ChannelUriStringBuilder mediaReceiveTimestampOffset(ChannelUri channelUri) {
        return this.mediaReceiveTimestampOffset(channelUri.get("media-rcv-ts-offset"));
    }

    public String channelReceiveTimestampOffset() {
        return this.channelReceiveTimestampOffset;
    }

    public ChannelUriStringBuilder channelReceiveTimestampOffset(String string) {
        if (null != string && !"reserved".equals(string)) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("channelReceiveTimestampOffset must be a number or the value 'reserved'");
            }
        }
        this.channelReceiveTimestampOffset = string;
        return this;
    }

    public ChannelUriStringBuilder channelReceiveTimestampOffset(ChannelUri channelUri) {
        return this.channelReceiveTimestampOffset(channelUri.get("channel-rcv-ts-offset"));
    }

    public String channelSendTimestampOffset() {
        return this.channelSendTimestampOffset;
    }

    public ChannelUriStringBuilder channelSendTimestampOffset(String string) {
        if (null != string && !"reserved".equals(string)) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("channelSendTimestampOffset must be a number or the value 'reserved' found: " + string);
            }
        }
        this.channelSendTimestampOffset = string;
        return this;
    }

    public ChannelUriStringBuilder channelSendTimestampOffset(ChannelUri channelUri) {
        return this.channelSendTimestampOffset(channelUri.get("channel-snd-ts-offset"));
    }

    public String build() {
        char c2;
        this.sb.setLength(0);
        if (null != this.prefix && !this.prefix.isEmpty()) {
            this.sb.append(this.prefix).append(':');
        }
        this.sb.append("aeron").append(':').append(this.media).append('?');
        if (null != this.tags) {
            this.sb.append("tags").append('=').append(this.tags).append('|');
        }
        if (null != this.endpoint) {
            this.sb.append("endpoint").append('=').append(this.endpoint).append('|');
        }
        if (null != this.networkInterface) {
            this.sb.append("interface").append('=').append(this.networkInterface).append('|');
        }
        if (null != this.controlEndpoint) {
            this.sb.append("control").append('=').append(this.controlEndpoint).append('|');
        }
        if (null != this.controlMode) {
            this.sb.append("control-mode").append('=').append(this.controlMode).append('|');
        }
        if (null != this.mtu) {
            this.sb.append("mtu").append('=').append(this.mtu).append('|');
        }
        if (null != this.termLength) {
            this.sb.append("term-length").append('=').append(this.termLength).append('|');
        }
        if (null != this.initialTermId) {
            this.sb.append("init-term-id").append('=').append(this.initialTermId).append('|');
        }
        if (null != this.termId) {
            this.sb.append("term-id").append('=').append(this.termId).append('|');
        }
        if (null != this.termOffset) {
            this.sb.append("term-offset").append('=').append(this.termOffset).append('|');
        }
        if (null != this.sessionId) {
            this.sb.append("session-id").append('=').append(ChannelUriStringBuilder.prefixTag(this.isSessionIdTagged, this.sessionId)).append('|');
        }
        if (null != this.ttl) {
            this.sb.append("ttl").append('=').append(this.ttl).append('|');
        }
        if (null != this.reliable) {
            this.sb.append("reliable").append('=').append(this.reliable).append('|');
        }
        if (null != this.linger) {
            this.sb.append("linger").append('=').append(this.linger).append('|');
        }
        if (null != this.alias) {
            this.sb.append("alias").append('=').append(this.alias).append('|');
        }
        if (null != this.cc) {
            this.sb.append("cc").append('=').append(this.cc).append('|');
        }
        if (null != this.fc) {
            this.sb.append("fc").append('=').append(this.fc).append('|');
        }
        if (null != this.groupTag) {
            this.sb.append("gtag").append('=').append(this.groupTag).append('|');
        }
        if (null != this.sparse) {
            this.sb.append("sparse").append('=').append(this.sparse).append('|');
        }
        if (null != this.eos) {
            this.sb.append("eos").append('=').append(this.eos).append('|');
        }
        if (null != this.tether) {
            this.sb.append("tether").append('=').append(this.tether).append('|');
        }
        if (null != this.group) {
            this.sb.append("group").append('=').append(this.group).append('|');
        }
        if (null != this.rejoin) {
            this.sb.append("rejoin").append('=').append(this.rejoin).append('|');
        }
        if (null != this.ssc) {
            this.sb.append("ssc").append('=').append(this.ssc).append('|');
        }
        if (null != this.socketSndbufLength) {
            this.sb.append("so-sndbuf").append('=').append(this.socketSndbufLength).append('|');
        }
        if (null != this.socketRcvbufLength) {
            this.sb.append("so-rcvbuf").append('=').append(this.socketRcvbufLength).append('|');
        }
        if (null != this.receiverWindowLength) {
            this.sb.append("rcv-wnd").append('=').append(this.receiverWindowLength).append('|');
        }
        if (null != this.mediaReceiveTimestampOffset) {
            this.sb.append("media-rcv-ts-offset").append('=').append(this.mediaReceiveTimestampOffset).append('|');
        }
        if (null != this.channelReceiveTimestampOffset) {
            this.sb.append("channel-rcv-ts-offset").append('=').append(this.channelReceiveTimestampOffset).append('|');
        }
        if (null != this.channelSendTimestampOffset) {
            this.sb.append("channel-snd-ts-offset").append('=').append(this.channelSendTimestampOffset).append('|');
        }
        if ((c2 = this.sb.charAt(this.sb.length() - 1)) == '|' || c2 == '?') {
            this.sb.setLength(this.sb.length() - 1);
        }
        return this.sb.toString();
    }

    public String toString() {
        return this.build();
    }

    private static String prefixTag(boolean bl2, Long l2) {
        return bl2 ? TAG_PREFIX + l2 : l2.toString();
    }
}

