/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2;

import impl.org.controlsfx.tableview2.TableRow2;
import impl.org.controlsfx.tableview2.TableView2Skin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.layout.Region;
import org.controlsfx.control.tableview2.TableView2;

final class TableView2VirtualFlow<T extends IndexedCell<?>>
extends VirtualFlow<T> {
    private final TableView2<?> tableView;
    private final TableView2Skin<?> skin;
    private final ArrayList<T> myFixedCells = new ArrayList();
    public final List<Node> sheetChildren;
    private boolean adjusting;
    private final DoubleProperty adjustedPixels = new SimpleDoubleProperty(){

        protected void invalidated() {
            if (!TableView2VirtualFlow.this.adjusting && this.get() > 0.0 && TableView2VirtualFlow.this.myFixedCells.size() < TableView2VirtualFlow.this.tableView.getFixedRows().size()) {
                TableView2VirtualFlow.this.layoutChildren();
            }
            TableView2VirtualFlow.this.adjusting = false;
        }
    };
    private final ChangeListener<Number> hBarValueChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            TableView2VirtualFlow.this.skin.hBarValue.clear();
        }
    };

    public TableView2VirtualFlow(TableView2Skin<?> tableView2Skin) {
        this.skin = tableView2Skin;
        this.tableView = (TableView2)tableView2Skin.getSkinnable();
        ChangeListener changeListener = (observableValue, number, number2) -> this.layoutTotal();
        this.getVbar().valueProperty().addListener(changeListener);
        this.getHbar().valueProperty().addListener(this.hBarValueChangeListener);
        this.widthProperty().addListener(this.hBarValueChangeListener);
        this.sheetChildren = this.findSheetChildren();
    }

    public void init() {
        this.getHbar().maxProperty().addListener((observableValue, number, number2) -> {
            this.getHbar().setBlockIncrement(this.getWidth());
            this.getHbar().setUnitIncrement(number2.doubleValue() / 20.0);
        });
        this.tableView.getFixedRows().addListener(observable -> {
            ArrayList<IndexedCell> arrayList = new ArrayList<IndexedCell>();
            for (IndexedCell indexedCell : this.myFixedCells) {
                if (this.tableView.getFixedRows().contains((Object)indexedCell.getIndex())) continue;
                indexedCell.setManaged(false);
                indexedCell.setVisible(false);
                arrayList.add(indexedCell);
            }
            this.myFixedCells.removeAll(arrayList);
        });
    }

    public void scrollTo(int n2) {
        if (!this.getCells().isEmpty() && !this.tableView.getFixedRows().isEmpty()) {
            for (double d2 = this.skin.getFixedRowHeight(); d2 >= 0.0 && n2 > 0; d2 -= this.skin.getRowHeight(--n2)) {
            }
        }
        super.scrollTo(n2);
        this.layoutTotal();
        this.layoutFixedRows();
    }

    public double scrollPixels(double d2) {
        double d3 = super.scrollPixels(d2);
        this.adjusting = true;
        this.adjustedPixels.set(d2);
        this.layoutTotal();
        this.layoutFixedRows();
        return d3;
    }

    List<T> getFixedCells() {
        return this.myFixedCells;
    }

    void rebuildFixedCells() {
        this.myFixedCells.clear();
    }

    DoubleProperty adjustedPixelsProperty() {
        return this.adjustedPixels;
    }

    protected void layoutChildren() {
        if (this.tableView != null) {
            this.sortRows();
            super.layoutChildren();
            this.layoutTotal();
            this.layoutFixedRows();
            if (this.getVbar().getVisibleAmount() == 0.0 && this.getVbar().isVisible() && this.getCells().size() != this.getCellCount()) {
                this.getVbar().setMax(1.0);
                this.getVbar().setVisibleAmount((double)((float)this.getCells().size() / (float)this.getCellCount()));
            }
        }
    }

    protected void layoutTotal() {
        this.sortRows();
        this.removeDeportedCells();
        if (this.getCells().isEmpty()) {
            this.reconfigureCells();
        }
        for (IndexedCell indexedCell : this.getCells()) {
            if (indexedCell == null) continue;
            indexedCell.getProperties().put((Object)"fixed", (Object)false);
            if (indexedCell.getIndex() < 0 || this.skin.hBarValue.get(indexedCell.getIndex()) && !this.skin.rowToLayout.get(indexedCell.getIndex())) continue;
            if (this.skin.rowToLayout.get(indexedCell.getIndex())) {
                indexedCell.getProperties().put((Object)"fixed", (Object)true);
            }
            indexedCell.requestLayout();
        }
    }

    private <S> void removeDeportedCells() {
        ArrayList arrayList = new ArrayList();
        Iterator<Map.Entry<TableRow2<Object>, Set<Object>>> iterator = this.skin.deportedCells.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            ArrayList arrayList2 = new ArrayList();
            for (TableCell tableCell : entry.getValue()) {
                if (tableCell.isEditing() || this.getCells().contains(tableCell.getTableRow())) continue;
                entry.getKey().removeCell(tableCell);
                arrayList2.add(tableCell);
            }
            entry.getValue().removeAll(arrayList2);
            if (!entry.getValue().isEmpty()) continue;
            arrayList.add(entry.getKey());
        }
        for (TableRow2 tableRow2 : arrayList) {
            this.skin.deportedCells.remove((Object)tableRow2);
        }
    }

    protected ScrollBar getVerticalBar() {
        return this.getVbar();
    }

    protected ScrollBar getHorizontalBar() {
        return this.getHbar();
    }

    protected List<T> getCells() {
        return super.getCells();
    }

    private List<Node> findSheetChildren() {
        Region region;
        if (!this.getChildren().isEmpty() && this.getChildren().get(0) instanceof Region && !(region = (Region)this.getChildren().get(0)).getChildrenUnmodifiable().isEmpty() && region.getChildrenUnmodifiable().get(0) instanceof Group) {
            return ((Group)region.getChildrenUnmodifiable().get(0)).getChildren();
        }
        return new ArrayList<Node>();
    }

    private void layoutFixedRows() {
        if (!this.tableView.getFixedRows().isEmpty() && this.tableView.isRowFixingEnabled() && this.getFirstVisibleCellWithinViewport() != null) {
            this.sortRows();
            Object object = null;
            block0: for (int i2 = this.tableView.getFixedRows().size() - 1; i2 >= 0; --i2) {
                IndexedCell indexedCell;
                Integer n2 = (Integer)this.tableView.getFixedRows().get(i2);
                IndexedCell indexedCell2 = this.getLastVisibleCellWithinViewport();
                if (indexedCell2 != null && n2 > indexedCell2.getIndex()) {
                    if (object == null) continue;
                    object.setVisible(false);
                    object.setManaged(false);
                    object.getProperties().put((Object)"fixed", (Object)false);
                    this.sheetChildren.remove(object);
                    continue;
                }
                Iterator<T> iterator = this.getCells().iterator();
                while (iterator.hasNext() && (indexedCell = (IndexedCell)iterator.next()).getIndex() <= n2) {
                    if (indexedCell.getIndex() != n2.intValue()) continue;
                    object = this.containsRows(n2);
                    if (object != null) {
                        object.setVisible(false);
                        object.setManaged(false);
                        object.getProperties().put((Object)"fixed", (Object)false);
                        this.sheetChildren.remove(object);
                    }
                    indexedCell.toFront();
                    continue block0;
                }
                object = this.containsRows(n2);
                if (object == null) {
                    object = (IndexedCell)this.getCellFactory().call((Object)this);
                    object.getProperties().put((Object)"newcell", null);
                    this.setCellIndex((IndexedCell)object, n2);
                    this.resizeCell((IndexedCell)object);
                    this.myFixedCells.add(object);
                }
                if (!this.sheetChildren.contains(object)) {
                    this.sheetChildren.add((Node)object);
                }
                object.setManaged(true);
                object.setVisible(true);
                object.getProperties().put((Object)"fixed", (Object)true);
                object.toFront();
                object.requestLayout();
            }
        }
    }

    private T containsRows(int n2) {
        for (IndexedCell indexedCell : this.myFixedCells) {
            if (indexedCell.getIndex() != n2) continue;
            return (T)indexedCell;
        }
        return null;
    }

    private void sortRows() {
        List<T> list = this.getCells();
        ArrayList<T> arrayList = new ArrayList<T>(list);
        Collections.sort(arrayList, (indexedCell, indexedCell2) -> indexedCell2.getIndex() - indexedCell.getIndex());
        for (IndexedCell indexedCell3 : arrayList) {
            indexedCell3.toFront();
        }
    }
}

