/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.txw2.output;

import com.sun.xml.txw2.output.CharacterEscapeHandler;
import com.sun.xml.txw2.output.DumbEscapeHandler;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLWriter
extends XMLFilterImpl
implements LexicalHandler {
    private final HashMap locallyDeclaredPrefix = new HashMap();
    private final Attributes EMPTY_ATTS = new AttributesImpl();
    private boolean inCDATA = false;
    private int elementLevel = 0;
    private Writer output;
    private String encoding;
    private boolean writeXmlDecl = true;
    private String header = null;
    private final CharacterEscapeHandler escapeHandler;
    private boolean startTagIsClosed = true;

    public XMLWriter(Writer writer, String string, CharacterEscapeHandler characterEscapeHandler) {
        this.init(writer, string);
        this.escapeHandler = characterEscapeHandler;
    }

    public XMLWriter(Writer writer, String string) {
        this(writer, string, DumbEscapeHandler.theInstance);
    }

    private void init(Writer writer, String string) {
        this.setOutput(writer, string);
    }

    public void reset() {
        this.elementLevel = 0;
        this.startTagIsClosed = true;
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void setOutput(Writer writer, String string) {
        this.output = writer == null ? new OutputStreamWriter(System.out) : writer;
        this.encoding = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setXmlDecl(boolean bl2) {
        this.writeXmlDecl = bl2;
    }

    public void setHeader(String string) {
        this.header = string;
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.locallyDeclaredPrefix.put(string, string2);
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.reset();
            if (this.writeXmlDecl) {
                String string = "";
                if (this.encoding != null) {
                    string = " encoding=\"" + this.encoding + "\"";
                }
                this.write("<?xml version=\"1.0\"" + string + " standalone=\"yes\"?>\n");
            }
            if (this.header != null) {
                this.write(this.header);
            }
            super.startDocument();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            if (!this.startTagIsClosed) {
                this.write("/>");
                this.startTagIsClosed = true;
            }
            this.write('\n');
            super.endDocument();
            try {
                this.flush();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (!this.startTagIsClosed) {
                this.write(">");
            }
            ++this.elementLevel;
            this.write('<');
            this.writeName(string, string2, string3, true);
            this.writeAttributes(attributes);
            if (!this.locallyDeclaredPrefix.isEmpty()) {
                for (Map.Entry entry : this.locallyDeclaredPrefix.entrySet()) {
                    String string4 = (String)entry.getKey();
                    String string5 = (String)entry.getValue();
                    if (string5 == null) {
                        string5 = "";
                    }
                    this.write(' ');
                    if ("".equals(string4)) {
                        this.write("xmlns=\"");
                    } else {
                        this.write("xmlns:");
                        this.write(string4);
                        this.write("=\"");
                    }
                    char[] cArray = string5.toCharArray();
                    this.writeEsc(cArray, 0, cArray.length, true);
                    this.write('\"');
                }
                this.locallyDeclaredPrefix.clear();
            }
            super.startElement(string, string2, string3, attributes);
            this.startTagIsClosed = false;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (this.startTagIsClosed) {
                this.write("</");
                this.writeName(string, string2, string3, true);
                this.write('>');
            } else {
                this.write("/>");
                this.startTagIsClosed = true;
            }
            if (this.elementLevel == 1) {
                this.write('\n');
            }
            super.endElement(string, string2, string3);
            --this.elementLevel;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        try {
            if (!this.startTagIsClosed) {
                this.write('>');
                this.startTagIsClosed = true;
            }
            if (this.inCDATA) {
                this.output.write(cArray, n2, n3);
            } else {
                this.writeEsc(cArray, n2, n3, false);
            }
            super.characters(cArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        try {
            this.writeEsc(cArray, n2, n3, false);
            super.ignorableWhitespace(cArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            if (!this.startTagIsClosed) {
                this.write('>');
                this.startTagIsClosed = true;
            }
            this.write("<?");
            this.write(string);
            this.write(' ');
            this.write(string2);
            this.write("?>");
            if (this.elementLevel < 1) {
                this.write('\n');
            }
            super.processingInstruction(string, string2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startElement(String string, String string2) throws SAXException {
        this.startElement(string, string2, "", this.EMPTY_ATTS);
    }

    public void startElement(String string) throws SAXException {
        this.startElement("", string, "", this.EMPTY_ATTS);
    }

    public void endElement(String string, String string2) throws SAXException {
        this.endElement(string, string2, "");
    }

    public void endElement(String string) throws SAXException {
        this.endElement("", string, "");
    }

    public void dataElement(String string, String string2, String string3, Attributes attributes, String string4) throws SAXException {
        this.startElement(string, string2, string3, attributes);
        this.characters(string4);
        this.endElement(string, string2, string3);
    }

    public void dataElement(String string, String string2, String string3) throws SAXException {
        this.dataElement(string, string2, "", this.EMPTY_ATTS, string3);
    }

    public void dataElement(String string, String string2) throws SAXException {
        this.dataElement("", string, "", this.EMPTY_ATTS, string2);
    }

    public void characters(String string) throws SAXException {
        try {
            if (!this.startTagIsClosed) {
                this.write('>');
                this.startTagIsClosed = true;
            }
            char[] cArray = string.toCharArray();
            this.characters(cArray, 0, cArray.length);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        try {
            if (!this.startTagIsClosed) {
                this.write('>');
                this.startTagIsClosed = true;
            }
            this.write("<![CDATA[");
            this.inCDATA = true;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        try {
            this.inCDATA = false;
            this.write("]]>");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        try {
            this.output.write("<!--");
            this.output.write(cArray, n2, n3);
            this.output.write("-->");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void write(char c2) throws IOException {
        this.output.write(c2);
    }

    private void write(String string) throws IOException {
        this.output.write(string);
    }

    private void writeAttributes(Attributes attributes) throws IOException, SAXException {
        int n2 = attributes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            char[] cArray = attributes.getValue(i2).toCharArray();
            this.write(' ');
            this.writeName(attributes.getURI(i2), attributes.getLocalName(i2), attributes.getQName(i2), false);
            this.write("=\"");
            this.writeEsc(cArray, 0, cArray.length, true);
            this.write('\"');
        }
    }

    private void writeEsc(char[] cArray, int n2, int n3, boolean bl2) throws SAXException, IOException {
        this.escapeHandler.escape(cArray, n2, n3, bl2, this.output);
    }

    private void writeName(String string, String string2, String string3, boolean bl2) throws IOException {
        this.write(string3);
    }
}

