/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.property;

import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.model.core.ID;
import com.sun.xml.bind.v2.model.core.PropertyKind;
import com.sun.xml.bind.v2.model.runtime.RuntimeElementPropertyInfo;
import com.sun.xml.bind.v2.model.runtime.RuntimeTypeRef;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.property.PropertyImpl;
import com.sun.xml.bind.v2.runtime.property.UnmarshallerChain;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.TransducedAccessor;
import com.sun.xml.bind.v2.runtime.unmarshaller.ChildLoader;
import com.sun.xml.bind.v2.runtime.unmarshaller.DefaultValueLoaderDecorator;
import com.sun.xml.bind.v2.runtime.unmarshaller.LeafPropertyLoader;
import com.sun.xml.bind.v2.runtime.unmarshaller.LeafPropertyXsiLoader;
import com.sun.xml.bind.v2.runtime.unmarshaller.Loader;
import com.sun.xml.bind.v2.runtime.unmarshaller.XsiNilLoader;
import com.sun.xml.bind.v2.util.QNameMap;
import java.io.IOException;
import java.lang.reflect.Modifier;
import javax.xml.bind.JAXBElement;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

final class SingleElementLeafProperty<BeanT>
extends PropertyImpl<BeanT> {
    private final Name tagName;
    private final boolean nillable;
    private final Accessor acc;
    private final String defaultValue;
    private final TransducedAccessor<BeanT> xacc;
    private final boolean improvedXsiTypeHandling;
    private final boolean idRef;

    public SingleElementLeafProperty(JAXBContextImpl jAXBContextImpl, RuntimeElementPropertyInfo runtimeElementPropertyInfo) {
        super(jAXBContextImpl, runtimeElementPropertyInfo);
        RuntimeTypeRef runtimeTypeRef = runtimeElementPropertyInfo.getTypes().get(0);
        this.tagName = jAXBContextImpl.nameBuilder.createElementName(runtimeTypeRef.getTagName());
        assert (this.tagName != null);
        this.nillable = runtimeTypeRef.isNillable();
        this.defaultValue = runtimeTypeRef.getDefaultValue();
        this.acc = runtimeElementPropertyInfo.getAccessor().optimize(jAXBContextImpl);
        this.xacc = TransducedAccessor.get(jAXBContextImpl, runtimeTypeRef);
        assert (this.xacc != null);
        this.improvedXsiTypeHandling = jAXBContextImpl.improvedXsiTypeHandling;
        this.idRef = runtimeTypeRef.getSource().id() == ID.IDREF;
    }

    @Override
    public void reset(BeanT BeanT) throws AccessorException {
        this.acc.set(BeanT, null);
    }

    @Override
    public String getIdValue(BeanT BeanT) throws AccessorException, SAXException {
        return this.xacc.print(BeanT).toString();
    }

    @Override
    public void serializeBody(BeanT BeanT, XMLSerializer xMLSerializer, Object object) throws SAXException, AccessorException, IOException, XMLStreamException {
        boolean bl2 = this.xacc.hasValue(BeanT);
        Object object2 = null;
        try {
            object2 = this.acc.getUnadapted(BeanT);
        }
        catch (AccessorException accessorException) {
            // empty catch block
        }
        Class clazz = this.acc.getValueType();
        if (this.xsiTypeNeeded(BeanT, xMLSerializer, object2, clazz)) {
            xMLSerializer.startElement(this.tagName, object);
            xMLSerializer.childAsXsiType(object2, this.fieldName, xMLSerializer.grammar.getBeanInfo(clazz), false);
            xMLSerializer.endElement();
        } else if (bl2) {
            this.xacc.writeLeafElement(xMLSerializer, this.tagName, BeanT, this.fieldName);
        } else if (this.nillable) {
            xMLSerializer.startElement(this.tagName, null);
            xMLSerializer.writeXsiNilTrue();
            xMLSerializer.endElement();
        }
    }

    private boolean xsiTypeNeeded(BeanT BeanT, XMLSerializer xMLSerializer, Object object, Class clazz) {
        if (!this.improvedXsiTypeHandling) {
            return false;
        }
        if (this.acc.isAdapted()) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass().equals(clazz)) {
            return false;
        }
        if (this.idRef) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return false;
        }
        return this.acc.isValueTypeAbstractable() || this.isNillableAbstract(BeanT, xMLSerializer.grammar, object, clazz);
    }

    private boolean isNillableAbstract(BeanT BeanT, JAXBContextImpl jAXBContextImpl, Object object, Class clazz) {
        if (!this.nillable) {
            return false;
        }
        if (clazz != Object.class) {
            return false;
        }
        if (BeanT.getClass() != JAXBElement.class) {
            return false;
        }
        JAXBElement jAXBElement = (JAXBElement)BeanT;
        Class<?> clazz2 = object.getClass();
        Class clazz3 = jAXBElement.getDeclaredType();
        if (clazz3.equals(clazz2)) {
            return false;
        }
        if (!clazz3.isAssignableFrom(clazz2)) {
            return false;
        }
        if (!Modifier.isAbstract(clazz3.getModifiers())) {
            return false;
        }
        return this.acc.isAbstractable(clazz3);
    }

    @Override
    public void buildChildElementUnmarshallers(UnmarshallerChain unmarshallerChain, QNameMap<ChildLoader> qNameMap) {
        Loader loader = new LeafPropertyLoader(this.xacc);
        if (this.defaultValue != null) {
            loader = new DefaultValueLoaderDecorator(loader, this.defaultValue);
        }
        if (this.nillable || unmarshallerChain.context.allNillable) {
            loader = new XsiNilLoader.Single(loader, this.acc);
        }
        if (this.improvedXsiTypeHandling) {
            loader = new LeafPropertyXsiLoader(loader, this.xacc, this.acc);
        }
        qNameMap.put(this.tagName, new ChildLoader(loader, null));
    }

    @Override
    public PropertyKind getKind() {
        return PropertyKind.ELEMENT;
    }

    @Override
    public Accessor getElementPropertyAccessor(String string, String string2) {
        if (this.tagName.equals(string, string2)) {
            return this.acc;
        }
        return null;
    }
}

