/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.model.impl;

import com.sun.xml.bind.v2.TODO;
import com.sun.xml.bind.v2.model.annotation.AnnotationReader;
import com.sun.xml.bind.v2.model.annotation.Locatable;
import com.sun.xml.bind.v2.model.core.Adapter;
import com.sun.xml.bind.v2.model.core.ID;
import com.sun.xml.bind.v2.model.core.PropertyInfo;
import com.sun.xml.bind.v2.model.core.TypeInfo;
import com.sun.xml.bind.v2.model.impl.ClassInfoImpl;
import com.sun.xml.bind.v2.model.impl.Messages;
import com.sun.xml.bind.v2.model.impl.PropertySeed;
import com.sun.xml.bind.v2.model.impl.Util;
import com.sun.xml.bind.v2.model.nav.Navigator;
import com.sun.xml.bind.v2.runtime.IllegalAnnotationException;
import com.sun.xml.bind.v2.runtime.Location;
import com.sun.xml.bind.v2.runtime.SwaRefAdapter;
import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.activation.MimeType;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlInlineBinaryData;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import javax.xml.namespace.QName;

abstract class PropertyInfoImpl<T, C, F, M>
implements PropertyInfo<T, C>,
Locatable,
Comparable<PropertyInfoImpl> {
    protected final PropertySeed<T, C, F, M> seed;
    private final boolean isCollection;
    private final ID id;
    private final MimeType expectedMimeType;
    private final boolean inlineBinary;
    private final QName schemaType;
    protected final ClassInfoImpl<T, C, F, M> parent;
    private final Adapter<T, C> adapter;

    protected PropertyInfoImpl(ClassInfoImpl<T, C, F, M> classInfoImpl, PropertySeed<T, C, F, M> propertySeed) {
        this.seed = propertySeed;
        this.parent = classInfoImpl;
        if (classInfoImpl == null) {
            throw new AssertionError();
        }
        MimeType mimeType = Util.calcExpectedMediaType(this.seed, classInfoImpl.builder);
        if (mimeType != null && !this.kind().canHaveXmlMimeType) {
            classInfoImpl.builder.reportError(new IllegalAnnotationException(Messages.ILLEGAL_ANNOTATION.format(XmlMimeType.class.getName()), this.seed.readAnnotation(XmlMimeType.class)));
            mimeType = null;
        }
        this.expectedMimeType = mimeType;
        this.inlineBinary = this.seed.hasAnnotation(XmlInlineBinaryData.class);
        T t2 = this.seed.getRawType();
        XmlJavaTypeAdapter xmlJavaTypeAdapter = this.getApplicableAdapter(t2);
        if (xmlJavaTypeAdapter != null) {
            this.isCollection = false;
            this.adapter = new Adapter<T, C>(xmlJavaTypeAdapter, this.reader(), this.nav());
        } else {
            this.isCollection = this.nav().isSubClassOf(t2, this.nav().ref(Collection.class)) || this.nav().isArrayButNotByteArray(t2);
            xmlJavaTypeAdapter = this.getApplicableAdapter(this.getIndividualType());
            if (xmlJavaTypeAdapter == null) {
                XmlAttachmentRef xmlAttachmentRef = this.seed.readAnnotation(XmlAttachmentRef.class);
                if (xmlAttachmentRef != null) {
                    classInfoImpl.builder.hasSwaRef = true;
                    this.adapter = new Adapter<T, C>(this.nav().asDecl(SwaRefAdapter.class), this.nav());
                } else {
                    this.adapter = null;
                    xmlJavaTypeAdapter = this.seed.readAnnotation(XmlJavaTypeAdapter.class);
                    if (xmlJavaTypeAdapter != null) {
                        T t3 = this.reader().getClassValue(xmlJavaTypeAdapter, "value");
                        classInfoImpl.builder.reportError(new IllegalAnnotationException(Messages.UNMATCHABLE_ADAPTER.format(this.nav().getTypeName(t3), this.nav().getTypeName(t2)), xmlJavaTypeAdapter));
                    }
                }
            } else {
                this.adapter = new Adapter<T, C>(xmlJavaTypeAdapter, this.reader(), this.nav());
            }
        }
        this.id = this.calcId();
        this.schemaType = Util.calcSchemaType(this.reader(), this.seed, classInfoImpl.clazz, this.getIndividualType(), this);
    }

    public ClassInfoImpl<T, C, F, M> parent() {
        return this.parent;
    }

    protected final Navigator<T, C, F, M> nav() {
        return this.parent.nav();
    }

    protected final AnnotationReader<T, C, F, M> reader() {
        return this.parent.reader();
    }

    public T getRawType() {
        return this.seed.getRawType();
    }

    public T getIndividualType() {
        if (this.adapter != null) {
            return (T)this.adapter.defaultType;
        }
        T t2 = this.getRawType();
        if (!this.isCollection()) {
            return t2;
        }
        if (this.nav().isArrayButNotByteArray(t2)) {
            return this.nav().getComponentType(t2);
        }
        T t3 = this.nav().getBaseClass(t2, this.nav().asDecl(Collection.class));
        if (this.nav().isParameterizedType(t3)) {
            return this.nav().getTypeArgument(t3, 0);
        }
        return this.nav().ref(Object.class);
    }

    @Override
    public final String getName() {
        return this.seed.getName();
    }

    private boolean isApplicable(XmlJavaTypeAdapter xmlJavaTypeAdapter, T t2) {
        if (xmlJavaTypeAdapter == null) {
            return false;
        }
        T t3 = this.reader().getClassValue(xmlJavaTypeAdapter, "type");
        if (this.nav().isSameType(t2, t3)) {
            return true;
        }
        T t4 = this.reader().getClassValue(xmlJavaTypeAdapter, "value");
        T t5 = this.nav().getBaseClass(t4, this.nav().asDecl(XmlAdapter.class));
        if (!this.nav().isParameterizedType(t5)) {
            return true;
        }
        T t6 = this.nav().getTypeArgument(t5, 1);
        return this.nav().isSubClassOf(t2, t6);
    }

    private XmlJavaTypeAdapter getApplicableAdapter(T t2) {
        XmlJavaTypeAdapter xmlJavaTypeAdapter = this.seed.readAnnotation(XmlJavaTypeAdapter.class);
        if (xmlJavaTypeAdapter != null && this.isApplicable(xmlJavaTypeAdapter, t2)) {
            return xmlJavaTypeAdapter;
        }
        XmlJavaTypeAdapters xmlJavaTypeAdapters = this.reader().getPackageAnnotation(XmlJavaTypeAdapters.class, this.parent.clazz, this.seed);
        if (xmlJavaTypeAdapters != null) {
            for (XmlJavaTypeAdapter xmlJavaTypeAdapter2 : xmlJavaTypeAdapters.value()) {
                if (!this.isApplicable(xmlJavaTypeAdapter2, t2)) continue;
                return xmlJavaTypeAdapter2;
            }
        }
        if (this.isApplicable(xmlJavaTypeAdapter = this.reader().getPackageAnnotation(XmlJavaTypeAdapter.class, this.parent.clazz, this.seed), t2)) {
            return xmlJavaTypeAdapter;
        }
        C c2 = this.nav().asDecl(t2);
        if (c2 != null && (xmlJavaTypeAdapter = this.reader().getClassAnnotation(XmlJavaTypeAdapter.class, c2, this.seed)) != null && this.isApplicable(xmlJavaTypeAdapter, t2)) {
            return xmlJavaTypeAdapter;
        }
        return null;
    }

    @Override
    public Adapter<T, C> getAdapter() {
        return this.adapter;
    }

    @Override
    public final String displayName() {
        return this.nav().getClassName(this.parent.getClazz()) + '#' + this.getName();
    }

    @Override
    public final ID id() {
        return this.id;
    }

    private ID calcId() {
        if (this.seed.hasAnnotation(XmlID.class)) {
            if (!this.nav().isSameType(this.getIndividualType(), this.nav().ref(String.class))) {
                this.parent.builder.reportError(new IllegalAnnotationException(Messages.ID_MUST_BE_STRING.format(this.getName()), this.seed));
            }
            return ID.ID;
        }
        if (this.seed.hasAnnotation(XmlIDREF.class)) {
            return ID.IDREF;
        }
        return ID.NONE;
    }

    @Override
    public final MimeType getExpectedMimeType() {
        return this.expectedMimeType;
    }

    @Override
    public final boolean inlineBinaryData() {
        return this.inlineBinary;
    }

    @Override
    public final QName getSchemaType() {
        return this.schemaType;
    }

    @Override
    public final boolean isCollection() {
        return this.isCollection;
    }

    protected void link() {
        if (this.id == ID.IDREF) {
            for (TypeInfo typeInfo : this.ref()) {
                if (typeInfo.canBeReferencedByIDREF()) continue;
                this.parent.builder.reportError(new IllegalAnnotationException(Messages.INVALID_IDREF.format(this.parent.builder.nav.getTypeName(typeInfo.getType())), this));
            }
        }
    }

    @Override
    public Locatable getUpstream() {
        return this.parent;
    }

    @Override
    public Location getLocation() {
        return this.seed.getLocation();
    }

    protected final QName calcXmlName(XmlElement xmlElement) {
        if (xmlElement != null) {
            return this.calcXmlName(xmlElement.namespace(), xmlElement.name());
        }
        return this.calcXmlName("##default", "##default");
    }

    protected final QName calcXmlName(XmlElementWrapper xmlElementWrapper) {
        if (xmlElementWrapper != null) {
            return this.calcXmlName(xmlElementWrapper.namespace(), xmlElementWrapper.name());
        }
        return this.calcXmlName("##default", "##default");
    }

    private QName calcXmlName(String string, String string2) {
        TODO.checkSpec();
        if (string2.length() == 0 || string2.equals("##default")) {
            string2 = this.seed.getName();
        }
        if (string.equals("##default")) {
            XmlSchema xmlSchema = this.reader().getPackageAnnotation(XmlSchema.class, this.parent.getClazz(), this);
            if (xmlSchema != null) {
                switch (xmlSchema.elementFormDefault()) {
                    case QUALIFIED: {
                        QName qName = this.parent.getTypeName();
                        string = qName != null ? qName.getNamespaceURI() : xmlSchema.namespace();
                        if (string.length() != 0) break;
                        string = this.parent.builder.defaultNsUri;
                        break;
                    }
                    case UNQUALIFIED: 
                    case UNSET: {
                        string = "";
                    }
                }
            } else {
                string = "";
            }
        }
        return new QName(string.intern(), string2.intern());
    }

    @Override
    public int compareTo(PropertyInfoImpl propertyInfoImpl) {
        return this.getName().compareTo(propertyInfoImpl.getName());
    }

    @Override
    public final <A extends Annotation> A readAnnotation(Class<A> clazz) {
        return this.seed.readAnnotation(clazz);
    }

    @Override
    public final boolean hasAnnotation(Class<? extends Annotation> clazz) {
        return this.seed.hasAnnotation(clazz);
    }
}

