/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.pannable;

import com.jfoenix.bindings.CustomBidirectionalBinding;
import com.jfoenix.bindings.base.IPropertyConverter;
import com.jfoenix.controls.pannable.base.IPannablePane;
import java.util.function.Function;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public class PannableScrollPane
extends Pane {
    private ScrollBar vBar = new ScrollBar();
    private ScrollBar hBar = new ScrollBar();
    private static final double SCROLL_PAD = 20.0;

    private void init() {
        this.getStyleClass().add((Object)"pannable-scroll-pane");
        this.getChildren().addAll((Object[])new Node[]{this.vBar, this.hBar});
        this.vBar.setManaged(false);
        this.vBar.setOrientation(Orientation.VERTICAL);
        this.hBar.setManaged(false);
        this.hBar.setOrientation(Orientation.HORIZONTAL);
    }

    public <P extends Region> PannableScrollPane(P p2) {
        super(new Node[]{p2});
        this.init();
        this.bindScrollBar(this.vBar, p2, (Property<Number>)p2.translateYProperty(), region -> region.heightProperty());
        this.bindScrollBar(this.hBar, p2, (Property<Number>)p2.translateXProperty(), region -> region.widthProperty());
    }

    <P extends Region> void bindScrollBar(ScrollBar scrollBar, P p2, Property<Number> property, Function<Region, DoubleExpression> function) {
        CustomBidirectionalBinding<Number, Number> customBidirectionalBinding = new CustomBidirectionalBinding<Number, Number>(property, (Property<Number>)scrollBar.valueProperty(), new IPropertyConverter<Number, Number>(){

            @Override
            public Number to(Number number) {
                return number.doubleValue() * -1.0;
            }

            @Override
            public Number from(Number number) {
                return number.doubleValue() * -1.0;
            }
        });
        customBidirectionalBinding.bindBi();
        scrollBar.minProperty().bind((ObservableValue)((IPannablePane)p2).scaleProperty().negate());
        scrollBar.maxProperty().bind((ObservableValue)function.apply(p2).add(20.0).multiply((ObservableNumberValue)((IPannablePane)p2).scaleProperty()).subtract((ObservableNumberValue)function.apply((Region)this)));
        scrollBar.visibleProperty().bind((ObservableValue)scrollBar.maxProperty().greaterThan(0));
    }

    public PannableScrollPane() {
        this.init();
    }

    protected void layoutChildren() {
        super.layoutChildren();
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        Insets insets = this.getInsets();
        double d4 = this.vBar.prefWidth(-1.0);
        this.vBar.resizeRelocate(d2 - d4 - insets.getRight(), insets.getTop(), d4, d3 - insets.getTop() - insets.getBottom());
        double d5 = this.hBar.prefHeight(-1.0);
        this.hBar.resizeRelocate(insets.getLeft(), d3 - d5 - insets.getBottom(), d2 - insets.getLeft() - insets.getRight(), d5);
    }
}

