/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.utils.Preconditions;

public abstract class OAuth1Token
extends Token {
    private static final long serialVersionUID = 6285873427974823019L;
    private final String token;
    private final String tokenSecret;

    public OAuth1Token(String string, String string2, String string3) {
        super(string3);
        Preconditions.checkNotNull(string, "oauth_token can't be null");
        Preconditions.checkNotNull(string2, "oauth_token_secret can't be null");
        this.token = string;
        this.tokenSecret = string2;
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public boolean isEmpty() {
        return "".equals(this.token) && "".equals(this.tokenSecret);
    }
}

