/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OAuth2AccessTokenExtractor
implements TokenExtractor<OAuth2AccessToken> {
    private static final Pattern ACCESS_TOKEN_REGEX_PATTERN = Pattern.compile("access_token=([^&]+)");
    private static final Pattern TOKEN_TYPE_REGEX_PATTERN = Pattern.compile("token_type=([^&]+)");
    private static final Pattern EXPIRES_IN_REGEX_PATTERN = Pattern.compile("expires_in=([^&]+)");
    private static final Pattern REFRESH_TOKEN_REGEX_PATTERN = Pattern.compile("refresh_token=([^&]+)");
    private static final Pattern SCOPE_REGEX_PATTERN = Pattern.compile("scope=([^&]+)");

    protected OAuth2AccessTokenExtractor() {
    }

    public static OAuth2AccessTokenExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public OAuth2AccessToken extract(Response response) throws IOException {
        Integer n2;
        String string = response.getBody();
        Preconditions.checkEmptyString(string, "Response body is incorrect. Can't extract a token from an empty string");
        String string2 = OAuth2AccessTokenExtractor.extractParameter(string, ACCESS_TOKEN_REGEX_PATTERN, true);
        String string3 = OAuth2AccessTokenExtractor.extractParameter(string, TOKEN_TYPE_REGEX_PATTERN, false);
        String string4 = OAuth2AccessTokenExtractor.extractParameter(string, EXPIRES_IN_REGEX_PATTERN, false);
        try {
            n2 = string4 == null ? null : Integer.valueOf(string4);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = null;
        }
        String string5 = OAuth2AccessTokenExtractor.extractParameter(string, REFRESH_TOKEN_REGEX_PATTERN, false);
        String string6 = OAuth2AccessTokenExtractor.extractParameter(string, SCOPE_REGEX_PATTERN, false);
        return new OAuth2AccessToken(string2, string3, n2, string5, string6, string);
    }

    private static String extractParameter(String string, Pattern pattern, boolean bl2) throws OAuthException {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return OAuthEncoder.decode(matcher.group(1));
        }
        if (bl2) {
            throw new OAuthException("Response body is incorrect. Can't extract a '" + pattern.pattern() + "' from this: '" + string + "'", null);
        }
        return null;
    }

    private static class InstanceHolder {
        private static final OAuth2AccessTokenExtractor INSTANCE = new OAuth2AccessTokenExtractor();

        private InstanceHolder() {
        }
    }
}

