/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.apis.salesforce.SalesforceJsonTokenExtractor;
import com.github.scribejava.core.builder.api.ClientAuthenticationType;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.Verb;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;

public class SalesforceApi
extends DefaultApi20 {
    private static final String PRODUCTION_HOST = "login.salesforce.com";
    private static final String SANDBOX_HOST = "test.salesforce.com";
    private static final String PROTOCOL = "https://";
    private static final String ACCESS_PATH = "/services/oauth2/token";
    private static final String AUTHORIZE_PATH = "/services/oauth2/authorize";
    private final String accessTokenUrl;
    private final String authorizationBaseUrl;

    protected SalesforceApi(String string) {
        this.accessTokenUrl = PROTOCOL + string + ACCESS_PATH;
        this.authorizationBaseUrl = PROTOCOL + string + AUTHORIZE_PATH;
        try {
            SSLSocket sSLSocket = (SSLSocket)SSLContext.getDefault().getSocketFactory().createSocket();
            if (!SalesforceApi.isTLSv11orUpperEnabled(sSLSocket)) {
                throw new IllegalStateException("Salesforce API required to use TLSv1.1 or upper. Enabled it by invoking method initTLSv11orUpper or somehow else");
            }
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            throw new IllegalStateException("Salesforce API required to use TLSv1.1 or upper. Enabled it by invoking method initTLSv11orUpper or somehow else");
        }
    }

    public static SalesforceApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public static SalesforceApi sandbox() {
        return new SalesforceApi(SANDBOX_HOST);
    }

    @Override
    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    @Override
    public String getAccessTokenEndpoint() {
        return this.accessTokenUrl;
    }

    @Override
    protected String getAuthorizationBaseUrl() {
        return this.authorizationBaseUrl;
    }

    @Override
    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        return SalesforceJsonTokenExtractor.instance();
    }

    private static boolean isTLSv11orUpperEnabled(SSLSocket sSLSocket) {
        for (String string : sSLSocket.getEnabledProtocols()) {
            if (!"TLSv1.2".equals(string) && !"TLSv1.1".equals(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static void initTLSv11orUpper() throws NoSuchAlgorithmException, KeyManagementException, IOException {
        void var3_6;
        SSLSocket sSLSocket = (SSLSocket)SSLContext.getDefault().getSocketFactory().createSocket();
        if (SalesforceApi.isTLSv11orUpperEnabled(sSLSocket)) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (String string : sSLSocket.getSupportedProtocols()) {
            if ("TLSv1.2".equals(string)) {
                bl3 = true;
                break;
            }
            if (!"TLSv1.1".equals(string)) continue;
            bl2 = true;
        }
        if (bl3) {
            SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
        } else if (bl2) {
            SSLContext sSLContext = SSLContext.getInstance("TLSv1.1");
        } else {
            throw new NoSuchAlgorithmException("for Salesforce API to work you need jvm with TLS 1.1 or 1.2 support");
        }
        var3_6.init(null, null, null);
        SSLContext.setDefault((SSLContext)var3_6);
    }

    @Override
    public ClientAuthenticationType getClientAuthenticationType() {
        return ClientAuthenticationType.REQUEST_BODY;
    }

    private static class InstanceHolder {
        private static final SalesforceApi INSTANCE = new SalesforceApi("login.salesforce.com");

        private InstanceHolder() {
        }
    }
}

