/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.net.InetAddress;

public class InetAddressSerializer
extends StdScalarSerializer<InetAddress>
implements ContextualSerializer {
    protected final boolean _asNumeric;

    public InetAddressSerializer() {
        this(false);
    }

    public InetAddressSerializer(boolean bl2) {
        super(InetAddress.class);
        this._asNumeric = bl2;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonFormat.Shape shape;
        JsonFormat.Value value = this.findFormatOverrides(serializerProvider, beanProperty, this.handledType());
        boolean bl2 = false;
        if (value != null && ((shape = value.getShape()).isNumeric() || shape == JsonFormat.Shape.ARRAY)) {
            bl2 = true;
        }
        if (bl2 != this._asNumeric) {
            return new InetAddressSerializer(bl2);
        }
        return this;
    }

    @Override
    public void serialize(InetAddress inetAddress, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        String string;
        if (this._asNumeric) {
            string = inetAddress.getHostAddress();
        } else {
            string = inetAddress.toString().trim();
            int n2 = string.indexOf(47);
            if (n2 >= 0) {
                string = n2 == 0 ? string.substring(1) : string.substring(0, n2);
            }
        }
        jsonGenerator.writeString(string);
    }

    @Override
    public void serializeWithType(InetAddress inetAddress, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId((Object)inetAddress, InetAddress.class, JsonToken.VALUE_STRING));
        this.serialize(inetAddress, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }
}

