/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedAndMetadata;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;

public class StdKeyDeserializers
implements KeyDeserializers,
Serializable {
    private static final long serialVersionUID = 1L;

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver) {
        return new StdKeyDeserializer.EnumKD(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, AnnotatedMethod annotatedMethod) {
        return new StdKeyDeserializer.EnumKD(enumResolver, annotatedMethod);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, EnumResolver enumResolver2, EnumResolver enumResolver3, EnumResolver enumResolver4) {
        return new StdKeyDeserializer.EnumKD(enumResolver, null, enumResolver2, enumResolver3, enumResolver4);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, AnnotatedMethod annotatedMethod, EnumResolver enumResolver2, EnumResolver enumResolver3, EnumResolver enumResolver4) {
        return new StdKeyDeserializer.EnumKD(enumResolver, annotatedMethod, enumResolver2, enumResolver3, enumResolver4);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        return new StdKeyDeserializer.DelegatingKD(javaType.getRawClass(), jsonDeserializer);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType) throws JsonMappingException {
        BeanDescription beanDescription = deserializationConfig.introspectForCreation(javaType);
        AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode> annotatedAndMetadata2 = StdKeyDeserializers._findStringConstructor(beanDescription);
        if (annotatedAndMetadata2 != null && annotatedAndMetadata2.metadata != null) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(deserializationConfig, (AnnotatedMember)annotatedAndMetadata2.annotated);
        }
        List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> list = beanDescription.getFactoryMethodsWithMode();
        list.removeIf(annotatedAndMetadata -> ((AnnotatedMethod)annotatedAndMetadata.annotated).getParameterCount() != 1 || ((AnnotatedMethod)annotatedAndMetadata.annotated).getRawParameterType(0) != String.class || annotatedAndMetadata.metadata == JsonCreator.Mode.PROPERTIES);
        AnnotatedMethod annotatedMethod = StdKeyDeserializers._findExplicitStringFactoryMethod(list);
        if (annotatedMethod != null) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(deserializationConfig, annotatedMethod);
        }
        if (annotatedAndMetadata2 != null) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(deserializationConfig, (AnnotatedMember)annotatedAndMetadata2.annotated);
        }
        if (!list.isEmpty()) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(deserializationConfig, (AnnotatedMember)list.get((int)0).annotated);
        }
        return null;
    }

    private static KeyDeserializer _constructCreatorKeyDeserializer(DeserializationConfig deserializationConfig, AnnotatedMember annotatedMember) {
        if (annotatedMember instanceof AnnotatedConstructor) {
            AnnotatedElement annotatedElement = ((AnnotatedConstructor)annotatedMember).getAnnotated();
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess((Member)((Object)annotatedElement), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new StdKeyDeserializer.StringCtorKeyDeserializer((Constructor<?>)annotatedElement);
        }
        Method method = ((AnnotatedMethod)annotatedMember).getAnnotated();
        if (deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(method, deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new StdKeyDeserializer.StringFactoryKeyDeserializer(method);
    }

    private static AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode> _findStringConstructor(BeanDescription beanDescription) {
        for (AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode> annotatedAndMetadata : beanDescription.getConstructorsWithMode()) {
            AnnotatedConstructor annotatedConstructor = (AnnotatedConstructor)annotatedAndMetadata.annotated;
            if (annotatedConstructor.getParameterCount() != 1 || String.class != annotatedConstructor.getRawParameterType(0)) continue;
            return annotatedAndMetadata;
        }
        return null;
    }

    private static AnnotatedMethod _findExplicitStringFactoryMethod(List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> list) throws JsonMappingException {
        AnnotatedMethod annotatedMethod = null;
        for (AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode> annotatedAndMetadata : list) {
            if (annotatedAndMetadata.metadata == null) continue;
            if (annotatedMethod == null) {
                annotatedMethod = (AnnotatedMethod)annotatedAndMetadata.annotated;
                continue;
            }
            Class<?> clazz = ((AnnotatedMethod)annotatedAndMetadata.annotated).getDeclaringClass();
            throw new IllegalArgumentException("Multiple suitable annotated Creator factory methods to be used as the Key deserializer for type " + ClassUtil.nameOf(clazz));
        }
        return annotatedMethod;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (clazz.isPrimitive()) {
            clazz = ClassUtil.wrapperType(clazz);
        }
        return StdKeyDeserializer.forType(clazz);
    }
}

