/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.Card;
import atlantafx.base.controls.SlotListener;
import javafx.beans.value.ChangeListener;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class CardSkin
implements Skin<Card> {
    protected static final PseudoClass HAS_HEADER = PseudoClass.getPseudoClass((String)"has-header");
    protected static final PseudoClass HAS_SUBHEADER = PseudoClass.getPseudoClass((String)"has-subheader");
    protected static final PseudoClass HAS_BODY = PseudoClass.getPseudoClass((String)"has-body");
    protected static final PseudoClass HAS_FOOTER = PseudoClass.getPseudoClass((String)"has-footer");
    protected static final PseudoClass HAS_IMAGE = PseudoClass.getPseudoClass((String)"has-image");
    protected final Card control;
    protected final VBox root = new VBox();
    protected final StackPane headerSlot;
    protected final ChangeListener<Node> headerSlotListener;
    protected final StackPane subHeaderSlot;
    protected final ChangeListener<Node> subHeaderSlotListener;
    protected final StackPane bodySlot;
    protected final ChangeListener<Node> bodySlotListener;
    protected final StackPane footerSlot;
    protected final ChangeListener<Node> footerSlotListener;

    protected CardSkin(Card card) {
        this.control = card;
        this.headerSlot = new StackPane();
        this.headerSlot.getStyleClass().add((Object)"header");
        this.headerSlotListener = new SlotListener((Node)this.headerSlot, (node, bl2) -> this.getSkinnable().pseudoClassStateChanged(HAS_HEADER, (boolean)bl2));
        card.headerProperty().addListener(this.headerSlotListener);
        this.headerSlotListener.changed(card.headerProperty(), null, (Object)card.getHeader());
        this.subHeaderSlot = new StackPane();
        this.subHeaderSlot.getStyleClass().add((Object)"sub-header");
        this.subHeaderSlotListener = new SlotListener((Node)this.subHeaderSlot, (node, bl2) -> {
            this.getSkinnable().pseudoClassStateChanged(HAS_SUBHEADER, (boolean)bl2);
            this.getSkinnable().pseudoClassStateChanged(HAS_IMAGE, node instanceof ImageView);
        });
        card.subHeaderProperty().addListener(this.subHeaderSlotListener);
        this.subHeaderSlotListener.changed(card.subHeaderProperty(), null, (Object)card.getSubHeader());
        this.bodySlot = new StackPane();
        this.bodySlot.getStyleClass().add((Object)"body");
        VBox.setVgrow((Node)this.bodySlot, (Priority)Priority.ALWAYS);
        this.bodySlotListener = new SlotListener((Node)this.bodySlot, (node, bl2) -> this.getSkinnable().pseudoClassStateChanged(HAS_BODY, (boolean)bl2));
        card.bodyProperty().addListener(this.bodySlotListener);
        this.bodySlotListener.changed(card.bodyProperty(), null, (Object)card.getBody());
        this.footerSlot = new StackPane();
        this.footerSlot.getStyleClass().add((Object)"footer");
        this.footerSlotListener = new SlotListener((Node)this.footerSlot, (node, bl2) -> this.getSkinnable().pseudoClassStateChanged(HAS_FOOTER, (boolean)bl2));
        card.footerProperty().addListener(this.footerSlotListener);
        this.footerSlotListener.changed(card.footerProperty(), null, (Object)card.getFooter());
        this.root.getStyleClass().add((Object)"container");
        this.root.getChildren().setAll((Object[])new Node[]{this.headerSlot, this.subHeaderSlot, this.bodySlot, this.footerSlot});
    }

    public Card getSkinnable() {
        return this.control;
    }

    public Node getNode() {
        return this.root;
    }

    public void dispose() {
        this.control.headerProperty().removeListener(this.headerSlotListener);
        this.control.subHeaderProperty().removeListener(this.subHeaderSlotListener);
        this.control.bodyProperty().removeListener(this.bodySlotListener);
        this.control.footerProperty().removeListener(this.footerSlotListener);
    }
}

